/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.yahoo.cloud.config.RoutingConfig;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.util.Map;

public class RoutingProducer
implements RoutingConfig.Producer {
    static final ApplicationName ROUTING_APPLICATION = ApplicationName.from((String)"routing");
    private final Map<TenantName, Map<ApplicationId, ApplicationInfo>> models;

    public RoutingProducer(Map<TenantName, Map<ApplicationId, ApplicationInfo>> models) {
        this.models = models;
    }

    public void getConfig(RoutingConfig.Builder builder) {
        for (Map<ApplicationId, ApplicationInfo> model : this.models.values()) {
            model.values().stream().filter(application -> this.isHostedVespaRoutingApplication(application.getApplicationId())).forEach(application -> {
                for (HostInfo host : application.getModel().getHosts()) {
                    builder.hosts(host.getHostname());
                }
            });
        }
    }

    private boolean isHostedVespaRoutingApplication(ApplicationId applicationId) {
        return Tenants.HOSTED_VESPA_TENANT.equals((Object)applicationId.tenant()) && ROUTING_APPLICATION.equals((Object)applicationId.application());
    }
}

