/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Version;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class ApplicationMapper {
    private final Map<ApplicationId, ApplicationSet> requestHandlers = new ConcurrentHashMap<ApplicationId, ApplicationSet>();

    private ApplicationSet getApplicationSet(ApplicationId applicationId) {
        ApplicationSet list = this.requestHandlers.get(applicationId);
        if (list != null) {
            return list;
        }
        throw new NotFoundException("No such application id: " + applicationId);
    }

    public void register(ApplicationId applicationId, ApplicationSet applicationSet) {
        this.requestHandlers.put(applicationId, applicationSet);
    }

    public void remove(ApplicationId applicationId) {
        this.requestHandlers.remove(applicationId);
    }

    public Application getForVersion(ApplicationId applicationId, Optional<Version> vespaVersion, Instant now) throws VersionDoesNotExistException {
        return this.getApplicationSet(applicationId).getForVersionOrLatest(vespaVersion, now);
    }

    public boolean hasApplication(ApplicationId applicationId, Instant now) {
        return this.hasApplicationForVersion(applicationId, Optional.empty(), now);
    }

    public boolean hasApplicationForVersion(ApplicationId applicationId, Optional<Version> vespaVersion, Instant now) {
        try {
            return this.getForVersion(applicationId, vespaVersion, now) != null;
        }
        catch (NotFoundException | VersionDoesNotExistException ex) {
            return false;
        }
    }

    public int numApplications() {
        return this.requestHandlers.size();
    }
}

