/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.application.ZKTenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactoryFactory;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.RemoteSessionFactory;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SessionFactoryImpl;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRequestHandler;
import com.yahoo.vespa.config.server.zookeeper.SessionCounter;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.time.Clock;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TenantBuilder {
    private final Path tenantPath;
    private final GlobalComponentRegistry componentRegistry;
    private final TenantName tenant;
    private final Path sessionsPath;
    private RemoteSessionRepo remoteSessionRepo;
    private LocalSessionRepo localSessionRepo;
    private SessionFactory sessionFactory;
    private LocalSessionLoader localSessionLoader;
    private TenantApplications applicationRepo;
    private SessionCounter sessionCounter;
    private ReloadHandler reloadHandler;
    private RequestHandler requestHandler;
    private RemoteSessionFactory remoteSessionFactory;
    private TenantFileSystemDirs tenantFileSystemDirs;
    private HostValidator<ApplicationId> hostValidator;
    private Clock clock = Clock.systemUTC();

    private TenantBuilder(GlobalComponentRegistry componentRegistry, TenantName tenant, Path zkPath) {
        this.componentRegistry = componentRegistry;
        this.tenantPath = zkPath;
        this.tenant = tenant;
        this.sessionsPath = this.tenantPath.append("sessions");
    }

    public static TenantBuilder create(GlobalComponentRegistry componentRegistry, TenantName tenant, Path zkPath) {
        return new TenantBuilder(componentRegistry, tenant, zkPath);
    }

    public TenantBuilder withSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    public TenantBuilder withLocalSessionRepo(LocalSessionRepo localSessionRepo) {
        this.localSessionRepo = localSessionRepo;
        return this;
    }

    public TenantBuilder withRemoteSessionRepo(RemoteSessionRepo remoteSessionRepo) {
        this.remoteSessionRepo = remoteSessionRepo;
        return this;
    }

    public TenantBuilder withApplicationRepo(TenantApplications applicationRepo) {
        this.applicationRepo = applicationRepo;
        return this;
    }

    public TenantBuilder withRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
        return this;
    }

    public TenantBuilder withReloadHandler(ReloadHandler reloadHandler) {
        this.reloadHandler = reloadHandler;
        return this;
    }

    public TenantBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public Tenant build() throws Exception {
        this.createTenantRequestHandler();
        this.createApplicationRepo();
        this.createRemoteSessionFactory(this.clock);
        this.createRemoteSessionRepo();
        this.createSessionCounter();
        this.createServerDbDirs();
        this.createSessionFactory();
        this.createLocalSessionRepo();
        return new Tenant(this.tenant, this.tenantPath, this.sessionFactory, this.localSessionRepo, this.remoteSessionRepo, this.requestHandler, this.reloadHandler, this.applicationRepo, this.componentRegistry.getCurator(), this.tenantFileSystemDirs);
    }

    private void createLocalSessionRepo() {
        if (this.localSessionRepo == null) {
            this.localSessionRepo = new LocalSessionRepo(this.tenantFileSystemDirs, this.localSessionLoader, this.applicationRepo, Clock.systemUTC(), this.componentRegistry.getConfigserverConfig().sessionLifetime());
        }
    }

    private void createSessionFactory() {
        if (this.sessionFactory == null || this.localSessionLoader == null) {
            SessionFactoryImpl impl = new SessionFactoryImpl(this.componentRegistry, this.sessionCounter, this.sessionsPath, this.applicationRepo, this.tenantFileSystemDirs, this.hostValidator, this.tenant);
            if (this.sessionFactory == null) {
                this.sessionFactory = impl;
            }
            if (this.localSessionLoader == null) {
                this.localSessionLoader = impl;
            }
        }
    }

    private void createApplicationRepo() {
        if (this.applicationRepo == null) {
            this.applicationRepo = ZKTenantApplications.create(this.componentRegistry.getCurator(), this.tenantPath.append("applications"), this.reloadHandler, this.tenant);
        }
    }

    private void createSessionCounter() {
        if (this.sessionCounter == null) {
            this.sessionCounter = new SessionCounter(this.componentRegistry.getCurator(), this.tenantPath, this.sessionsPath);
        }
    }

    private void createTenantRequestHandler() {
        if (this.requestHandler == null || this.reloadHandler == null) {
            TenantRequestHandler impl = new TenantRequestHandler(this.componentRegistry.getMetrics(), this.tenant, Collections.singletonList(this.componentRegistry.getReloadListener()), ConfigResponseFactoryFactory.createFactory(this.componentRegistry.getConfigserverConfig()), this.componentRegistry.getHostRegistries());
            if (this.hostValidator == null) {
                this.hostValidator = impl;
            }
            if (this.requestHandler == null) {
                this.requestHandler = impl;
            }
            if (this.reloadHandler == null) {
                this.reloadHandler = impl;
            }
        }
    }

    private void createRemoteSessionFactory(Clock clock) {
        if (this.remoteSessionFactory == null) {
            this.remoteSessionFactory = new RemoteSessionFactory(this.componentRegistry, this.sessionsPath, this.tenant, clock);
        }
    }

    private void createRemoteSessionRepo() throws Exception {
        if (this.remoteSessionRepo == null) {
            this.remoteSessionRepo = new RemoteSessionRepo(this.componentRegistry.getCurator(), this.remoteSessionFactory, this.reloadHandler, this.sessionsPath, this.applicationRepo, this.componentRegistry.getMetrics().getOrCreateMetricUpdater(Metrics.createDimensions(this.tenant)), this.createSingleThreadedExecutorService(RemoteSessionRepo.class.getName()));
        }
    }

    private ExecutorService createSingleThreadedExecutorService(String executorName) {
        return Executors.newSingleThreadExecutor(ThreadFactoryFactory.getThreadFactory((String)(executorName + "-" + this.tenant.value())));
    }

    private void createServerDbDirs() {
        if (this.tenantFileSystemDirs == null) {
            this.tenantFileSystemDirs = new TenantFileSystemDirs(new File(Defaults.getDefaults().underVespaHome(this.componentRegistry.getServerDB().getConfigserverConfig().configServerDBDir())), this.tenant);
        }
    }

    public LocalSessionRepo getLocalSessionRepo() {
        return this.localSessionRepo;
    }

    public TenantApplications getApplicationRepo() {
        return this.applicationRepo;
    }
}

