/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.StaticConfigDefinitionRepo;
import com.yahoo.vespa.config.server.deploy.ZooKeeperClient;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.session.ServerCacheLoader;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationPackage;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionZooKeeperClient {
    private static final Logger log = Logger.getLogger(SessionZooKeeperClient.class.getName());
    static final String APPLICATION_ID_PATH = "applicationId";
    static final String VERSION_PATH = "version";
    static final String CREATE_TIME_PATH = "createTime";
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final Path rootPath;
    private final Path sessionStatusPath;
    private final String serverId;
    private final ServerCacheLoader cacheLoader;
    private final Optional<NodeFlavors> nodeFlavors;
    private static final String PREPARE_BARRIER = "prepareBarrier";
    private static final String ACTIVE_BARRIER = "activeBarrier";
    private static final String UPLOAD_BARRIER = "uploadBarrier";

    public SessionZooKeeperClient(Curator curator, Path rootPath) {
        this(curator, ConfigCurator.create(curator), rootPath, new StaticConfigDefinitionRepo(), "", Optional.empty());
    }

    public SessionZooKeeperClient(Curator curator, ConfigCurator configCurator, Path rootPath, ConfigDefinitionRepo definitionRepo, String serverId, Optional<NodeFlavors> nodeFlavors) {
        this.curator = curator;
        this.configCurator = configCurator;
        this.rootPath = rootPath;
        this.serverId = serverId;
        this.nodeFlavors = nodeFlavors;
        this.sessionStatusPath = rootPath.append("/sessionState");
        this.cacheLoader = new ServerCacheLoader(configCurator, rootPath, definitionRepo);
    }

    public void writeStatus(Session.Status sessionStatus) {
        try {
            this.createWriteStatusTransaction(sessionStatus).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write session status", e);
        }
    }

    public Session.Status readStatus() {
        try {
            String data = this.configCurator.getData(this.sessionStatusPath.getAbsolute());
            return Session.Status.parse(data);
        }
        catch (Exception e) {
            log.log(LogLevel.INFO, "Unable to read session status, assuming it was deleted");
            return Session.Status.NONE;
        }
    }

    Curator.CompletionWaiter createPrepareWaiter() {
        return this.createCompletionWaiter(PREPARE_BARRIER);
    }

    Curator.CompletionWaiter createActiveWaiter() {
        return this.createCompletionWaiter(ACTIVE_BARRIER);
    }

    Curator.CompletionWaiter getPrepareWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(PREPARE_BARRIER));
    }

    Curator.CompletionWaiter getActiveWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(ACTIVE_BARRIER));
    }

    Curator.CompletionWaiter getUploadWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(UPLOAD_BARRIER));
    }

    private Path getWaiterPath(String barrierName) {
        return this.rootPath.append(barrierName);
    }

    private int getNumberOfMembers() {
        return this.curator.serverCount() / 2 + 1;
    }

    private Curator.CompletionWaiter createCompletionWaiter(String waiterNode) {
        return this.curator.createCompletionWaiter(this.rootPath, waiterNode, this.getNumberOfMembers(), this.serverId);
    }

    private Curator.CompletionWaiter getCompletionWaiter(Path path) {
        return this.curator.getCompletionWaiter(path, this.getNumberOfMembers(), this.serverId);
    }

    public void delete() {
        try {
            log.log((Level)LogLevel.DEBUG, "Deleting " + this.rootPath.getAbsolute());
            this.configCurator.deleteRecurse(this.rootPath.getAbsolute());
        }
        catch (RuntimeException e) {
            log.log(LogLevel.INFO, "Error deleting session (" + this.rootPath.getAbsolute() + ") from zookeeper");
        }
    }

    public CuratorTransaction deleteTransaction() {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.rootPath.getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public ApplicationPackage loadApplicationPackage() {
        return new ZKApplicationPackage(this.configCurator, this.rootPath, this.nodeFlavors);
    }

    public ServerCache loadServerCache() {
        return this.cacheLoader.loadCache();
    }

    private String applicationIdPath() {
        return this.rootPath.append(APPLICATION_ID_PATH).getAbsolute();
    }

    public void writeApplicationId(ApplicationId id) {
        this.configCurator.putData(this.applicationIdPath(), id.serializedForm());
    }

    public ApplicationId readApplicationId() {
        if (!this.configCurator.exists(this.applicationIdPath())) {
            return ApplicationId.defaultId();
        }
        return ApplicationId.fromSerializedForm((String)this.configCurator.getData(this.applicationIdPath()));
    }

    private String versionPath() {
        return this.rootPath.append(VERSION_PATH).getAbsolute();
    }

    public void writeVespaVersion(Version version) {
        this.configCurator.putData(this.versionPath(), version.toString());
    }

    public Version readVespaVersion() {
        if (!this.configCurator.exists(this.versionPath())) {
            return Vtag.currentVersion;
        }
        return new Version(this.configCurator.getData(this.versionPath()));
    }

    public long readCreateTime() {
        String path = this.getCreateTimePath();
        if (!this.configCurator.exists(path)) {
            return 0L;
        }
        return Long.parseLong(this.configCurator.getData(path));
    }

    private String getCreateTimePath() {
        return this.rootPath.append(CREATE_TIME_PATH).getAbsolute();
    }

    AllocatedHosts getAllocatedHosts() {
        return (AllocatedHosts)this.loadApplicationPackage().getAllocatedHosts().orElseThrow(() -> new IllegalStateException("Allocated hosts does not exists"));
    }

    public ZooKeeperDeployer createDeployer(DeployLogger logger) {
        ZooKeeperClient zkClient = new ZooKeeperClient(this.configCurator, logger, true, this.rootPath);
        return new ZooKeeperDeployer(zkClient);
    }

    public Transaction createWriteStatusTransaction(Session.Status status) {
        String path = this.sessionStatusPath.getAbsolute();
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        if (this.configCurator.exists(path)) {
            transaction.add((Transaction.Operation)CuratorOperations.setData((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        } else {
            transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        }
        return transaction;
    }

    public void createNewSession(long createTime, TimeUnit timeUnit) {
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.rootPath.getAbsolute()));
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.rootPath.append(UPLOAD_BARRIER).getAbsolute()));
        transaction.add(this.createWriteStatusTransaction(Session.Status.NEW).operations());
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.getCreateTimePath(), (byte[])Utf8.toBytes((String)String.valueOf(timeUnit.toSeconds(createTime)))));
        transaction.commit();
    }
}

