/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.GenerationCounter;
import com.yahoo.vespa.config.server.ApplicationListener;
import com.yahoo.vespa.config.server.SuperModelListener;
import com.yahoo.vespa.config.server.SuperModelProvider;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.model.SuperModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SuperModelManager
implements SuperModelProvider,
ApplicationListener {
    private final Zone zone;
    private SuperModel superModel;
    private final List<SuperModelListener> listeners = new ArrayList<SuperModelListener>();
    private long generation;
    private final long masterGeneration;
    private final GenerationCounter generationCounter;

    @Inject
    public SuperModelManager(ConfigserverConfig configserverConfig, NodeFlavors nodeFlavors, GenerationCounter generationCounter) {
        this.zone = new Zone(configserverConfig, nodeFlavors);
        this.generationCounter = generationCounter;
        this.masterGeneration = configserverConfig.masterGeneration();
        this.makeNewSuperModel(new HashMap<TenantName, Map<ApplicationId, Application>>());
    }

    @Override
    public synchronized SuperModel getSuperModel() {
        return this.superModel;
    }

    @Override
    public synchronized long getGeneration() {
        return this.generation;
    }

    @Override
    public synchronized void registerListener(SuperModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void configActivated(TenantName tenant, ApplicationSet applicationSet) {
        Map<TenantName, Map<ApplicationId, Application>> newModels = this.createModelCopy();
        if (!newModels.containsKey(tenant)) {
            newModels.put(tenant, new LinkedHashMap());
        }
        Application application = applicationSet.getForVersionOrLatest(Optional.empty(), Instant.now());
        newModels.get(tenant).put(applicationSet.getId(), application);
        this.makeNewSuperModel(newModels);
        this.listeners.stream().forEach(listener -> listener.applicationActivated(this.superModel, application));
    }

    @Override
    public synchronized void applicationRemoved(ApplicationId applicationId) {
        Map<TenantName, Map<ApplicationId, Application>> newModels = this.createModelCopy();
        if (newModels.containsKey(applicationId.tenant())) {
            newModels.get(applicationId.tenant()).remove(applicationId);
            if (newModels.get(applicationId.tenant()).isEmpty()) {
                newModels.remove(applicationId.tenant());
            }
        }
        this.makeNewSuperModel(newModels);
        this.listeners.stream().forEach(listener -> listener.applicationRemoved(this.superModel, applicationId));
    }

    private void makeNewSuperModel(Map<TenantName, Map<ApplicationId, Application>> newModels) {
        this.generation = this.masterGeneration + this.generationCounter.get();
        this.superModel = new SuperModel(newModels, this.zone);
    }

    private Map<TenantName, Map<ApplicationId, Application>> createModelCopy() {
        Map<TenantName, Map<ApplicationId, Application>> currentModels = this.superModel.applicationModels();
        LinkedHashMap<TenantName, Map<ApplicationId, Application>> newModels = new LinkedHashMap<TenantName, Map<ApplicationId, Application>>();
        for (Map.Entry<TenantName, Map<ApplicationId, Application>> entry : currentModels.entrySet()) {
            LinkedHashMap<ApplicationId, Application> appMap = new LinkedHashMap<ApplicationId, Application>();
            newModels.put(entry.getKey(), appMap);
            for (Map.Entry<ApplicationId, Application> appEntry : entry.getValue().entrySet()) {
                appMap.put(appEntry.getKey(), appEntry.getValue());
            }
        }
        return newModels;
    }
}

