/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepo;
import java.io.File;
import java.io.FilenameFilter;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class LocalSessionRepo
extends SessionRepo<LocalSession> {
    private static final Logger log = Logger.getLogger(LocalSessionRepo.class.getName());
    private static final FilenameFilter sessionApplicationsFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.matches("\\d+");
        }
    };
    private final long sessionLifetime;
    private final TenantApplications applicationRepo;
    private final Clock clock;

    public LocalSessionRepo(TenantFileSystemDirs tenantFileSystemDirs, LocalSessionLoader loader, TenantApplications applicationRepo, Clock clock, long sessionLifeTime) {
        this(applicationRepo, clock, sessionLifeTime);
        this.loadSessions(tenantFileSystemDirs.path(), loader);
    }

    private void loadSessions(File applicationsDir, LocalSessionLoader loader) {
        File[] applications = applicationsDir.listFiles(sessionApplicationsFilter);
        if (applications == null) {
            return;
        }
        for (File application : applications) {
            try {
                this.addSession(loader.loadSession(Long.parseLong(application.getName())));
            }
            catch (IllegalArgumentException e) {
                log.log(LogLevel.WARNING, "Could not load application '" + application.getAbsolutePath() + "':" + e.getMessage() + ", skipping it.");
            }
        }
    }

    public LocalSession getActiveSession(ApplicationId applicationId) {
        List<ApplicationId> applicationIds = this.applicationRepo.listApplications();
        if (applicationIds.contains(applicationId)) {
            return (LocalSession)this.getSession(this.applicationRepo.getSessionIdForApplication(applicationId));
        }
        return null;
    }

    public LocalSessionRepo(TenantApplications applicationRepo, Clock clock, long sessionLifetime) {
        this.applicationRepo = applicationRepo;
        this.sessionLifetime = sessionLifetime;
        this.clock = clock;
    }

    public LocalSessionRepo(TenantApplications applicationRepo) {
        this(applicationRepo, Clock.systemUTC(), TimeUnit.DAYS.toMillis(1L));
    }

    @Override
    public synchronized void addSession(LocalSession session) {
        this.purgeOldSessions();
        super.addSession(session);
    }

    private void purgeOldSessions() {
        List<ApplicationId> applicationIds = this.applicationRepo.listApplications();
        ArrayList sessions = new ArrayList(this.listSessions());
        for (LocalSession candidate : sessions) {
            if (!this.hasExpired(candidate) || this.isActiveSession(candidate, applicationIds)) continue;
            this.deleteSession(candidate);
        }
    }

    private boolean hasExpired(LocalSession candidate) {
        return candidate.getCreateTime() + this.sessionLifetime <= TimeUnit.MILLISECONDS.toSeconds(this.clock.millis());
    }

    private boolean isActiveSession(LocalSession candidate, List<ApplicationId> activeIds) {
        if (candidate.getStatus() == Session.Status.ACTIVATE && activeIds.contains(candidate.getApplicationId())) {
            long sessionId = this.applicationRepo.getSessionIdForApplication(candidate.getApplicationId());
            return candidate.getSessionId() == sessionId;
        }
        return false;
    }

    private void deleteSession(LocalSession candidate) {
        this.removeSessionOrThrow(candidate.getSessionId());
        candidate.delete();
    }

    public void deleteAllSessions() {
        ArrayList sessions = new ArrayList(this.listSessions());
        for (LocalSession session : sessions) {
            this.deleteSession(session);
        }
    }
}

