/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GenerationCounter;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.SuperModelController;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.model.SuperModel;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactoryFactory;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuperModelRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(SuperModelRequestHandler.class.getName());
    private volatile SuperModelController handler;
    private final GenerationCounter generationCounter;
    private final Zone zone;
    private final long masterGeneration;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final ConfigResponseFactory responseFactory;
    private volatile boolean enabled = false;

    @Inject
    public SuperModelRequestHandler(GenerationCounter generationCounter, ConfigDefinitionRepo configDefinitionRepo, ConfigserverConfig configserverConfig, NodeFlavors nodeFlavors) {
        this.generationCounter = generationCounter;
        this.configDefinitionRepo = configDefinitionRepo;
        this.masterGeneration = configserverConfig.masterGeneration();
        this.responseFactory = ConfigResponseFactoryFactory.createFactory(configserverConfig);
        this.zone = new Zone(configserverConfig, nodeFlavors);
        this.handler = this.createNewHandler(Collections.emptyMap());
    }

    public synchronized void reloadConfig(TenantName tenant, ApplicationSet applicationSet) {
        Map<TenantName, Map<ApplicationId, Application>> newModels = this.createModelCopy();
        if (!newModels.containsKey(tenant)) {
            newModels.put(tenant, new LinkedHashMap());
        }
        newModels.get(tenant).put(applicationSet.getId(), applicationSet.getForVersionOrLatest(Optional.empty(), Instant.now()));
        this.handler = this.createNewHandler(newModels);
    }

    public synchronized void removeApplication(ApplicationId applicationId) {
        Map<TenantName, Map<ApplicationId, Application>> newModels = this.createModelCopy();
        if (newModels.containsKey(applicationId.tenant())) {
            newModels.get(applicationId.tenant()).remove(applicationId);
            if (newModels.get(applicationId.tenant()).isEmpty()) {
                newModels.remove(applicationId.tenant());
            }
        }
        this.handler = this.createNewHandler(newModels);
    }

    private SuperModelController createNewHandler(Map<TenantName, Map<ApplicationId, Application>> newModels) {
        long generation = this.generationCounter.get() + this.masterGeneration;
        SuperModel model = new SuperModel(newModels, this.zone);
        return new SuperModelController(model, this.configDefinitionRepo, generation, this.responseFactory);
    }

    private Map<TenantName, Map<ApplicationId, Application>> getCurrentModels() {
        if (this.handler != null) {
            return this.handler.getSuperModel().applicationModels();
        }
        return new LinkedHashMap<TenantName, Map<ApplicationId, Application>>();
    }

    private Map<TenantName, Map<ApplicationId, Application>> createModelCopy() {
        Map<TenantName, Map<ApplicationId, Application>> currentModels = this.getCurrentModels();
        LinkedHashMap<TenantName, Map<ApplicationId, Application>> newModels = new LinkedHashMap<TenantName, Map<ApplicationId, Application>>();
        for (Map.Entry<TenantName, Map<ApplicationId, Application>> entry : currentModels.entrySet()) {
            LinkedHashMap<ApplicationId, Application> appMap = new LinkedHashMap<ApplicationId, Application>();
            newModels.put(entry.getKey(), appMap);
            for (Map.Entry<ApplicationId, Application> appEntry : entry.getValue().entrySet()) {
                appMap.put(appEntry.getKey(), appEntry.getValue());
            }
        }
        return newModels;
    }

    public SuperModelController getHandler() {
        return this.handler;
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        log.log((Level)LogLevel.DEBUG, () -> "SuperModelRequestHandler resolving " + req + " for app id '" + appId + "'");
        if (this.handler != null) {
            ConfigResponse configResponse = this.handler.resolveConfig(req);
            log.log((Level)LogLevel.DEBUG, () -> "SuperModelRequestHandler returning response for config " + req + " with generation " + configResponse.getGeneration());
            return configResponse;
        }
        return null;
    }

    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ApplicationId applicationId, String configId) throws IOException {
        return this.handler.getConfig(configClass, applicationId, configId);
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> key, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appID, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.enabled && appId.equals((Object)ApplicationId.global());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        return ApplicationId.global();
    }

    public void enable() {
        this.enabled = true;
    }
}

