/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.ConfigDefinitionDir;
import com.yahoo.config.model.application.provider.Bundle;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigServerDB {
    private static final Logger log = Logger.getLogger(ConfigServerDB.class.getName());
    private final File serverDB;
    private final ConfigserverConfig configserverConfig;

    public ConfigServerDB(ConfigserverConfig configserverConfig) {
        this.configserverConfig = configserverConfig;
        this.serverDB = new File(Defaults.getDefaults().underVespaHome(configserverConfig.configServerDBDir()));
        this.create();
        try {
            this.initialize(configserverConfig.configModelPluginDir());
        }
        catch (IllegalArgumentException e) {
            log.log((Level)LogLevel.ERROR, "Error initializing serverdb: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize server db", e);
        }
    }

    public static ConfigServerDB createTestConfigServerDb(String dir) {
        return new ConfigServerDB(new ConfigserverConfig(new ConfigserverConfig.Builder().configServerDBDir(dir)));
    }

    public File dest() {
        return new File(this.serverDB, "configs");
    }

    public File classes() {
        return new File(this.serverDB, "classes");
    }

    public File vespaapps() {
        return new File(this.serverDB, "vespaapps");
    }

    public File serverdefs() {
        return new File(this.serverDB, "serverdefs");
    }

    public void create() {
        ConfigServerDB.cr(this.dest());
        ConfigServerDB.cr(this.classes());
        ConfigServerDB.cr(this.vespaapps());
        ConfigServerDB.cr(this.serverdefs());
    }

    public static void cr(File d) {
        if (d.exists()) {
            if (!d.isDirectory()) {
                throw new IllegalArgumentException(d.getAbsolutePath() + " exists, but isn't a directory.");
            }
        } else if (!d.mkdirs()) {
            throw new IllegalArgumentException("Couldn't create " + d.getAbsolutePath());
        }
    }

    private void initialize(List<String> pluginDirectories) throws IOException {
        IOUtils.recursiveDeleteDir((File)this.serverdefs());
        IOUtils.copyDirectory((File)this.classes(), (File)this.serverdefs());
        ConfigDefinitionDir configDefinitionDir = new ConfigDefinitionDir(this.serverdefs());
        ArrayList bundles = new ArrayList();
        for (String pluginDirectory : pluginDirectories) {
            bundles.addAll(Bundle.getBundles((File)new File(pluginDirectory)));
        }
        log.log((Level)LogLevel.DEBUG, "Found " + bundles.size() + " bundles");
        ArrayList<Bundle> addedBundles = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            log.log((Level)LogLevel.DEBUG, "Bundle in " + bundle.getFile().getAbsolutePath() + " appears to contain " + bundle.getDefEntries().size() + " entries");
            configDefinitionDir.addConfigDefinitionsFromBundle(bundle, addedBundles);
            addedBundles.add(bundle);
        }
    }

    public ConfigserverConfig getConfigserverConfig() {
        return this.configserverConfig;
    }
}

