/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostLivenessTracker;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Version;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.JRTMethods;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequestV3;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.server.GetConfigContext;
import com.yahoo.vespa.config.server.ReloadListener;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.SuperModelRequestHandler;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.MetricUpdaterFactory;
import com.yahoo.vespa.config.server.rpc.DelayedConfigResponses;
import com.yahoo.vespa.config.server.rpc.GetConfigProcessor;
import com.yahoo.vespa.config.server.tenant.TenantHandlerProvider;
import com.yahoo.vespa.config.server.tenant.TenantListener;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServer
implements Runnable,
ReloadListener,
TenantListener {
    public static final String getConfigMethodName = "getConfigV3";
    static final int TRACELEVEL = 6;
    static final int TRACELEVEL_DEBUG = 9;
    private static final String THREADPOOL_NAME = "rpcserver worker pool";
    private static final long SHUTDOWN_TIMEOUT = 60L;
    private final Supervisor supervisor = new Supervisor(new Transport());
    private Spec spec = null;
    private final boolean useRequestVersion;
    private final boolean hostedVespa;
    private static final Logger log = Logger.getLogger(RpcServer.class.getName());
    final DelayedConfigResponses delayedConfigResponses;
    private final HostRegistry<TenantName> hostRegistry;
    private final Map<TenantName, TenantHandlerProvider> tenantProviders = new ConcurrentHashMap<TenantName, TenantHandlerProvider>();
    private final SuperModelRequestHandler superModelRequestHandler;
    private final MetricUpdater metrics;
    private final MetricUpdaterFactory metricUpdaterFactory;
    private final HostLivenessTracker hostLivenessTracker;
    private final ThreadPoolExecutor executorService;
    private volatile boolean allTenantsLoaded = false;

    @Inject
    public RpcServer(ConfigserverConfig config, SuperModelRequestHandler superModelRequestHandler, MetricUpdaterFactory metrics, HostRegistries hostRegistries, HostLivenessTracker hostLivenessTracker) {
        this.superModelRequestHandler = superModelRequestHandler;
        this.metricUpdaterFactory = metrics;
        this.supervisor.setMaxOutputBufferSize(config.maxoutputbuffersize());
        this.metrics = metrics.getOrCreateMetricUpdater(Collections.emptyMap());
        this.hostLivenessTracker = hostLivenessTracker;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(config.maxgetconfigclients());
        this.executorService = new ThreadPoolExecutor(config.numthreads(), config.numthreads(), 0L, TimeUnit.SECONDS, workQueue, ThreadFactoryFactory.getThreadFactory((String)THREADPOOL_NAME));
        this.delayedConfigResponses = new DelayedConfigResponses(this, config.numDelayedResponseThreads());
        this.spec = new Spec(null, config.rpcport());
        this.hostRegistry = hostRegistries.getTenantHostRegistry();
        this.useRequestVersion = config.useVespaVersionInRequest();
        this.hostedVespa = config.hostedVespa();
        this.setUpHandlers();
    }

    public final void getConfigV3(Request req) {
        if (log.isLoggable((Level)LogLevel.SPAM)) {
            log.log((Level)LogLevel.SPAM, getConfigMethodName);
        }
        req.detach();
        JRTServerConfigRequestV3 request = JRTServerConfigRequestV3.createFromRequest((Request)req);
        this.addToRequestQueue((JRTServerConfigRequest)request);
        this.hostLivenessTracker.receivedRequestFrom(request.getClientHostName());
    }

    public final void ping(Request req) {
        req.returnValues().add((Value)new Int32Value(0));
    }

    public final void printStatistics(Request req) {
        req.returnValues().add((Value)new StringValue("Delayed responses queue size: " + this.delayedConfigResponses.size()));
    }

    @Override
    public void run() {
        log.log((Level)LogLevel.DEBUG, "Ready for requests on " + this.spec);
        try {
            Acceptor acceptor = this.supervisor.listen(this.spec);
            this.supervisor.transport().join();
            acceptor.shutdown().join();
        }
        catch (ListenFailedException e) {
            this.stop();
            throw new RuntimeException("Could not listen at " + this.spec, e);
        }
    }

    public void stop() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.delayedConfigResponses.stop();
        this.supervisor.transport().shutdown().join();
    }

    private void setUpHandlers() {
        this.getSupervisor().addMethod(JRTMethods.createConfigV3GetConfigMethod((Object)this, (String)getConfigMethodName));
        this.getSupervisor().addMethod(new Method("ping", "", "i", (Object)this, "ping").methodDesc("ping").returnDesc(0, "ret code", "return code, 0 is OK"));
        this.getSupervisor().addMethod(new Method("printStatistics", "", "s", (Object)this, "printStatistics").methodDesc("printStatistics").returnDesc(0, "statistics", "Statistics for server"));
    }

    @Override
    public void configReloaded(TenantName tenant, ApplicationSet applicationSet) {
        ApplicationId applicationId = applicationSet.getId();
        this.configReloaded(this.delayedConfigResponses.drainQueue(applicationId), Tenants.logPre(applicationId));
        this.reloadSuperModel(tenant, applicationSet);
    }

    private void reloadSuperModel(TenantName tenant, ApplicationSet applicationSet) {
        this.superModelRequestHandler.reloadConfig(tenant, applicationSet);
        this.configReloaded(this.delayedConfigResponses.drainQueue(ApplicationId.global()), Tenants.logPre(ApplicationId.global()));
    }

    private void configReloaded(List<DelayedConfigResponses.DelayedConfigResponse> responses, String logPre) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, logPre + "Start of configReload: " + responses.size() + " requests on delayed requests queue");
        }
        int responsesSent = 0;
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(this.executorService);
        while (!responses.isEmpty()) {
            DelayedConfigResponses.DelayedConfigResponse delayedConfigResponse = responses.remove(0);
            if (delayedConfigResponse.cancel()) {
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    this.logRequestDebug(LogLevel.DEBUG, logPre + "Timer cancelled for ", delayedConfigResponse.request);
                }
                if (!this.addToRequestQueue(delayedConfigResponse.request, false, completionService).booleanValue()) continue;
                ++responsesSent;
                continue;
            }
            log.log((Level)LogLevel.DEBUG, logPre + "Timer already cancelled or finished or never scheduled");
        }
        for (int i = 0; i < responsesSent; ++i) {
            try {
                completionService.take();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        log.log((Level)LogLevel.DEBUG, logPre + "Finished reloading " + responsesSent + " requests");
    }

    private void logRequestDebug(LogLevel level, String message, JRTServerConfigRequest request) {
        if (log.isLoggable((Level)level)) {
            log.log((Level)level, message + request.getShortDescription());
        }
    }

    @Override
    public void hostsUpdated(TenantName tenant, Collection<String> newHosts) {
        log.log((Level)LogLevel.DEBUG, "Updating hosts in tenant host registry '" + this.hostRegistry + "' with " + newHosts);
        this.hostRegistry.update(tenant, newHosts);
    }

    @Override
    public void verifyHostsAreAvailable(TenantName tenant, Collection<String> newHosts) {
        this.hostRegistry.verifyHosts(tenant, newHosts);
    }

    @Override
    public void applicationRemoved(ApplicationId applicationId) {
        this.superModelRequestHandler.removeApplication(applicationId);
        this.configReloaded(this.delayedConfigResponses.drainQueue(applicationId), Tenants.logPre(applicationId));
        this.configReloaded(this.delayedConfigResponses.drainQueue(ApplicationId.global()), Tenants.logPre(ApplicationId.global()));
    }

    public void respond(JRTServerConfigRequest request) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Trace at request return:\n" + request.getRequestTrace().toString());
        }
        request.getRequest().returnRequest();
    }

    public Optional<TenantName> resolveTenant(JRTServerConfigRequest request, Trace trace) {
        if ("*".equals(request.getConfigKey().getConfigId())) {
            return Optional.of(ApplicationId.global().tenant());
        }
        String hostname = request.getClientHostName();
        TenantName tenant = this.hostRegistry.getKeyForHost(hostname);
        if (tenant == null) {
            if (GetConfigProcessor.logDebug(trace)) {
                String message = "Did not find tenant for host '" + hostname + "', using " + TenantName.defaultName();
                log.log((Level)LogLevel.DEBUG, message);
                log.log((Level)LogLevel.DEBUG, "hosts in host registry: " + this.hostRegistry.getAllHosts());
                trace.trace(6, message);
            }
            return Optional.empty();
        }
        return Optional.of(tenant);
    }

    public ConfigResponse resolveConfig(JRTServerConfigRequest request, GetConfigContext context, Optional<Version> vespaVersion) {
        context.trace().trace(6, "RpcServer.resolveConfig()");
        return context.requestHandler().resolveConfig(context.applicationId(), (GetConfigRequest)request, vespaVersion);
    }

    protected Supervisor getSupervisor() {
        return this.supervisor;
    }

    Boolean addToRequestQueue(JRTServerConfigRequest request) {
        return this.addToRequestQueue(request, false, null);
    }

    public Boolean addToRequestQueue(JRTServerConfigRequest request, boolean forceResponse, CompletionService<Boolean> completionService) {
        request.setDelayedResponse(false);
        try {
            final GetConfigProcessor task = new GetConfigProcessor(this, request, forceResponse);
            if (completionService == null) {
                this.executorService.submit(task);
            } else {
                completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        task.run();
                        return true;
                    }
                });
            }
            this.updateWorkQueueMetrics();
            return true;
        }
        catch (RejectedExecutionException e) {
            request.addErrorResponse(100200, "getConfig request queue size is larger than configured max limit");
            this.respond(request);
            return false;
        }
    }

    private void updateWorkQueueMetrics() {
        int queued = this.executorService.getQueue().size();
        this.metrics.setRpcServerQueueSize(queued);
    }

    public GetConfigContext createGetConfigContext(Optional<TenantName> optionalTenant, JRTServerConfigRequest request, Trace trace) {
        if ("*".equals(request.getConfigKey().getConfigId())) {
            return GetConfigContext.create(ApplicationId.global(), this.superModelRequestHandler, trace);
        }
        TenantName tenant = optionalTenant.orElse(TenantName.defaultName());
        if (!this.hasRequestHandler(tenant)) {
            String msg = Tenants.logPre(tenant) + "Unable to find request handler for tenant. Requested from host '" + request.getClientHostName() + "'";
            this.metrics.incUnknownHostRequests();
            trace.trace(6, msg);
            log.log(LogLevel.WARNING, msg);
            return null;
        }
        RequestHandler handler = this.getRequestHandler(tenant);
        ApplicationId applicationId = handler.resolveApplicationId(request.getClientHostName());
        if (trace.shouldTrace(9)) {
            trace.trace(9, "Host '" + request.getClientHostName() + "' should have config from application '" + applicationId + "'");
        }
        return GetConfigContext.create(applicationId, handler, trace);
    }

    private boolean hasRequestHandler(TenantName tenant) {
        return this.tenantProviders.containsKey(tenant);
    }

    private RequestHandler getRequestHandler(TenantName tenant) {
        if (!this.tenantProviders.containsKey(tenant)) {
            throw new IllegalStateException("No request handler for " + tenant);
        }
        return this.tenantProviders.get(tenant).getRequestHandler();
    }

    public void delayResponse(JRTServerConfigRequest request, GetConfigContext context) {
        this.delayedConfigResponses.delayResponse(request, context);
    }

    @Override
    public void onTenantDelete(TenantName tenant) {
        log.log((Level)LogLevel.DEBUG, Tenants.logPre(tenant) + "Tenant deleted, removing request handler and cleaning host registry");
        if (this.tenantProviders.containsKey(tenant)) {
            this.tenantProviders.remove(tenant);
        }
        this.hostRegistry.removeHostsForKey(tenant);
    }

    @Override
    public void onTenantsLoaded() {
        this.allTenantsLoaded = true;
        this.superModelRequestHandler.enable();
    }

    @Override
    public void onTenantCreate(TenantName tenant, TenantHandlerProvider tenantHandlerProvider) {
        log.log((Level)LogLevel.DEBUG, Tenants.logPre(tenant) + "Tenant created, adding request handler");
        this.tenantProviders.put(tenant, tenantHandlerProvider);
    }

    public boolean allTenantsLoaded() {
        return this.allTenantsLoaded;
    }

    public boolean isHostedVespa() {
        return this.hostedVespa;
    }

    MetricUpdaterFactory metricUpdaterFactory() {
        return this.metricUpdaterFactory;
    }

    boolean useRequestVersion() {
        return this.useRequestVersion;
    }
}

