/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.yolean.Exceptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class HttpHandler
extends LoggingRequestHandler {
    public HttpHandler(Executor executor, AccessLog accessLog) {
        super(executor, accessLog);
    }

    public HttpResponse handle(HttpRequest request) {
        this.log.log((Level)LogLevel.DEBUG, request.getMethod() + " " + request.getUri().toString());
        try {
            switch (request.getMethod()) {
                case POST: {
                    return this.handlePOST(request);
                }
                case GET: {
                    return this.handleGET(request);
                }
                case PUT: {
                    return this.handlePUT(request);
                }
                case DELETE: {
                    return this.handleDELETE(request);
                }
            }
            return this.createErrorResponse(request.getMethod());
        }
        catch (NotFoundException | com.yahoo.vespa.config.server.http.NotFoundException e) {
            return HttpErrorResponse.notFoundError(this.getMessage(e, request));
        }
        catch (BadRequestException | IllegalArgumentException | IllegalStateException e) {
            return HttpErrorResponse.badRequest(this.getMessage(e, request));
        }
        catch (OutOfCapacityException e) {
            return HttpErrorResponse.outOfCapacity(this.getMessage((Exception)((Object)e), request));
        }
        catch (InvalidApplicationException e) {
            return HttpErrorResponse.invalidApplicationPackage(this.getMessage(e, request));
        }
        catch (InternalServerException e) {
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
        catch (UnknownVespaVersionException e) {
            return HttpErrorResponse.unknownVespaVersion(this.getMessage(e, request));
        }
        catch (RequestTimeoutException e) {
            return HttpErrorResponse.requestTimeout(this.getMessage(e, request));
        }
        catch (ApplicationLockException e) {
            return HttpErrorResponse.applicationLockFailure(this.getMessage((Exception)((Object)e), request));
        }
        catch (Exception e) {
            this.log.log(LogLevel.WARNING, "Unexpected exception handling a config server request", e);
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
    }

    public Duration getTimeout() {
        return Duration.ofSeconds(910L);
    }

    private String getMessage(Exception e, HttpRequest request) {
        if (request.getBooleanProperty("debug")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        return Exceptions.toMessageString((Throwable)e);
    }

    protected HttpResponse handleGET(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePOST(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePUT(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handleDELETE(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    private HttpResponse createErrorResponse(HttpRequest.Method method) {
        return HttpErrorResponse.methodNotAllowed("Method '" + method + "' is not supported");
    }
}

