/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.http;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class V1Response
extends HttpResponse {
    private final Slime slime;

    public V1Response(String flagsV1Uri, String ... names) {
        super(200);
        this.slime = V1Response.generateBody(flagsV1Uri, List.of(names));
    }

    public void render(OutputStream stream) throws IOException {
        new JsonFormat(true).encode(stream, this.slime);
    }

    public String getContentType() {
        return "application/json";
    }

    private static Slime generateBody(String flagsV1Uri, List<String> names) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        names.forEach(name -> {
            Cursor data = root.setObject(name);
            data.setString("url", flagsV1Uri + "/" + name);
        });
        return slime;
    }
}

