/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NormalizedDefinition {
    private static final Pattern intPattern = Pattern.compile(".*int.*range.*");
    private static final Pattern doublePattern = Pattern.compile(".*double.*range.*");
    private final MessageDigest md5;
    String defMd5 = null;
    List<String> normalizedContent = null;

    public NormalizedDefinition() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create MD5 digest", e);
        }
        this.normalizedContent = new ArrayList<String>();
    }

    public NormalizedDefinition normalize(BufferedReader reader) throws IOException {
        String s;
        ArrayList<String> input = new ArrayList<String>();
        while ((s = reader.readLine()) != null) {
            String normalized = NormalizedDefinition.normalize(s);
            if (normalized.length() <= 0) continue;
            input.add(normalized);
        }
        this.normalizedContent = input;
        return this;
    }

    public static String normalize(String line) {
        String formattedMin;
        String formattedMax;
        Matcher m = intPattern.matcher((CharSequence)(line = ((String)line).trim()));
        if (m.matches()) {
            formattedMax = new DecimalFormat("#.#").format(Integer.MAX_VALUE);
            formattedMin = new DecimalFormat("#.#").format(Integer.MIN_VALUE);
            line = ((String)line).replaceFirst("\\[,", "[" + formattedMin + ",");
            line = ((String)line).replaceFirst(",\\]", "," + formattedMax + "]");
        }
        if ((m = doublePattern.matcher((CharSequence)line)).matches()) {
            formattedMax = new DecimalFormat("#.#").format(1.0E308);
            formattedMin = new DecimalFormat("#.#").format(-1.0E308);
            line = ((String)line).replaceFirst("\\[,", "[" + formattedMin + ",");
            line = ((String)line).replaceFirst(",\\]", "," + formattedMax + "]");
        }
        if (!((String)(line = NormalizedDefinition.removeComment((String)line))).isEmpty()) {
            line = NormalizedDefinition.stripSpaces((String)line);
            line = ((String)line).replaceAll("\\s,", ",");
            line = (String)line + "\n";
        }
        return line;
    }

    private static String removeComment(String line) {
        int index = line.indexOf("#");
        if (!line.contains("#") || index == 0) {
            return line;
        }
        int firstQuote = line.indexOf("\"");
        if (firstQuote > 0) {
            int secondQuote = line.indexOf("\"", firstQuote + 1);
            if (index > secondQuote) {
                line = line.substring(0, index);
                line = line.trim();
            }
        } else {
            line = line.substring(0, index);
            line = line.trim();
        }
        return line;
    }

    public void addNormalizedLine(String line) {
        this.normalizedContent.add(line);
    }

    public String generateMd5Sum() {
        for (String line : this.normalizedContent) {
            String s = NormalizedDefinition.normalize(line);
            if (s.isEmpty()) continue;
            this.md5.update(NormalizedDefinition.toBytes(s));
        }
        this.defMd5 = this.toHexString(this.md5.digest()).toLowerCase();
        return this.defMd5;
    }

    public static byte[] toBytes(String str) {
        Charset charset = Charset.forName("utf-8");
        ByteBuffer b = charset.encode(str);
        byte[] result = new byte[b.remaining()];
        b.get(result);
        return result;
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            sb.append(String.format("%02x", aByte));
        }
        return sb.toString();
    }

    public static String stripSpaces(String str) {
        StringBuilder ret = new StringBuilder("");
        boolean inQuotes = false;
        boolean inSpaceSequence = false;
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (inQuotes) {
                    ret.append(c);
                    continue;
                }
                if (inSpaceSequence) continue;
                inSpaceSequence = true;
                ret.append(" ");
                continue;
            }
            if (inSpaceSequence) {
                inSpaceSequence = false;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public List<String> getNormalizedContent() {
        return this.normalizedContent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.normalizedContent) {
            builder.append(line.replace("\"", "\\\""));
            builder.append("\\n\\\n");
        }
        return builder.toString();
    }

    public String getDefMd5() {
        return this.defMd5;
    }
}

