/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.DefaultValue;
import com.yahoo.config.codegen.ReservedWords;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefLine {
    private static final Pattern defaultPattern = Pattern.compile("^\\s*default\\s*=\\s*(\\S+)");
    private static final Pattern rangePattern = Pattern.compile("^\\s*range\\s*=\\s*([\\(\\[].*?[\\)\\]])");
    private static final Pattern restartPattern = Pattern.compile("^\\s*restart\\s*");
    private static final Pattern wordPattern = Pattern.compile("\\S+");
    private static final Pattern enumPattern = Pattern.compile("\\s*\\{(\\s*\\w+\\s*)+(\\s*,\\s*\\w+\\s*)*\\s*\\}");
    private static final Pattern enumPattern2 = Pattern.compile("\\s*,\\s*");
    private static final Pattern wordPattern2 = Pattern.compile("\\w+");
    private static final Pattern digitPattern = Pattern.compile("\\d");
    private static final Pattern namePattern = Pattern.compile("\\s*[a-zA-Z0-9_]+\\s*");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");
    private String name = null;
    private final Type type = new Type();
    private DefaultValue defaultValue = null;
    private String range = null;
    private boolean restart = false;
    String enumString = null;
    final String[] enumArray = null;
    private static final Pattern defaultNullPattern = Pattern.compile("^\\s*default\\s*=\\s*null");

    public DefLine(String line) {
        StringBuilder sb = new StringBuilder(line);
        int parsed = this.parseNameType(sb);
        sb.delete(0, parsed);
        if (this.type.name.equals("enum")) {
            parsed = this.parseEnum(sb);
            sb.delete(0, parsed);
        }
        while (sb.length() > 0) {
            parsed = this.parseOptions(sb);
            sb.delete(0, parsed);
        }
        this.validateName();
        this.validateReservedWords();
    }

    public String getRange() {
        return this.range;
    }

    public DefaultValue getDefault() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getRestart() {
        return this.restart;
    }

    public String getEnumString() {
        return this.enumString;
    }

    public String[] getEnumArray() {
        return this.enumArray;
    }

    private String findStringEnd(CharSequence s, int from) {
        boolean escaped = false;
        block4: for (int i = from; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\\': {
                    escaped = !escaped;
                    continue block4;
                }
                case '\"': {
                    if (escaped) continue block4;
                    return s.subSequence(from, i).toString();
                }
            }
        }
        return null;
    }

    private int parseOptions(CharSequence string) {
        Matcher defaultNullMatcher = defaultNullPattern.matcher(string);
        Matcher defaultMatcher = defaultPattern.matcher(string);
        Matcher rangeMatcher = rangePattern.matcher(string);
        Matcher restartMatcher = restartPattern.matcher(string);
        if (defaultNullMatcher.find()) {
            throw new IllegalArgumentException("Null default value is not allowed: " + string.toString());
        }
        if (defaultMatcher.find()) {
            String deflt = defaultMatcher.group(1);
            if (deflt.charAt(0) == '\"') {
                int begin = defaultMatcher.start(1) + 1;
                deflt = this.findStringEnd(string, begin);
                if (deflt == null) {
                    throw new IllegalArgumentException(string.toString());
                }
                this.defaultValue = new DefaultValue(deflt, this.type);
                return begin + deflt.length() + 1;
            }
            this.defaultValue = new DefaultValue(deflt, this.type);
            return defaultMatcher.end();
        }
        if (rangeMatcher.find()) {
            this.range = rangeMatcher.group(1);
            return rangeMatcher.end();
        }
        if (restartMatcher.find()) {
            this.restart = true;
            return restartMatcher.end();
        }
        throw new IllegalArgumentException(string.toString());
    }

    private int parseNameType(CharSequence string) {
        Matcher wordMatcher = wordPattern.matcher(string);
        if (wordMatcher.find()) {
            this.name = wordMatcher.group();
        }
        if (wordMatcher.find()) {
            this.type.name = wordMatcher.group();
        }
        if (this.type.name == null || this.name == null) {
            throw new IllegalArgumentException(string.toString());
        }
        return wordMatcher.end();
    }

    private int parseEnum(CharSequence string) {
        Matcher enumMatcher = enumPattern.matcher(string);
        if (enumMatcher.find()) {
            this.enumString = enumMatcher.group(0).trim();
        }
        if (this.enumString == null) {
            throw new IllegalArgumentException(string + " is not valid syntax");
        }
        this.enumString = this.enumString.replaceFirst("\\{\\s*", "");
        this.enumString = this.enumString.replaceFirst("\\s*\\}", "");
        String[] result = enumPattern2.split(this.enumString);
        this.type.enumArray = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            String s;
            this.type.enumArray[i] = s = result[i].trim();
            Matcher wordMatcher2 = wordPattern2.matcher(s);
            if (wordMatcher2.matches()) continue;
            throw new IllegalArgumentException(s + " is not valid syntax");
        }
        return enumMatcher.end();
    }

    void validateName() {
        boolean atStart = true;
        boolean arrayOk = true;
        boolean mapOk = true;
        for (int i = 0; i < this.name.length(); ++i) {
            String s = this.name.substring(i, i + 1);
            Matcher digitMatcher = digitPattern.matcher(s);
            Matcher nameMatcher = namePattern.matcher(s);
            Matcher whitespaceMatcher = whitespacePattern.matcher(s);
            if (atStart) {
                if (digitMatcher.matches()) {
                    throw new IllegalArgumentException(this.name + " must start with a non-digit character");
                }
                if (!nameMatcher.matches()) {
                    throw new IllegalArgumentException(this.name + " contains unexpected character");
                }
                atStart = false;
                continue;
            }
            if (nameMatcher.matches()) continue;
            if (s.equals(".")) {
                arrayOk = true;
                mapOk = true;
                atStart = true;
                continue;
            }
            if (s.equals("[")) {
                if (!arrayOk) {
                    throw new IllegalArgumentException(this.name + " Arrays cannot be multidimensional");
                }
                arrayOk = false;
                if (i > this.name.length() - 2 || !this.name.substring(i + 1, i + 2).equals("]")) {
                    throw new IllegalArgumentException(this.name + " Expected ] to terminate array definition");
                }
                ++i;
                continue;
            }
            if (s.equals("{")) {
                if (!mapOk) {
                    throw new IllegalArgumentException(this.name + " Maps cannot be multidimensional");
                }
                mapOk = false;
                if (i > this.name.length() - 2 || !this.name.substring(i + 1, i + 2).equals("}")) {
                    throw new IllegalArgumentException(this.name + " Expected } to terminate map definition");
                }
                ++i;
                continue;
            }
            if (whitespaceMatcher.matches()) break;
            throw new IllegalArgumentException("'" + this.name + "' contains an unexpected character");
        }
    }

    private void validateReservedWords() {
        String cleanName;
        String string = cleanName = this.name.endsWith("[]") || this.name.endsWith("{}") ? this.name.substring(0, this.name.length() - 2) : this.name;
        if (ReservedWords.isReservedWord(cleanName)) {
            throw new IllegalArgumentException(cleanName + " is a reserved word in " + ReservedWords.getLanguageForReservedWord(cleanName));
        }
        if (ReservedWords.capitalizedPattern.matcher(cleanName).matches()) {
            throw new IllegalArgumentException("'" + cleanName + "' cannot start with an uppercase letter");
        }
        if (ReservedWords.internalPrefixPattern.matcher(cleanName).matches()) {
            throw new IllegalArgumentException("'" + cleanName + "' cannot start with '__'");
        }
    }

    public static class Type {
        String name;
        String[] enumArray;

        public Type(String name) {
            this.name = name;
        }

        public Type() {
        }

        public String getName() {
            return this.name;
        }

        public String[] getEnumArray() {
            return this.enumArray;
        }

        public Type setEnumArray(String[] enumArray) {
            this.enumArray = enumArray;
            return this;
        }

        public String toString() {
            return "type " + this.name;
        }
    }
}

