/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.DefLine;
import com.yahoo.config.codegen.InnerCNode;
import java.util.StringTokenizer;

public abstract class CNode {
    public final boolean isArray;
    public final boolean isMap;
    final String name;
    final InnerCNode parent;
    String defName = null;
    String defVersion = "";
    String defNamespace = null;
    String defPackage = null;
    String defMd5 = "MISSING MD5";
    String comment = "";

    protected CNode(InnerCNode parent, String name) {
        this.parent = parent;
        int bracketIdx = name.indexOf(91);
        int curlyIdx = name.indexOf(123);
        if (bracketIdx != -1) {
            this.name = name.substring(0, bracketIdx);
            this.isArray = true;
            this.isMap = false;
        } else if (curlyIdx != -1) {
            this.name = name.substring(0, curlyIdx);
            this.isMap = true;
            this.isArray = false;
        } else {
            this.name = name;
            this.isMap = false;
            this.isArray = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public InnerCNode getParent() {
        return this.parent;
    }

    public abstract CNode[] getChildren();

    public abstract CNode getChild(String var1);

    public String getMd5() {
        return this.defMd5;
    }

    void setMd5(String md5) {
        this.defMd5 = md5;
    }

    public String getVersion() {
        return this.defVersion;
    }

    public String getNamespace() {
        if (this.defNamespace != null) {
            return this.defNamespace;
        }
        if (this.defPackage != null) {
            return this.defPackage;
        }
        return null;
    }

    void setNamespace(String namespace) {
        this.defNamespace = namespace;
    }

    public String getPackage() {
        return this.defPackage;
    }

    void setPackage(String defPackage) {
        this.defPackage = defPackage;
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    protected abstract void setLeaf(String var1, DefLine var2, String var3) throws IllegalArgumentException;

    public abstract boolean needRestart();

    protected void checkMyName(String myName) throws IllegalArgumentException {
        if (this.isArray) {
            int n1 = myName.indexOf(91);
            int n2 = myName.indexOf(93);
            if (n1 == -1 || n2 < n1) {
                throw new IllegalArgumentException("Invalid array syntax: " + myName);
            }
            myName = myName.substring(0, n1);
        } else if (this.isMap) {
            int n1 = myName.indexOf(123);
            int n2 = myName.indexOf(125);
            if (n1 == -1 || n2 < n1) {
                throw new IllegalArgumentException("Invalid map syntax: " + myName);
            }
            myName = myName.substring(0, n1);
        } else {
            if (myName.contains("[]")) {
                throw new IllegalArgumentException("Parameter with name '" + this.getName() + "' has already been declared as a non-array type.");
            }
            if (myName.contains("{}")) {
                throw new IllegalArgumentException("Parameter with name '" + this.getName() + "' has already been declared as a non-map type.");
            }
        }
        if (!myName.equals(this.getName())) {
            throw new IllegalArgumentException(myName + " does not match " + this.getName() + ".");
        }
    }

    public String getFullName() {
        StringBuilder buf = new StringBuilder();
        if (this.parent != null) {
            buf.append(this.parent.getFullName());
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        StringBuilder theName = new StringBuilder(this.getName());
        if (this.isArray) {
            theName.append("[]");
        } else if (this.isMap) {
            theName.append("{}");
        }
        return buf.append((CharSequence)theName).toString();
    }

    public String getCommentBlock(String prefix) {
        prefix = (String)prefix + " ";
        StringBuilder ret = new StringBuilder();
        if (this.getComment().length() > 0) {
            StringTokenizer st = new StringTokenizer(this.getComment(), "\n");
            while (st.hasMoreTokens()) {
                ret.append((String)prefix).append(st.nextToken()).append("\n");
            }
        }
        return ret.toString();
    }

    public String toString() {
        return "CNode{namespace='" + this.defNamespace + "', package='" + this.defPackage + "', name='" + this.name + "', version='" + this.defVersion + "'}";
    }
}

