/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import java.util.HashMap;
import java.util.regex.Pattern;

public class ReservedWords {
    public static final String INTERNAL_PREFIX = "__";
    static final Pattern internalPrefixPattern = Pattern.compile("^__.*");
    static final Pattern capitalizedPattern = Pattern.compile("^[A-Z].*");
    private static final String[] cKeywords = new String[]{"asm", "auto", "bool", "break", "case", "catch", "char", "class", "const", "const_cast", "continue", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "item", "long", "mutable", "namespace", "new", "operator", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_cast", "struct", "switch", "template", "this", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "and", "bitor", "not", "or", "xor", "and_eq", "compl", "not_eq", "or_eq", "xor_eq", "bitand"};
    private static final String[] javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "item", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "byvalue", "cast", "const", "future", "generic", "goto", "inner", "operator", "outer", "rest", "var"};
    private static final HashMap<String, String> allKeyWords = new HashMap();

    public static boolean isReservedWord(String word) {
        return allKeyWords.containsKey(word);
    }

    public static String getLanguageForReservedWord(String word) {
        return allKeyWords.get(word);
    }

    static {
        for (String s : cKeywords) {
            allKeyWords.put(s, "C");
        }
        for (String s : javaKeywords) {
            if (allKeyWords.containsKey(s)) {
                allKeyWords.put(s, "C and Java");
                continue;
            }
            allKeyWords.put(s, "Java");
        }
    }
}

