/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.DefLine;

public class DefaultValue {
    private String value = null;
    private DefLine.Type type = null;

    public DefaultValue() {
    }

    public DefaultValue(String value, DefLine.Type type) {
        this.value = value;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public String getStringRepresentation() {
        if (this.value == null) {
            return "null";
        }
        if ("bool".equals(this.type.getName())) {
            return this.value;
        }
        if ("int".equals(this.type.getName())) {
            return this.value;
        }
        if ("long".equals(this.type.getName())) {
            return this.value;
        }
        if ("double".equals(this.type.getName())) {
            return this.value;
        }
        if ("enum".equals(this.type.getName())) {
            return this.value;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : this.value.toCharArray()) {
            if (c > '\u007f') {
                sb.append(String.format("\\u%04X", c));
                continue;
            }
            sb.append(c);
        }
        return "\"" + sb.toString() + "\"";
    }
}

