/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.CodegenRuntimeException;
import com.yahoo.config.codegen.DefLine;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.config.codegen.NormalizedDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefParser {
    public static final String DEFAULT_PACKAGE_PREFIX = "com.yahoo.";
    static final Pattern commentPattern = Pattern.compile("^\\s*#+\\s*(.*?)\\s*$");
    public static final Pattern versionPattern = Pattern.compile("^(version\\s*=\\s*)([0-9][0-9-]*)$");
    public static final Pattern namespacePattern = DefParser.getNamespacePattern("namespace");
    public static final Pattern packagePattern = DefParser.getNamespacePattern("package");
    private final BufferedReader reader;
    private final String name;
    private InnerCNode root = null;
    private NormalizedDefinition normalizedDefinition = null;
    private String comment = "";

    private static Pattern getNamespacePattern(String directive) {
        return Pattern.compile("^(" + directive + "\\s*=\\s*)(([a-z][a-z0-9_]*)+([.][a-z][a-z0-9_]*)*)$");
    }

    public DefParser(String name, Reader defReader) {
        this.name = this.createName(name);
        if (defReader == null) {
            throw new CodegenRuntimeException("Must have a non-null reader for a .def file.");
        }
        this.reader = defReader instanceof BufferedReader ? (BufferedReader)defReader : new BufferedReader(defReader);
    }

    private String createName(String name) {
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public InnerCNode getTree() throws CodegenRuntimeException {
        try {
            if (this.root == null) {
                this.parse();
            }
        }
        catch (DefParserException | IOException e) {
            throw new CodegenRuntimeException("Error parsing or reading config definition." + e.getMessage(), e);
        }
        return this.root;
    }

    void parse() throws IOException, DefParserException {
        String s;
        this.root = new InnerCNode(this.name);
        this.normalizedDefinition = new NormalizedDefinition();
        ArrayList<String> originalInput = new ArrayList<String>();
        while ((s = this.reader.readLine()) != null) {
            originalInput.add(s);
        }
        this.reader.close();
        this.parseLines(this.root, originalInput, this.normalizedDefinition);
        this.root.setMd5(this.normalizedDefinition.generateMd5Sum());
    }

    private void parseLine(CNode root, String line, NormalizedDefinition nd) throws IllegalArgumentException {
        line = NormalizedDefinition.normalize(line);
        if ((line = line.trim()).length() == 0) {
            if (!this.comment.isEmpty()) {
                this.comment = this.comment + "\n";
            }
            return;
        }
        Matcher commentMatch = commentPattern.matcher(line);
        if (commentMatch.matches()) {
            this.parseCommentLine(commentMatch);
            return;
        }
        Matcher versionMatch = versionPattern.matcher(line);
        if (versionMatch.matches()) {
            this.parseVersionLine(versionMatch);
            return;
        }
        Matcher namespaceMatcher = namespacePattern.matcher(line);
        if (namespaceMatcher.matches()) {
            this.parseNamespaceLine(namespaceMatcher.group(2));
            nd.addNormalizedLine(line);
            return;
        }
        Matcher packageMatcher = packagePattern.matcher(line);
        if (packageMatcher.matches()) {
            this.parsePackageLine(packageMatcher.group(2));
            nd.addNormalizedLine(line);
            return;
        }
        nd.addNormalizedLine(line);
        DefLine defLine = new DefLine(line);
        root.setLeaf(root.getName() + "." + defLine.getName(), defLine, this.comment);
        this.comment = "";
    }

    private void parseCommentLine(Matcher commentMatch) {
        String addition;
        if (!this.comment.isEmpty()) {
            this.comment = this.comment + "\n";
        }
        if ((addition = commentMatch.group(1)).isEmpty()) {
            addition = " ";
        }
        this.comment = this.comment + addition;
    }

    private void parseVersionLine(Matcher matcher) {
        this.root.setVersion(matcher.group(2));
        this.root.setComment(this.comment);
        this.comment = "";
    }

    private void parseNamespaceLine(String namespace) {
        if (namespace.startsWith(DEFAULT_PACKAGE_PREFIX)) {
            throw new IllegalArgumentException("Please use 'package' instead of 'namespace'.");
        }
        this.root.setNamespace(namespace);
        this.root.setComment(this.comment);
        this.comment = "";
    }

    private void parsePackageLine(String defPackage) {
        this.root.setPackage(defPackage);
        this.root.setComment(this.comment);
        this.comment = "";
    }

    void parseLines(CNode root, List<String> defLines, NormalizedDefinition nd) throws DefParserException {
        DefParserException failure = null;
        int lineNumber = 1;
        for (String line : defLines) {
            try {
                this.parseLine(root, line, nd);
                ++lineNumber;
            }
            catch (IllegalArgumentException e) {
                String msg = "Error when parsing line " + lineNumber + ": " + line + "\n" + e.getMessage();
                failure = new DefParserException(msg, e);
                break;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public NormalizedDefinition getNormalizedDefinition() {
        return this.normalizedDefinition;
    }

    public static void dumpTree(CNode root, String indent) {
        CNode[] children;
        LeafCNode leaf;
        StringBuilder sb = new StringBuilder(indent + root.getName());
        if (root instanceof LeafCNode && (leaf = (LeafCNode)root).getDefaultValue() != null) {
            sb.append(" = ").append(((LeafCNode)root).getDefaultValue().getValue());
        }
        System.out.println(sb.toString());
        if (!root.getComment().isEmpty()) {
            Object comment = root.getComment();
            if (((String)comment).contains("\n")) {
                comment = ((String)comment).substring(0, ((String)comment).indexOf("\n")) + "...";
            }
            if (((String)comment).length() > 60) {
                comment = ((String)comment).substring(0, 57) + "...";
            }
            System.out.println(indent + "    comment: " + (String)comment);
        }
        for (CNode c : children = root.getChildren()) {
            DefParser.dumpTree(c, indent + "  ");
        }
    }

    class DefParserException
    extends Exception {
        DefParserException(String s, Throwable cause) {
            super(s, cause);
        }
    }
}

