/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.ClassBuilder;
import com.yahoo.config.codegen.CodegenRuntimeException;
import com.yahoo.config.codegen.DefaultValue;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.config.codegen.NormalizedDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class CppClassBuilder
implements ClassBuilder {
    private final CNode root;
    private final NormalizedDefinition nd;
    private final File rootDir;
    private final String relativePathUnderRoot;
    private static final Map<String, String> vectorTypeDefs;
    private static final Map<String, String> mapTypeDefs;
    private static final Map<String, String> slimeTypeMap;

    public CppClassBuilder(CNode root, NormalizedDefinition nd, File rootDir, String relativePathUnderRoot) {
        this.root = root;
        this.nd = nd;
        this.rootDir = rootDir;
        this.relativePathUnderRoot = relativePathUnderRoot;
    }

    @Override
    public void createConfigClasses() {
        this.generateConfig(this.root, this.nd);
    }

    String readFile(File f) throws IOException {
        if (!f.isFile()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader sr = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = sr.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    void writeFile(File f, String content) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write(content);
        fw.close();
    }

    void generateConfig(CNode root, NormalizedDefinition nd) {
        try {
            StringWriter headerWriter = new StringWriter();
            StringWriter bodyWriter = new StringWriter();
            this.writeHeaderFile(headerWriter, root);
            this.writeBodyFile(bodyWriter, root, this.relativePathUnderRoot, nd);
            String newHeader = headerWriter.toString();
            String newBody = bodyWriter.toString();
            File headerFile = new File(this.rootDir, this.relativePathUnderRoot + "/" + this.getFileName(root, "h"));
            File bodyFile = new File(this.rootDir, this.relativePathUnderRoot + "/" + this.getFileName(root, "cpp"));
            String oldHeader = this.readFile(headerFile);
            String oldBody = this.readFile(bodyFile);
            if (oldHeader == null || !oldHeader.equals(newHeader)) {
                this.writeFile(headerFile, newHeader);
            }
            if (oldBody == null || !oldBody.equals(newBody)) {
                this.writeFile(bodyFile, newBody);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String getFileName(CNode node, String extension) {
        return "config-" + node.getName() + "." + extension;
    }

    static String removeDashesAndUpperCaseAllFirstChars(String source, boolean capitalizeFirst) {
        String[] parts = source.split("[-_]");
        StringBuilder sb = new StringBuilder();
        for (String s : parts) {
            sb.append(s.substring(0, 1).toUpperCase()).append(s.substring(1));
        }
        Object result = sb.toString();
        if (!capitalizeFirst) {
            result = ((String)result).substring(0, 1).toLowerCase() + ((String)result).substring(1);
        }
        return result;
    }

    String getDefineName(String name) {
        return name.toUpperCase().replace("-", "");
    }

    static String getTypeName(String name) {
        return CppClassBuilder.removeDashesAndUpperCaseAllFirstChars(name, true);
    }

    String getIdentifier(String name) {
        return CppClassBuilder.removeDashesAndUpperCaseAllFirstChars(name, false);
    }

    void writeHeaderFile(Writer w, CNode root) throws IOException {
        this.writeHeaderHeader(w, root);
        this.writeHeaderPublic(w, root);
        this.writeHeaderFooter(w, root);
    }

    void writeHeaderPublic(Writer w, CNode root) throws IOException {
        w.write("public:\n");
        this.writeHeaderTypeDefs(w, root, "    ");
        this.writeTypeDeclarations(w, root, "    ");
        this.writeHeaderFunctionDeclarations(w, CppClassBuilder.getTypeName(root, false), root, "    ");
        this.writeStaticMemberDeclarations(w, "    ");
        this.writeMembers(w, root, "    ");
    }

    String[] generateCppNameSpace(CNode root) {
        String namespace = root.getNamespace();
        if (namespace.contains(".")) {
            return namespace.split("\\.");
        }
        return new String[]{namespace};
    }

    String generateCppNameSpaceString(String[] namespaceList) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < namespaceList.length - 1; ++i) {
            str.append(namespaceList[i]);
            str.append("::");
        }
        str.append(namespaceList[namespaceList.length - 1]);
        return str.toString();
    }

    String generateCppNameSpaceDefine(String[] namespaceList) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < namespaceList.length - 1; ++i) {
            str.append(namespaceList[i].toUpperCase());
            str.append("_");
        }
        str.append(namespaceList[namespaceList.length - 1].toUpperCase());
        return str.toString();
    }

    void writeNameSpaceBegin(Writer w, String[] namespaceList) throws IOException {
        w.write("namespace ");
        w.write(this.getNestedNameSpace(namespaceList));
        w.write(" {\n");
    }

    String getNestedNameSpace(String[] namespaceList) {
        return Arrays.stream(namespaceList).map(String::toString).collect(Collectors.joining("::"));
    }

    void writeNameSpaceEnd(Writer w, String[] namespaceList) throws IOException {
        w.write("} // namespace ");
        w.write(this.getNestedNameSpace(namespaceList));
        w.write("\n");
    }

    void writeHeaderHeader(Writer w, CNode root) throws IOException {
        String[] namespaceList = this.generateCppNameSpace(root);
        String namespacePrint = this.generateCppNameSpaceString(namespaceList);
        String namespaceDefine = this.generateCppNameSpaceDefine(namespaceList);
        String className = CppClassBuilder.getTypeName(root, false);
        String defineName = namespaceDefine + "_" + this.getDefineName(className);
        w.write("/**\n * @class " + namespacePrint + "::" + className + "\n * @ingroup config\n *\n * @brief This is an autogenerated class for handling VESPA config.\n *\n * This class is autogenerated by vespa from a config definition file.\n * To subscribe to config, you need to include the config/config.h header, \n * and create a ConfigSubscriber in order to subscribe for config.\n");
        if (root.getComment().length() > 0) {
            w.write(" *\n");
            StringTokenizer st = new StringTokenizer(root.getComment(), "\n");
            while (st.hasMoreTokens()) {
                w.write(" * " + st.nextToken() + "\n");
            }
        }
        w.write(" */\n#ifndef CLOUD_CONFIG_" + defineName + "_H\n#define CLOUD_CONFIG_" + defineName + "_H\n\n#include <vespa/config/configgen/configinstance.h>\n#include <vespa/vespalib/stllike/string.h>\n#include <vector>\n#include <map>\n\n");
        w.write("namespace config {\n");
        w.write("    class ConfigValue;\n");
        w.write("    class ConfigPayload;\n");
        w.write("}\n\n");
        w.write("namespace vespalib::slime {\n");
        w.write("    struct Inspector;\n");
        w.write("    struct Cursor;\n");
        w.write("}\n\n");
        this.writeNameSpaceBegin(w, namespaceList);
        w.write("\nnamespace internal {\n\n");
        w.write("/**\n * This class contains the config. DO NOT USE THIS CLASS DIRECTLY. Use the typedeffed\n * versions after this class declaration.\n */\nclass Internal" + className + "Type : public ::config::ConfigInstance\n{\n");
    }

    void writeTypeDeclarations(Writer w, CNode node, String indent) throws IOException {
        HashSet<String> declaredTypes = new HashSet<String>();
        for (CNode child : node.getChildren()) {
            boolean complexType;
            boolean bl = complexType = child instanceof InnerCNode || child instanceof LeafCNode.EnumLeaf;
            if (!complexType || declaredTypes.contains(child.getName())) continue;
            String typeName = CppClassBuilder.getTypeName(child, false);
            declaredTypes.add(child.getName());
            if (child instanceof LeafCNode.EnumLeaf) {
                w.write(indent + "enum class " + typeName + " { ");
                LeafCNode.EnumLeaf leaf = (LeafCNode.EnumLeaf)child;
                for (int i = 0; i < leaf.getLegalValues().length; ++i) {
                    if (i != 0) {
                        w.write(", ");
                    }
                    w.write(leaf.getLegalValues()[i]);
                }
                w.write(" };\n" + indent + "typedef std::vector<" + typeName + "> " + typeName + "Vector;\n" + indent + "typedef std::map<vespalib::string, " + typeName + "> " + typeName + "Map;\n" + indent + "static " + typeName + " get" + typeName + "(const vespalib::string&);\n" + indent + "static vespalib::string get" + typeName + "Name(" + typeName + " e);\n\n");
                w.write(indent + "struct Internal" + typeName + "Converter {\n");
                w.write(indent + "    " + typeName + " operator()(const ::vespalib::string & __fieldName, const ::vespalib::slime::Inspector & __inspector);\n");
                w.write(indent + "    " + typeName + " operator()(const ::vespalib::slime::Inspector & __inspector);\n");
                w.write(indent + "    " + typeName + " operator()(const ::vespalib::slime::Inspector & __inspector, " + typeName + " __eDefault);\n");
                w.write(indent + "};\n");
                continue;
            }
            w.write(indent + "class " + typeName + " {\n");
            w.write(indent + "public:\n");
            this.writeTypeDeclarations(w, child, indent + "    ");
            this.writeStructFunctionDeclarations(w, CppClassBuilder.getTypeName(child, false), child, indent + "    ");
            this.writeMembers(w, child, indent + "    ");
            w.write(indent + "};\n");
            w.write(indent + "typedef std::vector<" + typeName + "> " + typeName + "Vector;\n\n");
            w.write(indent + "typedef std::map<vespalib::string, " + typeName + "> " + typeName + "Map;\n\n");
        }
    }

    void writeHeaderFunctionDeclarations(Writer w, String className, CNode node, String indent) throws IOException {
        w.write(indent + "const vespalib::string & defName() const override { return CONFIG_DEF_NAME; }\n" + indent + "const vespalib::string & defMd5() const override { return CONFIG_DEF_MD5; }\n" + indent + "const vespalib::string & defNamespace() const override { return CONFIG_DEF_NAMESPACE; }\n" + indent + "void serialize(::config::ConfigDataBuffer & __buffer) const override;\n");
        this.writeConfigClassFunctionDeclarations(w, "Internal" + className + "Type", node, indent);
    }

    void writeConfigClassFunctionDeclarations(Writer w, String className, CNode node, String indent) throws IOException {
        w.write(indent + className + "(const ::config::ConfigValue & __value);\n");
        w.write(indent + className + "(const ::config::ConfigDataBuffer & __value);\n");
        w.write(indent + className + "(const ::config::ConfigPayload & __payload);\n");
        this.writeCommonFunctionDeclarations(w, className, node, indent);
    }

    void writeStructFunctionDeclarations(Writer w, String className, CNode node, String indent) throws IOException {
        w.write(indent + className + "(const std::vector<vespalib::string> & __lines);\n");
        w.write(indent + className + "(const vespalib::slime::Inspector & __inspector);\n");
        w.write(indent + className + "(const ::config::ConfigPayload & __payload);\n");
        this.writeCommonFunctionDeclarations(w, className, node, indent);
        w.write(indent + "void serialize(vespalib::slime::Cursor & __cursor) const;\n");
    }

    void writeClassCopyConstructorDeclaration(Writer w, String className, String indent) throws IOException {
        w.write(indent + className + "(const " + className + " & __rhs);\n");
    }

    void writeClassAssignmentOperatorDeclaration(Writer w, String className, String indent) throws IOException {
        w.write(indent + className + " & operator = (const " + className + " & __rhs);\n");
    }

    void writeConfigClassCopyConstructorDefinition(Writer w, String parent, String className) throws IOException {
        w.write(parent + "::" + className + "(const " + className + " & __rhs) = default;\n");
    }

    void writeConfigClassAssignmentOperatorDefinition(Writer w, String parent, String className) throws IOException {
        w.write(parent + " & " + parent + "::operator =(const " + className + " & __rhs) = default;\n");
    }

    void writeClassCopyConstructorDefinition(Writer w, String parent, CNode node) throws IOException {
        String typeName = CppClassBuilder.getTypeName(node, false);
        w.write(parent + "::" + typeName + "(const " + typeName + " & __rhs) = default;\n");
    }

    void writeClassAssignmentOperatorDefinition(Writer w, String parent, CNode node) throws IOException {
        String typeName = CppClassBuilder.getTypeName(node, false);
        w.write(parent + " & " + parent + "::operator = (const " + typeName + " & __rhs) = default;\n");
    }

    void writeDestructor(Writer w, String parent, String className) throws IOException {
        w.write(parent + "~" + className + "() { } \n");
    }

    void writeCommonFunctionDeclarations(Writer w, String className, CNode node, String indent) throws IOException {
        w.write(indent + className + "();\n");
        this.writeClassCopyConstructorDeclaration(w, className, indent);
        this.writeClassAssignmentOperatorDeclaration(w, className, indent);
        w.write(indent + "~" + className + "();\n");
        w.write("\n" + indent + "bool operator==(const " + className + "& __rhs) const;\n" + indent + "bool operator!=(const " + className + "& __rhs) const;\n\n");
    }

    static String getTypeName(CNode node, boolean includeArray) {
        Object type = null;
        if (node instanceof InnerCNode) {
            InnerCNode innerNode = (InnerCNode)node;
            type = CppClassBuilder.getTypeName(innerNode.getName());
        } else if (node instanceof LeafCNode) {
            LeafCNode leaf = (LeafCNode)node;
            if (leaf.getType().equals("bool")) {
                type = "bool";
            } else if (leaf.getType().equals("int")) {
                type = "int32_t";
            } else if (leaf.getType().equals("long")) {
                type = "int64_t";
            } else if (leaf.getType().equals("double")) {
                type = "double";
            } else if (leaf.getType().equals("enum")) {
                type = CppClassBuilder.getTypeName(node.getName());
            } else if (leaf.getType().equals("string")) {
                type = "vespalib::string";
            } else if (leaf.getType().equals("reference")) {
                type = "vespalib::string";
            } else if (leaf.getType().equals("file")) {
                type = "vespalib::string";
            } else {
                throw new IllegalArgumentException("Unknown leaf datatype " + leaf.getType());
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown node " + node);
        }
        if (node.isArray && includeArray) {
            type = vectorTypeDefs.containsKey(type) ? vectorTypeDefs.get(type) : (String)type + "Vector";
        } else if (node.isMap && includeArray) {
            type = mapTypeDefs.containsKey(type) ? mapTypeDefs.get(type) : (String)type + "Map";
        }
        return type;
    }

    void writeStaticMemberDeclarations(Writer w, String indent) throws IOException {
        w.write(indent + "static const vespalib::string CONFIG_DEF_MD5;\n" + indent + "static const vespalib::string CONFIG_DEF_VERSION;\n" + indent + "static const vespalib::string CONFIG_DEF_NAME;\n" + indent + "static const vespalib::string CONFIG_DEF_NAMESPACE;\n" + indent + "static const std::vector<vespalib::string> CONFIG_DEF_SCHEMA;\n" + indent + "static const int64_t CONFIG_DEF_SERIALIZE_VERSION;\n\n");
    }

    void writeComment(Writer w, String indent, String comment, boolean javadoc) throws IOException {
        if (javadoc && ((String)comment).indexOf(10) == -1 && ((String)comment).length() <= 80 - (indent.length() + 7)) {
            w.write(indent + "/** " + (String)comment + " */\n");
            return;
        }
        if (!javadoc && ((String)comment).indexOf(10) == -1 && ((String)comment).length() <= 80 - (indent.length() + 3)) {
            w.write(indent + "// " + (String)comment + "\n");
            return;
        }
        int maxLineLen = 80 - (indent.length() + 3);
        if (javadoc) {
            w.write(indent + "/**\n");
        }
        do {
            Object current;
            int newLine;
            if ((newLine = ((String)comment).indexOf(10)) == -1) {
                current = comment;
                comment = "";
            } else {
                current = ((String)comment).substring(0, newLine);
                comment = ((String)comment).substring(newLine + 1);
            }
            if (((String)current).length() > maxLineLen) {
                int spaceIndex = ((String)current).lastIndexOf(32, maxLineLen);
                if (spaceIndex >= maxLineLen - 15) {
                    comment = ((String)current).substring(spaceIndex + 1) + "\n" + (String)comment;
                    current = ((String)current).substring(0, spaceIndex);
                } else {
                    comment = ((String)current).substring(maxLineLen) + "\n" + (String)comment;
                    current = ((String)current).substring(0, maxLineLen) + "-";
                }
            }
            w.write(indent + (javadoc ? " * " : "// ") + (String)current + "\n");
        } while (((String)comment).length() > 0);
        if (javadoc) {
            w.write(indent + " */\n");
        }
    }

    void writeMembers(Writer w, CNode node, String indent) throws IOException {
        for (CNode child : node.getChildren()) {
            LeafCNode leaf;
            DefaultValue value;
            String typeName = CppClassBuilder.getTypeName(child, true);
            if (child.getComment().length() > 0) {
                int index;
                String comment = child.getComment();
                while ((index = comment.indexOf("\n\n")) != -1) {
                    String next = comment.substring(0, index);
                    comment = comment.substring(index + 2);
                    w.write("\n");
                    this.writeComment(w, indent, next, false);
                }
                w.write("\n");
                this.writeComment(w, indent, comment, true);
            }
            w.write(indent + typeName + " " + this.getIdentifier(child.getName()) + ";");
            if (child instanceof LeafCNode && (value = (leaf = (LeafCNode)child).getDefaultValue()) != null) {
                w.write(" // Default: " + value.getStringRepresentation());
            }
            w.write("\n");
        }
    }

    void writeHeaderTypeDefs(Writer w, CNode root, String indent) throws IOException {
        String typeDef;
        String typeName;
        w.write(indent + "typedef std::unique_ptr<const " + CppClassBuilder.getInternalClassName(root) + "> UP;\n");
        for (Map.Entry<String, String> entry : vectorTypeDefs.entrySet()) {
            typeName = entry.getKey();
            String vectorName = entry.getValue();
            typeDef = "typedef std::vector<" + typeName + "> " + vectorName;
            w.write(indent + typeDef + ";\n");
        }
        for (Map.Entry<String, String> entry : mapTypeDefs.entrySet()) {
            typeName = entry.getKey();
            String mapName = entry.getValue();
            typeDef = "typedef std::map<vespalib::string, " + typeName + "> " + mapName;
            w.write(indent + typeDef + ";\n");
        }
    }

    private static String getInternalClassName(CNode root) {
        return "Internal" + CppClassBuilder.getTypeName(root, false) + "Type";
    }

    void writeHeaderFooter(Writer w, CNode root) throws IOException {
        String[] namespaceList = this.generateCppNameSpace(root);
        String namespaceDefine = this.generateCppNameSpaceDefine(namespaceList);
        String className = CppClassBuilder.getTypeName(root, false);
        String defineName = namespaceDefine + "_" + this.getDefineName(className);
        w.write("};\n\n} // namespace internal\n\n");
        w.write("typedef internal::" + CppClassBuilder.getInternalClassName(root) + " " + className + "ConfigBuilder;\n");
        w.write("typedef const internal::" + CppClassBuilder.getInternalClassName(root) + " " + className + "Config;\n");
        w.write("\n");
        this.writeNameSpaceEnd(w, namespaceList);
        w.write("#endif // VESPA_config_" + defineName + "_H\n");
    }

    void writeBodyFile(Writer w, CNode root, String subdir, NormalizedDefinition nd) throws IOException {
        this.writeBodyHeader(w, root, subdir);
        this.writeStaticMemberDefinitions(w, root, nd);
        this.writeDefinition(w, root, null);
        this.writeBodyFooter(w, root);
    }

    void writeBodyHeader(Writer w, CNode root, String subdir) throws IOException {
        if (subdir == null) {
            w.write("#include \"" + this.getFileName(root, "h") + "\"");
        } else {
            w.write("#include <" + subdir + "/" + this.getFileName(root, "h") + ">");
        }
        w.write("\n");
        w.write("#include <vespa/config/common/configvalue.h>\n");
        w.write("#include <vespa/config/common/exceptions.h>\n");
        w.write("#include <vespa/config/configgen/configpayload.h>\n");
        w.write("#include <vespa/config/print/configdatabuffer.h>\n");
        w.write("#include <vespa/config/common/configparser.h>\n");
        w.write("#include <vespa/config/configgen/vector_inserter.h>\n");
        w.write("#include <vespa/config/configgen/map_inserter.h>\n");
        w.write("#include <vespa/vespalib/data/slime/convenience.h>\n");
        w.write("#include <vespa/vespalib/data/slime/slime.h>\n");
        w.write("#include <vespa/vespalib/stllike/asciistream.h>\n");
        w.write("\n");
        this.writeNameSpaceBegin(w, this.generateCppNameSpace(root));
        w.write("\nnamespace internal {\n\n");
        w.write("using ::config::ConfigParser;\n");
        w.write("using ::config::InvalidConfigException;\n");
        w.write("using ::config::ConfigInstance;\n");
        w.write("using ::config::ConfigValue;\n");
        w.write("using namespace vespalib::slime::convenience;\n");
        w.write("\n");
    }

    void writeStaticMemberDefinitions(Writer w, CNode root, NormalizedDefinition nd) throws IOException {
        String typeName = CppClassBuilder.getInternalClassName(root);
        w.write("const vespalib::string " + typeName + "::CONFIG_DEF_MD5(\"" + root.defMd5 + "\");\nconst vespalib::string " + typeName + "::CONFIG_DEF_VERSION(\"" + root.defVersion + "\");\nconst vespalib::string " + typeName + "::CONFIG_DEF_NAME(\"" + root.defName + "\");\nconst vespalib::string " + typeName + "::CONFIG_DEF_NAMESPACE(\"" + root.getNamespace() + "\");\nconst int64_t " + typeName + "::CONFIG_DEF_SERIALIZE_VERSION(1);\n");
        w.write("const static vespalib::string __internalDefSchema[] = {\n");
        for (String line : nd.getNormalizedContent()) {
            w.write("\"" + line.replace("\"", "\\\"") + "\",\n");
        }
        w.write("};\n");
        w.write("const std::vector<vespalib::string> " + typeName + "::CONFIG_DEF_SCHEMA(__internalDefSchema,\n");
        w.write("    __internalDefSchema + (sizeof(__internalDefSchema) / \n");
        w.write("                           sizeof(__internalDefSchema[0])));\n");
        w.write("\n");
    }

    void writeDefinition(Writer w, CNode node, String fullClassName) throws IOException {
        boolean root = false;
        if (fullClassName == null) {
            fullClassName = CppClassBuilder.getInternalClassName(node);
            root = true;
        }
        String parent = fullClassName + "::";
        HashSet<String> declaredTypes = new HashSet<String>();
        for (CNode cNode : node.getChildren()) {
            boolean complexType;
            boolean bl = complexType = cNode instanceof InnerCNode || cNode instanceof LeafCNode.EnumLeaf;
            if (!complexType || declaredTypes.contains(cNode.getName())) continue;
            String typeName = CppClassBuilder.getTypeName(cNode, false);
            declaredTypes.add(cNode.getName());
            if (cNode instanceof LeafCNode.EnumLeaf) {
                int i;
                LeafCNode.EnumLeaf leaf = (LeafCNode.EnumLeaf)cNode;
                w.write(parent + typeName + "\n" + parent + "get" + typeName + "(const vespalib::string& name)\n{\n");
                for (i = 0; i < leaf.getLegalValues().length; ++i) {
                    w.write("    " + (i != 0 ? "} else " : ""));
                    w.write("if (name == \"" + leaf.getLegalValues()[i] + "\") {\n        return " + typeName + "::" + leaf.getLegalValues()[i] + ";\n");
                }
                w.write("    } else {\n        throw InvalidConfigException(\"Illegal enum value '\" + name + \"'\");\n    }\n}\n\n");
                w.write("vespalib::string\n" + parent + "get" + typeName + "Name(" + typeName + " t)\n{\n    switch (t) {\n");
                for (i = 0; i < leaf.getLegalValues().length; ++i) {
                    w.write("        case " + typeName + "::" + leaf.getLegalValues()[i] + ": return \"" + leaf.getLegalValues()[i] + "\";\n");
                }
                w.write("        default:\n        {\n            vespalib::asciistream ost;\n            ost << \"UNKNOWN(\" << static_cast<int>(t) << \")\";\n            return ost.str();\n        }\n    }\n}\n\n");
                w.write(parent + typeName + " " + parent + "Internal" + typeName + "Converter::operator()(const ::vespalib::string & __fieldName, const ::vespalib::slime::Inspector & __inspector) {\n");
                w.write("    if (__inspector.valid()) {\n");
                w.write("        return " + parent + "get" + typeName + "(__inspector.asString().make_string());\n");
                w.write("    }\n");
                w.write("    throw InvalidConfigException(\"Value for '\" + __fieldName + \"' required but not found\");\n");
                w.write("}\n");
                w.write(parent + typeName + " " + parent + "Internal" + typeName + "Converter::operator()(const ::vespalib::slime::Inspector & __inspector) {\n");
                w.write("    return " + parent + "get" + typeName + "(__inspector.asString().make_string());\n");
                w.write("}\n");
                w.write(parent + typeName + " " + parent + "Internal" + typeName + "Converter::operator()(const ::vespalib::slime::Inspector & __inspector, " + typeName + " __eDefault) {\n");
                w.write("    if (__inspector.valid()) {\n");
                w.write("        return " + parent + "get" + typeName + "(__inspector.asString().make_string());\n");
                w.write("    }\n");
                w.write("    return __eDefault;\n");
                w.write("}\n\n");
                continue;
            }
            this.writeDefinition(w, cNode, parent + typeName);
        }
        String tmpName = CppClassBuilder.getTypeName(node, false);
        String typeName = root ? CppClassBuilder.getInternalClassName(node) : tmpName;
        w.write(parent + typeName + "()\n");
        for (int i = 0; i < node.getChildren().length; ++i) {
            CNode cNode = node.getChildren()[i];
            String childName = this.getIdentifier(cNode.getName());
            if (i == 0) {
                w.write("    : " + childName + "(");
            } else {
                w.write("),\n      " + childName + "(");
            }
            if (cNode.isArray || cNode.isMap || !(cNode instanceof LeafCNode)) continue;
            LeafCNode leaf = (LeafCNode)cNode;
            if (leaf.getDefaultValue() != null) {
                if (leaf.getType().equals("enum")) {
                    w.write(CppClassBuilder.getTypeName(leaf, false) + "::");
                }
                w.write(this.getDefaultValue(leaf));
                continue;
            }
            if (leaf.getType().equals("bool")) {
                w.write("false");
                continue;
            }
            if (leaf.getType().equals("int")) {
                w.write("0");
                continue;
            }
            if (leaf.getType().equals("double")) {
                w.write("0");
                continue;
            }
            if (leaf.getType().equals("string")) continue;
            if (leaf.getType().equals("enum")) {
                LeafCNode.EnumLeaf enumNode = (LeafCNode.EnumLeaf)leaf;
                w.write(CppClassBuilder.getTypeName(leaf, false) + "::" + enumNode.getLegalValues()[0]);
                continue;
            }
            if (!leaf.getType().equals("reference") && !leaf.getType().equals("file")) continue;
        }
        if (node.getChildren().length > 0) {
            w.write(")\n");
        }
        w.write("{\n}\n\n");
        if (root) {
            this.writeConfigClassCopyConstructorDefinition(w, fullClassName, typeName);
            this.writeConfigClassAssignmentOperatorDefinition(w, fullClassName, typeName);
        } else {
            this.writeClassCopyConstructorDefinition(w, fullClassName, node);
            this.writeClassAssignmentOperatorDefinition(w, fullClassName, node);
        }
        this.writeDestructor(w, parent, typeName);
        String indent = "    ";
        if (root) {
            w.write(typeName + "::" + typeName + "(const ConfigValue & __value)\n{\n" + indent + "try {\n");
            indent = "        ";
            w.write(indent + "const std::vector<vespalib::string> & __lines(__value.getLines());\n");
        } else {
            w.write(parent + typeName + "(const std::vector<vespalib::string> & __lines)\n{\n");
        }
        w.write(indent + "std::set<vespalib::string> __remainingValuesToParse(__lines.begin(), __lines.end());\n");
        w.write(indent + "for(std::set<vespalib::string>::iterator __rVTPiter = __remainingValuesToParse.begin();\n" + indent + "    __rVTPiter != __remainingValuesToParse.end();)\n" + indent + "{\n" + indent + "    if (ConfigParser::stripWhitespace(*__rVTPiter).empty()) {\n" + indent + "        std::set<vespalib::string>::iterator __rVTPiter2 = __rVTPiter++;\n" + indent + "        __remainingValuesToParse.erase(__rVTPiter2);\n" + indent + "    } else {\n" + indent + "        ++__rVTPiter;\n" + indent + "    }\n" + indent + "}\n");
        for (CNode child : node.getChildren()) {
            String childType = CppClassBuilder.getTypeName(child, false);
            String childName = this.getIdentifier(child.getName());
            if (child instanceof LeafCNode.EnumLeaf) {
                if (child.isArray) {
                    w.write(indent + "std::vector<vespalib::string> " + childName + "__ValueList(\n            ");
                } else if (child.isMap) {
                    w.write(indent + "std::map<vespalib::string, vespalib::string> " + childName + "__ValueMap(\n            ");
                } else {
                    w.write(indent + childName + " = get" + childType + "(");
                }
                childType = "vespalib::string";
            } else {
                w.write(indent + childName + " = ");
            }
            if (child.isArray) {
                w.write("ConfigParser::parseArray<" + childType + ">(\"" + child.getName() + "\", __lines)");
            } else if (child.isMap) {
                w.write("ConfigParser::parseMap<" + childType + ">(\"" + child.getName() + "\", __lines)");
            } else {
                LeafCNode leaf;
                if (child instanceof LeafCNode) {
                    w.write("ConfigParser::parse<" + childType + ">(\"" + child.getName() + "\", __lines");
                } else {
                    w.write("ConfigParser::parseStruct<" + childType + ">(\"" + child.getName() + "\", __lines");
                }
                if (child instanceof LeafCNode && ((LeafCNode)child).getDefaultValue() != null && (leaf = (LeafCNode)child).getDefaultValue().getValue() != null) {
                    Object defaultVal = this.getDefaultValue(leaf);
                    if (leaf instanceof LeafCNode.EnumLeaf) {
                        defaultVal = "\"" + (String)defaultVal + "\"";
                    }
                    w.write(", " + (String)defaultVal);
                }
                w.write(")");
            }
            if (child instanceof LeafCNode.EnumLeaf) {
                childType = CppClassBuilder.getTypeName(child, false);
                w.write(");\n");
                if (child.isArray) {
                    w.write(indent + childName + ".reserve(" + childName + "__ValueList.size());\n" + indent + "for (std::vector<vespalib::string>::const_iterator __it\n" + indent + "        = " + childName + "__ValueList.begin();\n" + indent + "     __it != " + childName + "__ValueList.end(); ++__it)\n" + indent + "{\n" + indent + "    " + childName + ".push_back(get" + childType + "(*__it));\n" + indent + "}\n");
                } else if (child.isMap) {
                    w.write(indent + "typedef std::map<vespalib::string, vespalib::string> __ValueMap;\n");
                    w.write(indent + "for (__ValueMap::iterator __it(" + childName + "__ValueMap.begin()), __mt(" + childName + "__ValueMap.end()); __it != __mt; __it++) {\n    " + childName + "[__it->first] = get" + childType + "(__it->second);\n}\n");
                }
            } else {
                w.write(";\n");
            }
            w.write(indent + "ConfigParser::stripLinesForKey(\"" + child.getName() + "\", __remainingValuesToParse);\n");
        }
        if (root) {
            indent = "    ";
            w.write(indent + "} catch (InvalidConfigException & __ice) {\n");
            w.write(indent + "    throw InvalidConfigException(\"Error parsing config '\" + CONFIG_DEF_NAME + \"' in namespace '\" + CONFIG_DEF_NAMESPACE + \"': \" + __ice.getMessage());\n" + indent + "}\n");
        }
        w.write("}\n\n");
        String string = parent.length() + typeName.length() < 50 ? "" : "\n";
        w.write("bool\n" + parent + string + "operator==(const " + typeName + "& __rhs) const\n{\n    return (");
        for (int i = 0; i < node.getChildren().length; ++i) {
            CNode child = node.getChildren()[i];
            String childName = this.getIdentifier(child.getName());
            if (i != 0) {
                w.write(" &&\n            ");
            }
            w.write(childName + " == __rhs." + childName);
        }
        w.write(");\n}\n\n");
        String string2 = parent.length() + typeName.length() < 50 ? "" : "\n";
        w.write("bool\n" + parent + string2 + "operator!=(const " + typeName + "& __rhs) const\n{\n    return !(operator==(__rhs));\n}\n\n");
        this.writeSlimeEncoder(w, node, parent, root);
        this.writeSlimeDecoder(w, node, parent, root);
        this.writeSlimeConstructor(w, node, parent, root);
    }

    public void writeSlimeEncoder(Writer w, CNode node, String parent, boolean root) throws IOException {
        String indent = "    ";
        if (root) {
            w.write("void\n" + parent + "serialize(::config::ConfigDataBuffer & __buffer) const\n{\n");
            w.write(indent + "vespalib::Slime & __slime(__buffer.slimeObject());\n");
            w.write(indent + "vespalib::slime::Cursor & __croot = __slime.setObject();\n");
            w.write(indent + "__croot.setDouble(\"version\", CONFIG_DEF_SERIALIZE_VERSION);\n");
            w.write(indent + "vespalib::slime::Cursor & __key = __croot.setObject(\"configKey\");\n");
            w.write(indent + "__key.setString(\"defName\", vespalib::Memory(CONFIG_DEF_NAME));\n");
            w.write(indent + "__key.setString(\"defNamespace\", vespalib::Memory(CONFIG_DEF_NAMESPACE));\n");
            w.write(indent + "__key.setString(\"defMd5\", vespalib::Memory(CONFIG_DEF_MD5));\n");
            w.write(indent + "vespalib::slime::Cursor & __keySchema =__key.setArray(\"defSchema\");\n");
            w.write(indent + "for (size_t i = 0; i < CONFIG_DEF_SCHEMA.size(); i++) {\n");
            w.write(indent + "    __keySchema.addString(vespalib::Memory(CONFIG_DEF_SCHEMA[i]));\n");
            w.write(indent + "}\n");
            w.write(indent + "vespalib::slime::Cursor & __cursor = __croot.setObject(\"configPayload\");\n");
        } else {
            w.write("void\n" + parent + "serialize(vespalib::slime::Cursor & __cursor) const\n{\n");
        }
        for (CNode child : node.getChildren()) {
            String repType;
            String type;
            String repType2;
            String childName = this.getIdentifier(child.getName());
            String childType = CppClassBuilder.getTypeName(child, false);
            w.write(indent + "{\n");
            indent = "        ";
            w.write(indent + "vespalib::slime::Cursor & __c = __cursor.setObject(\"" + child.getName() + "\");\n");
            if (child.isArray) {
                w.write(indent + "__c.setString(\"type\", \"array\");\n");
                w.write(indent + "vespalib::slime::Cursor & __c2 = __c.setArray(\"value\");\n");
                w.write(indent + "for (size_t __i = 0; __i < " + childName + ".size(); __i++) {\n");
                w.write(indent + "    vespalib::slime::Cursor & __c3 = __c2.addObject();\n");
                if (child instanceof LeafCNode.EnumLeaf) {
                    repType2 = slimeTypeMap.get("enum");
                    w.write(indent + "    __c3.setString(\"type\", \"enum\");\n");
                    w.write(indent + "    __c3.set" + repType2);
                    w.write("(\"value\", vespalib::Memory(get" + childType + "Name(" + childName + "[__i])));\n");
                } else if (child instanceof LeafCNode) {
                    type = ((LeafCNode)child).getType();
                    repType = slimeTypeMap.get(type);
                    w.write(indent + "    __c3.setString(\"type\", \"" + type + "\");\n");
                    w.write(indent + "    __c3.set" + repType);
                    if ("String".equals(repType)) {
                        w.write("(\"value\", vespalib::Memory(" + childName + "[__i]));\n");
                    } else {
                        w.write("(\"value\", " + childName + "[__i]);\n");
                    }
                } else {
                    w.write(indent + "    __c3.setString(\"type\", \"struct\");\n");
                    w.write(indent + "    Cursor & __c4 = __c3.setObject(\"value\");\n");
                    w.write(indent + "    " + childName + "[__i].serialize(__c4);\n");
                }
                w.write(indent + "}\n");
            } else if (child.isMap) {
                w.write(indent + "__c.setString(\"type\", \"map\");\n");
                w.write(indent + "vespalib::slime::Cursor & __c2 = __c.setArray(\"value\");\n");
                String childMapType = CppClassBuilder.getTypeName(child, true);
                w.write(indent + "for (" + childMapType + "::const_iterator it(" + childName + ".begin()), mt(" + childName + ".end()); it != mt; it++) {\n");
                w.write(indent + "    vespalib::slime::Cursor & __c3 = __c2.addObject();\n");
                w.write(indent + "    __c3.setString(\"key\", vespalib::Memory(it->first));\n");
                if (child instanceof LeafCNode.EnumLeaf) {
                    repType = slimeTypeMap.get("enum");
                    w.write(indent + "    __c3.setString(\"type\", \"enum\");\n");
                    w.write(indent + "    __c3.set" + repType);
                    w.write("(\"value\", vespalib::Memory(get" + childType + "Name(it->second)));\n");
                } else if (child instanceof LeafCNode) {
                    String type2 = ((LeafCNode)child).getType();
                    String repType3 = slimeTypeMap.get(type2);
                    w.write(indent + "    __c3.setString(\"type\", \"" + type2 + "\");\n");
                    w.write(indent + "    __c3.set" + repType3);
                    if ("String".equals(repType3)) {
                        w.write("(\"value\", vespalib::Memory(it->second));\n");
                    } else {
                        w.write("(\"value\", it->second);\n");
                    }
                } else {
                    w.write(indent + "    __c3.setString(\"type\", \"struct\");\n");
                    w.write(indent + "    Cursor & __c4 = __c3.setObject(\"value\");\n");
                    w.write(indent + "    it->second.serialize(__c4);\n");
                }
                w.write(indent + "}\n");
            } else if (child instanceof LeafCNode.EnumLeaf) {
                repType2 = slimeTypeMap.get("enum");
                w.write(indent + "__c.setString(\"type\", \"enum\");\n");
                w.write(indent + "__c.set" + repType2);
                w.write("(\"value\", vespalib::Memory(get" + childType + "Name(" + childName + ")));\n");
            } else if (child instanceof LeafCNode) {
                type = ((LeafCNode)child).getType();
                repType = slimeTypeMap.get(type);
                w.write(indent + "__c.setString(\"type\", \"" + type + "\");\n");
                w.write(indent + "__c.set" + repType);
                if ("String".equals(repType)) {
                    w.write("(\"value\", vespalib::Memory(" + childName + "));\n");
                } else {
                    w.write("(\"value\", " + childName + ");\n");
                }
            } else {
                w.write(indent + "__c.setString(\"type\", \"struct\");\n");
                w.write(indent + "Cursor & __c2 = __c.setObject(\"value\");\n");
                w.write(indent + childName + ".serialize(__c2);\n");
            }
            indent = "    ";
            w.write(indent + "}\n");
        }
        w.write("}\n\n");
    }

    public void writeSlimeDecoder(Writer w, CNode node, String parent, boolean root) throws IOException {
        String tmpName = CppClassBuilder.getTypeName(node, false);
        String typeName = root ? CppClassBuilder.getInternalClassName(node) : tmpName;
        String indent = "    ";
        if (root) {
            w.write(typeName + "::" + typeName + "(const ::config::ConfigDataBuffer & __buffer)\n{\n");
            w.write(indent + "const vespalib::Slime & __slime(__buffer.slimeObject());\n");
            w.write(indent + "vespalib::slime::Inspector & __croot = __slime.get();\n");
            w.write(indent + "vespalib::slime::Inspector & __inspector = __croot[\"configPayload\"];\n");
        } else {
            w.write(parent + typeName + "(const vespalib::slime::Inspector & __inspector)\n{\n");
        }
        for (CNode child : node.getChildren()) {
            String repType;
            String type;
            String repType2;
            String childName = this.getIdentifier(child.getName());
            String childType = CppClassBuilder.getTypeName(child, false);
            String inspectorLine = "__inspector[\"" + child.getName() + "\"][\"value\"]";
            if (child.isArray) {
                w.write(indent + "for (size_t __i = 0; __i < " + inspectorLine + ".children(); __i++) {\n");
                w.write(indent + "    " + childName + ".push_back(");
                if (child instanceof LeafCNode.EnumLeaf) {
                    repType2 = slimeTypeMap.get("enum");
                    w.write("get" + childType + "(" + inspectorLine + "[__i][\"value\"].as" + repType2 + "().make_string())");
                } else if (child instanceof LeafCNode) {
                    type = ((LeafCNode)child).getType();
                    repType = slimeTypeMap.get(type);
                    if ("String".equals(repType)) {
                        w.write(inspectorLine + "[__i][\"value\"].as" + repType + "().make_string()");
                    } else {
                        w.write(inspectorLine + "[__i][\"value\"].as" + repType + "()");
                    }
                } else {
                    w.write(childType + "(" + inspectorLine + "[__i][\"value\"])");
                }
                w.write(");\n");
                w.write(indent + "}\n");
                continue;
            }
            if (child.isMap) {
                w.write(indent + "for (size_t __i = 0; __i < " + inspectorLine + ".children(); __i++) {\n");
                w.write(indent + "    " + childName + "[" + inspectorLine + "[__i][\"key\"].asString().make_string()] = ");
                if (child instanceof LeafCNode.EnumLeaf) {
                    repType2 = slimeTypeMap.get("enum");
                    w.write("get" + childType + "(" + inspectorLine + "[__i][\"value\"].as" + repType2 + "().make_string())");
                } else if (child instanceof LeafCNode) {
                    type = ((LeafCNode)child).getType();
                    repType = slimeTypeMap.get(type);
                    if ("String".equals(repType)) {
                        w.write(inspectorLine + "[__i][\"value\"].as" + repType + "().make_string()");
                    } else {
                        w.write(inspectorLine + "[__i][\"value\"].as" + repType + "()");
                    }
                } else {
                    w.write(childType + "(" + inspectorLine + "[__i][\"value\"])");
                }
                w.write(";\n");
                w.write(indent + "}\n");
                continue;
            }
            w.write(indent + childName + " = ");
            if (child instanceof LeafCNode.EnumLeaf) {
                repType2 = slimeTypeMap.get("enum");
                w.write("get" + childType + "(" + inspectorLine + ".as" + repType2 + "().make_string())");
            } else if (child instanceof LeafCNode) {
                type = ((LeafCNode)child).getType();
                repType = slimeTypeMap.get(type);
                if ("String".equals(repType)) {
                    w.write(inspectorLine + ".as" + repType + "().make_string()");
                } else {
                    w.write(inspectorLine + ".as" + repType + "()");
                }
            } else {
                w.write(childType + "(" + inspectorLine + ")");
            }
            w.write(";\n");
        }
        w.write("}\n\n");
    }

    public void writeSlimeConstructor(Writer w, CNode node, String parent, boolean root) throws IOException {
        String tmpName = CppClassBuilder.getTypeName(node, false);
        String typeName = root ? CppClassBuilder.getInternalClassName(node) : tmpName;
        String indent = "    ";
        if (root) {
            w.write(typeName + "::" + typeName + "(const ::config::ConfigPayload & __payload)\n{\n");
        } else {
            w.write(parent + typeName + "(const ::config::ConfigPayload & __payload)\n{\n");
        }
        w.write(indent + "const vespalib::slime::Inspector & __inspector(__payload.get());\n");
        for (CNode child : node.getChildren()) {
            String inserterName;
            String childName = this.getIdentifier(child.getName());
            String childType = CppClassBuilder.getTypeName(child, false);
            String childInspector = "__inspector[\"" + child.getName() + "\"]";
            if (child.isArray) {
                inserterName = "__" + childName + "Inserter";
                w.write(indent + "::config::internal::VectorInserter<" + childType);
                if (child instanceof LeafCNode.EnumLeaf) {
                    w.write(", Internal" + childType + "Converter");
                }
                w.write("> " + inserterName + "(" + childName + ");\n");
                w.write(indent + childInspector + ".traverse(" + inserterName + ");\n");
                continue;
            }
            if (child.isMap) {
                inserterName = "__" + childName + "Inserter";
                w.write(indent + "::config::internal::MapInserter<" + childType);
                if (child instanceof LeafCNode.EnumLeaf) {
                    w.write(", Internal" + childType + "Converter");
                }
                w.write("> " + inserterName + "(" + childName + ");\n");
                w.write(indent + childInspector + ".traverse(" + inserterName + ");\n");
                continue;
            }
            w.write(indent + childName + " = ");
            if (child instanceof LeafCNode.EnumLeaf) {
                w.write("Internal" + childType + "Converter");
            } else {
                w.write("::config::internal::ValueConverter<" + childType + ">");
            }
            if (child instanceof LeafCNode && ((LeafCNode)child).getDefaultValue() != null) {
                LeafCNode leaf = (LeafCNode)child;
                Object defaultValue = this.getDefaultValue(leaf);
                if (leaf.getType().equals("enum")) {
                    defaultValue = CppClassBuilder.getTypeName(leaf, false) + "::" + (String)defaultValue;
                }
                w.write("()(" + childInspector + ", " + (String)defaultValue + ");\n");
                continue;
            }
            if (child instanceof InnerCNode) {
                w.write("()(" + childInspector + ");\n");
                continue;
            }
            w.write("()(\"" + child.getName() + "\", " + childInspector + ");\n");
        }
        w.write("}\n\n");
    }

    void writeBodyFooter(Writer w, CNode root) throws IOException {
        w.write("} // namespace internal\n\n");
        this.writeNameSpaceEnd(w, this.generateCppNameSpace(root));
    }

    String getDefaultValue(LeafCNode leaf) {
        String defaultVal = leaf.getDefaultValue().getStringRepresentation();
        if (leaf.getType().equals("string") && defaultVal.equals("null")) {
            throw new CodegenRuntimeException("Default value null not allowed for C++ config");
        }
        if (leaf.getType().equals("long") && "-9223372036854775808".equals(defaultVal)) {
            return "LONG_MIN";
        }
        if (leaf.getType().equals("int") && "-2147483648".equals(defaultVal)) {
            return "INT_MIN";
        }
        return defaultVal;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bool", "BoolVector");
        map.put("int32_t", "IntVector");
        map.put("int64_t", "LongVector");
        map.put("double", "DoubleVector");
        map.put("vespalib::string", "StringVector");
        vectorTypeDefs = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("bool", "BoolMap");
        map.put("int32_t", "IntMap");
        map.put("int64_t", "LongMap");
        map.put("double", "DoubleMap");
        map.put("vespalib::string", "StringMap");
        mapTypeDefs = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("bool", "Bool");
        map.put("int", "Long");
        map.put("long", "Long");
        map.put("double", "Double");
        map.put("string", "String");
        map.put("enum", "String");
        map.put("file", "String");
        map.put("reference", "String");
        slimeTypeMap = Collections.unmodifiableMap(map);
    }
}

