/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CodegenRuntimeException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ConfiggenUtil {
    public static String createClassName(String defName) {
        String className = Arrays.stream(defName.split("-")).map(ConfiggenUtil::capitalize).collect(Collectors.joining()) + "Config";
        if (!ConfiggenUtil.isLegalJavaIdentifier(className)) {
            throw new CodegenRuntimeException("Illegal config definition file name '" + defName + "'. Must be a legal Java identifier.");
        }
        return className;
    }

    static String capitalize(String in) {
        StringBuilder sb = new StringBuilder(in);
        sb.setCharAt(0, Character.toTitleCase(in.charAt(0)));
        return sb.toString();
    }

    private static boolean isLegalJavaIdentifier(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (char c : name.substring(1).toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

