/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.ClassBuilder;
import com.yahoo.config.codegen.CodegenRuntimeException;
import com.yahoo.config.codegen.CppClassBuilder;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.JavaClassBuilder;
import com.yahoo.config.codegen.MakeConfigProperties;
import com.yahoo.config.codegen.NormalizedDefinition;
import com.yahoo.config.codegen.PropertyException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class MakeConfig {
    private final ClassBuilder classBuilder;

    public MakeConfig(InnerCNode root, NormalizedDefinition nd, MakeConfigProperties properties) {
        this.classBuilder = MakeConfig.createClassBuilder(root, nd, properties);
    }

    public static ClassBuilder createClassBuilder(InnerCNode root, NormalizedDefinition nd, MakeConfigProperties properties) {
        if (MakeConfig.isCpp(properties)) {
            return new CppClassBuilder(root, nd, properties.destDir, properties.dirInRoot);
        }
        return new JavaClassBuilder(root, nd, properties.destDir, properties.javaPackagePrefix);
    }

    public static boolean makeConfig(MakeConfigProperties properties) throws FileNotFoundException {
        for (File specFile : properties.specFiles) {
            String name = specFile.getName();
            if (name.endsWith(".def")) {
                name = name.substring(0, name.length() - 4);
            }
            DefParser parser = new DefParser(name, new FileReader(specFile));
            InnerCNode configRoot = parser.getTree();
            MakeConfig.checkNamespaceAndPacakge(name, configRoot, MakeConfig.isCpp(properties));
            if (configRoot != null) {
                MakeConfig mc = new MakeConfig(configRoot, parser.getNormalizedDefinition(), properties);
                mc.buildClasses();
                if (!properties.dumpTree) continue;
                System.out.println("\nTree dump:");
                DefParser.dumpTree(configRoot, "");
                continue;
            }
            return false;
        }
        return true;
    }

    void buildClasses() {
        this.classBuilder.createConfigClasses();
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: java -Dconfig.dest=<dir> -Dconfig.spec=<path> [-Dconfig.lang=cpp -Dconfig.subdir=<dir>] [-Dconfig.dumpTree=true] MakeConfig");
        out.println("       (default language for generated code is Java)");
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        try {
            MakeConfigProperties props = new MakeConfigProperties();
            boolean success = MakeConfig.makeConfig(props);
            if (!success) {
                System.exit(1);
            }
        }
        catch (PropertyException e) {
            System.out.println(Exceptions.toMessageString(e));
            MakeConfig.printUsage(System.err);
            System.exit(1);
        }
        catch (CodegenRuntimeException e) {
            System.out.println(Exceptions.toMessageString(e));
            System.exit(1);
        }
    }

    private static void checkNamespaceAndPacakge(String name, InnerCNode configRoot, boolean isCpp) {
        if (isCpp && configRoot.defNamespace == null) {
            throw new IllegalArgumentException("In config definition '" + name + "': A namespace is required");
        }
        if (configRoot.defNamespace == null && configRoot.defPackage == null) {
            throw new IllegalArgumentException("In config definition '" + name + "': A package (or namespace) is required");
        }
    }

    private static boolean isCpp(MakeConfigProperties properties) {
        return properties.language.equals("cppng") || properties.language.equals("cpp");
    }

    static class Exceptions {
        Exceptions() {
        }

        public static String toMessageString(Throwable t) {
            StringBuilder b = new StringBuilder();
            String lastMessage = null;
            while (t != null) {
                String message = Exceptions.getMessage(t);
                if (!(message == null || lastMessage != null && lastMessage.equals(message))) {
                    if (b.length() > 0) {
                        b.append(": ");
                    }
                    b.append(message);
                }
                t = t.getCause();
                lastMessage = message;
            }
            return b.toString();
        }

        private static String getMessage(Throwable t) {
            String message = t.getMessage();
            if (t.getCause() == null) {
                if (message == null) {
                    return Exceptions.toShortClassName(t);
                }
                return message;
            }
            if (message == null) {
                return null;
            }
            if (message.equals(t.getCause().getClass().getName() + ": " + t.getCause().getMessage())) {
                return null;
            }
            return message;
        }

        private static String toShortClassName(Object o) {
            String longName = o.getClass().getName();
            int lastDot = longName.lastIndexOf(".");
            if (lastDot < 0) {
                return longName;
            }
            return longName.substring(lastDot + 1);
        }
    }
}

