/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefLine;
import com.yahoo.config.codegen.DefaultValue;
import com.yahoo.config.codegen.InnerCNode;

public abstract class LeafCNode
extends CNode {
    private boolean isInitialized = false;
    private DefaultValue defaultValue = null;
    private boolean restart = false;

    protected LeafCNode(InnerCNode parent, String name) {
        super(parent, name);
    }

    public static LeafCNode newInstance(DefLine.Type type, InnerCNode parent, String name) {
        try {
            switch (type.name) {
                case "int": {
                    return new IntegerLeaf(parent, name);
                }
                case "long": {
                    return new LongLeaf(parent, name);
                }
                case "double": {
                    return new DoubleLeaf(parent, name);
                }
                case "bool": {
                    return new BooleanLeaf(parent, name);
                }
                case "string": {
                    return new StringLeaf(parent, name);
                }
                case "reference": {
                    return new ReferenceLeaf(parent, name);
                }
                case "file": {
                    return new FileLeaf(parent, name);
                }
                case "path": {
                    return new PathLeaf(parent, name);
                }
                case "enum": {
                    return new EnumLeaf(parent, name, type.enumArray);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static LeafCNode newInstance(DefLine.Type type, InnerCNode parent, String name, String defVal) {
        LeafCNode ret = LeafCNode.newInstance(type, parent, name);
        if (defVal != null) {
            DefaultValue def = new DefaultValue(defVal, type);
            ret.setDefaultValue(def);
        }
        return ret;
    }

    public abstract String getType();

    @Override
    public CNode[] getChildren() {
        return new CNode[0];
    }

    @Override
    public CNode getChild(String name) {
        return null;
    }

    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    public LeafCNode setDefaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public void checkDefaultValue(DefaultValue defaultValue) throws IllegalArgumentException {
    }

    @Override
    protected void setLeaf(String name, DefLine defLine, String comment) throws IllegalArgumentException {
        DefLine.Type type = defLine.getType();
        if (!this.isMap && !this.isArray && this.isInitialized) {
            throw new IllegalArgumentException(name + " is already defined");
        }
        this.isInitialized = true;
        this.checkMyName(name);
        if (!type.name.equalsIgnoreCase(this.getType())) {
            throw new IllegalArgumentException("Type " + type.name + " does not match " + this.getType());
        }
        this.setValue(defLine.getDefault());
        this.setComment(comment);
        this.restart |= defLine.getRestart();
    }

    @Override
    public boolean needRestart() {
        return this.restart;
    }

    public final void setValue(DefaultValue defaultValue) throws IllegalArgumentException {
        try {
            this.checkDefaultValue(defaultValue);
            this.setDefaultValue(defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid default value", e);
        }
    }

    public static class EnumLeaf
    extends LeafCNode {
        private final String[] legalValues;

        protected EnumLeaf(InnerCNode parent, String name, String[] valArray) {
            super(parent, name);
            this.legalValues = valArray;
        }

        @Override
        public String getType() {
            return "enum";
        }

        public String[] getLegalValues() {
            return this.legalValues;
        }

        @Override
        public void checkDefaultValue(DefaultValue defaultValue) throws IllegalArgumentException {
            if (defaultValue != null && defaultValue.getValue() != null) {
                String defaultString = null;
                String value = defaultValue.getValue();
                for (String val : this.legalValues) {
                    if (!value.equals(val)) continue;
                    defaultString = val;
                }
                if (defaultString == null) {
                    throw new IllegalArgumentException("Could not initialize enum with: " + value);
                }
            }
        }
    }

    public static class PathLeaf
    extends NoClassNoDefaultLeafCNode {
        PathLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "path";
        }
    }

    public static class FileLeaf
    extends NoClassNoDefaultLeafCNode {
        FileLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "file";
        }
    }

    public static class ReferenceLeaf
    extends StringLeaf {
        ReferenceLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "reference";
        }
    }

    public static class StringLeaf
    extends NoClassLeafCNode {
        protected StringLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "string";
        }
    }

    public static class BooleanLeaf
    extends NoClassLeafCNode {
        protected BooleanLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "bool";
        }
    }

    public static class DoubleLeaf
    extends NoClassLeafCNode {
        protected DoubleLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "double";
        }
    }

    public static class LongLeaf
    extends NoClassLeafCNode {
        protected LongLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "long";
        }
    }

    public static class IntegerLeaf
    extends NoClassLeafCNode {
        protected IntegerLeaf(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public String getType() {
            return "int";
        }
    }

    public static abstract class NoClassNoDefaultLeafCNode
    extends LeafCNode {
        protected NoClassNoDefaultLeafCNode(InnerCNode parent, String name) {
            super(parent, name);
        }

        @Override
        public LeafCNode setDefaultValue(DefaultValue defaultValue) {
            if (defaultValue != null) {
                throw new IllegalArgumentException("Parameters of type '" + this.getType() + "' cannot have a default value.");
            }
            return this;
        }
    }

    public static abstract class NoClassLeafCNode
    extends LeafCNode {
        protected NoClassLeafCNode(InnerCNode parent, String name) {
            super(parent, name);
        }
    }
}

