/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefLine;
import com.yahoo.config.codegen.LeafCNode;
import java.util.LinkedHashMap;
import java.util.Map;

public class InnerCNode
extends CNode {
    private final Map<String, CNode> children = new LinkedHashMap<String, CNode>();
    private boolean restart = false;

    public InnerCNode(String name) {
        super(null, name.split("\\.def")[0]);
        this.defName = this.name;
    }

    private InnerCNode(InnerCNode parent, String name) {
        super(parent, name);
    }

    @Override
    public CNode[] getChildren() {
        CNode[] ret = new CNode[this.children.size()];
        this.children.values().toArray(ret);
        return ret;
    }

    public Map<String, CNode> children() {
        return this.children;
    }

    @Override
    public CNode getChild(String name) {
        return this.children.get(name);
    }

    private CNode createOrGetChild(DefLine.Type type, String name) throws IllegalArgumentException {
        CNode newChild;
        String key = name;
        int split = name.indexOf(46);
        if (split != -1) {
            key = name.substring(0, split).trim();
            newChild = new InnerCNode(this, key);
        } else {
            newChild = LeafCNode.newInstance(type, this, key);
            if (newChild == null) {
                throw new IllegalArgumentException("Could not create " + type.name + " " + name);
            }
        }
        return this.children.containsKey(newChild.getName()) ? this.children.get(newChild.getName()) : newChild;
    }

    @Override
    protected void setLeaf(String name, DefLine defLine, String comment) throws IllegalArgumentException {
        if (name.indexOf(46) < 0) {
            throw new IllegalArgumentException("Parameter with name '" + name + "' cannot be a leaf node as it has already been declared as an inner node.");
        }
        this.checkMyName(name.substring(0, name.indexOf(46)));
        String childName = name.substring(name.indexOf(46) + 1);
        CNode child = this.createOrGetChild(defLine.getType(), childName);
        this.restart |= defLine.getRestart();
        child.setLeaf(childName, defLine, comment);
        this.children.put(child.getName(), child);
    }

    @Override
    public boolean needRestart() {
        return this.restart;
    }
}

