/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class DispatchConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "666e6f3e893ff1bbd24c07cdd6a9f601";
    public static final String CONFIG_DEF_NAME = "dispatch";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "minActivedocsPercentage double default=97.0", "distributionPolicy enum { ROUNDROBIN, BEST_OF_RANDOM_2, LATENCY_AMORTIZED_OVER_REQUESTS, LATENCY_AMORTIZED_OVER_TIME, ADAPTIVE } default=ADAPTIVE", "maxHitsPerNode int default=2147483647", "topKProbability double default=0.9999", "useMultilevelDispatch bool default=false", "useLocalNode bool default=false", "searchableCopies long default=1", "redundancy long default=1", "minSearchCoverage double default=100", "minWaitAfterCoverageFactor double default=0", "maxWaitAfterCoverageFactor double default=1", "numJrtTransportThreads int default=8", "numJrtConnectionsPerNode int default=8", "warmuptime double default=0.1", "node[].key int", "node[].group int default=0", "node[].host string", "node[].port int", "mergeGroupingResultInSearchInvokerEnabled bool default=false"};
    private final DoubleNode minActivedocsPercentage;
    private final DistributionPolicy distributionPolicy;
    private final IntegerNode maxHitsPerNode;
    private final DoubleNode topKProbability;
    private final BooleanNode useMultilevelDispatch;
    private final BooleanNode useLocalNode;
    private final LongNode searchableCopies;
    private final LongNode redundancy;
    private final DoubleNode minSearchCoverage;
    private final DoubleNode minWaitAfterCoverageFactor;
    private final DoubleNode maxWaitAfterCoverageFactor;
    private final IntegerNode numJrtTransportThreads;
    private final IntegerNode numJrtConnectionsPerNode;
    private final DoubleNode warmuptime;
    private final InnerNodeVector<Node> node;
    private final BooleanNode mergeGroupingResultInSearchInvokerEnabled;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DispatchConfig(Builder builder) {
        this(builder, true);
    }

    private DispatchConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for dispatch must be initialized: " + builder.__uninitialized);
        }
        this.minActivedocsPercentage = builder.minActivedocsPercentage == null ? new DoubleNode(97.0) : new DoubleNode(builder.minActivedocsPercentage.doubleValue());
        this.distributionPolicy = builder.distributionPolicy == null ? new DistributionPolicy(DistributionPolicy.ADAPTIVE) : new DistributionPolicy(builder.distributionPolicy);
        this.maxHitsPerNode = builder.maxHitsPerNode == null ? new IntegerNode(Integer.MAX_VALUE) : new IntegerNode(builder.maxHitsPerNode.intValue());
        this.topKProbability = builder.topKProbability == null ? new DoubleNode(0.9999) : new DoubleNode(builder.topKProbability.doubleValue());
        this.useMultilevelDispatch = builder.useMultilevelDispatch == null ? new BooleanNode(false) : new BooleanNode(builder.useMultilevelDispatch.booleanValue());
        this.useLocalNode = builder.useLocalNode == null ? new BooleanNode(false) : new BooleanNode(builder.useLocalNode.booleanValue());
        this.searchableCopies = builder.searchableCopies == null ? new LongNode(1L) : new LongNode(builder.searchableCopies.longValue());
        this.redundancy = builder.redundancy == null ? new LongNode(1L) : new LongNode(builder.redundancy.longValue());
        this.minSearchCoverage = builder.minSearchCoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minSearchCoverage.doubleValue());
        this.minWaitAfterCoverageFactor = builder.minWaitAfterCoverageFactor == null ? new DoubleNode(0.0) : new DoubleNode(builder.minWaitAfterCoverageFactor.doubleValue());
        this.maxWaitAfterCoverageFactor = builder.maxWaitAfterCoverageFactor == null ? new DoubleNode(1.0) : new DoubleNode(builder.maxWaitAfterCoverageFactor.doubleValue());
        this.numJrtTransportThreads = builder.numJrtTransportThreads == null ? new IntegerNode(8) : new IntegerNode(builder.numJrtTransportThreads.intValue());
        this.numJrtConnectionsPerNode = builder.numJrtConnectionsPerNode == null ? new IntegerNode(8) : new IntegerNode(builder.numJrtConnectionsPerNode.intValue());
        this.warmuptime = builder.warmuptime == null ? new DoubleNode(0.1) : new DoubleNode(builder.warmuptime.doubleValue());
        this.node = Node.createVector(builder.node);
        this.mergeGroupingResultInSearchInvokerEnabled = builder.mergeGroupingResultInSearchInvokerEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.mergeGroupingResultInSearchInvokerEnabled.booleanValue());
    }

    public double minActivedocsPercentage() {
        return this.minActivedocsPercentage.value();
    }

    public DistributionPolicy.Enum distributionPolicy() {
        return (DistributionPolicy.Enum)((Object)this.distributionPolicy.value());
    }

    public int maxHitsPerNode() {
        return this.maxHitsPerNode.value();
    }

    public double topKProbability() {
        return this.topKProbability.value();
    }

    public boolean useMultilevelDispatch() {
        return this.useMultilevelDispatch.value();
    }

    public boolean useLocalNode() {
        return this.useLocalNode.value();
    }

    public long searchableCopies() {
        return this.searchableCopies.value();
    }

    public long redundancy() {
        return this.redundancy.value();
    }

    public double minSearchCoverage() {
        return this.minSearchCoverage.value();
    }

    public double minWaitAfterCoverageFactor() {
        return this.minWaitAfterCoverageFactor.value();
    }

    public double maxWaitAfterCoverageFactor() {
        return this.maxWaitAfterCoverageFactor.value();
    }

    public int numJrtTransportThreads() {
        return this.numJrtTransportThreads.value();
    }

    public int numJrtConnectionsPerNode() {
        return this.numJrtConnectionsPerNode.value();
    }

    public double warmuptime() {
        return this.warmuptime.value();
    }

    public List<Node> node() {
        return this.node;
    }

    public Node node(int i) {
        return (Node)((Object)this.node.get(i));
    }

    public boolean mergeGroupingResultInSearchInvokerEnabled() {
        return this.mergeGroupingResultInSearchInvokerEnabled.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DispatchConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Double minActivedocsPercentage = null;
        private DistributionPolicy.Enum distributionPolicy = null;
        private Integer maxHitsPerNode = null;
        private Double topKProbability = null;
        private Boolean useMultilevelDispatch = null;
        private Boolean useLocalNode = null;
        private Long searchableCopies = null;
        private Long redundancy = null;
        private Double minSearchCoverage = null;
        private Double minWaitAfterCoverageFactor = null;
        private Double maxWaitAfterCoverageFactor = null;
        private Integer numJrtTransportThreads = null;
        private Integer numJrtConnectionsPerNode = null;
        private Double warmuptime = null;
        public List<Node.Builder> node = new ArrayList<Node.Builder>();
        private Boolean mergeGroupingResultInSearchInvokerEnabled = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DispatchConfig config) {
            this.minActivedocsPercentage(config.minActivedocsPercentage());
            this.distributionPolicy(config.distributionPolicy());
            this.maxHitsPerNode(config.maxHitsPerNode());
            this.topKProbability(config.topKProbability());
            this.useMultilevelDispatch(config.useMultilevelDispatch());
            this.useLocalNode(config.useLocalNode());
            this.searchableCopies(config.searchableCopies());
            this.redundancy(config.redundancy());
            this.minSearchCoverage(config.minSearchCoverage());
            this.minWaitAfterCoverageFactor(config.minWaitAfterCoverageFactor());
            this.maxWaitAfterCoverageFactor(config.maxWaitAfterCoverageFactor());
            this.numJrtTransportThreads(config.numJrtTransportThreads());
            this.numJrtConnectionsPerNode(config.numJrtConnectionsPerNode());
            this.warmuptime(config.warmuptime());
            for (Node n : config.node()) {
                this.node(new Node.Builder(n));
            }
            this.mergeGroupingResultInSearchInvokerEnabled(config.mergeGroupingResultInSearchInvokerEnabled());
        }

        private Builder override(Builder __superior) {
            if (__superior.minActivedocsPercentage != null) {
                this.minActivedocsPercentage(__superior.minActivedocsPercentage);
            }
            if (__superior.distributionPolicy != null) {
                this.distributionPolicy(__superior.distributionPolicy);
            }
            if (__superior.maxHitsPerNode != null) {
                this.maxHitsPerNode(__superior.maxHitsPerNode);
            }
            if (__superior.topKProbability != null) {
                this.topKProbability(__superior.topKProbability);
            }
            if (__superior.useMultilevelDispatch != null) {
                this.useMultilevelDispatch(__superior.useMultilevelDispatch);
            }
            if (__superior.useLocalNode != null) {
                this.useLocalNode(__superior.useLocalNode);
            }
            if (__superior.searchableCopies != null) {
                this.searchableCopies(__superior.searchableCopies);
            }
            if (__superior.redundancy != null) {
                this.redundancy(__superior.redundancy);
            }
            if (__superior.minSearchCoverage != null) {
                this.minSearchCoverage(__superior.minSearchCoverage);
            }
            if (__superior.minWaitAfterCoverageFactor != null) {
                this.minWaitAfterCoverageFactor(__superior.minWaitAfterCoverageFactor);
            }
            if (__superior.maxWaitAfterCoverageFactor != null) {
                this.maxWaitAfterCoverageFactor(__superior.maxWaitAfterCoverageFactor);
            }
            if (__superior.numJrtTransportThreads != null) {
                this.numJrtTransportThreads(__superior.numJrtTransportThreads);
            }
            if (__superior.numJrtConnectionsPerNode != null) {
                this.numJrtConnectionsPerNode(__superior.numJrtConnectionsPerNode);
            }
            if (__superior.warmuptime != null) {
                this.warmuptime(__superior.warmuptime);
            }
            if (!__superior.node.isEmpty()) {
                this.node.addAll(__superior.node);
            }
            if (__superior.mergeGroupingResultInSearchInvokerEnabled != null) {
                this.mergeGroupingResultInSearchInvokerEnabled(__superior.mergeGroupingResultInSearchInvokerEnabled);
            }
            return this;
        }

        public Builder minActivedocsPercentage(double __value) {
            this.minActivedocsPercentage = __value;
            return this;
        }

        private Builder minActivedocsPercentage(String __value) {
            return this.minActivedocsPercentage(Double.valueOf(__value));
        }

        public Builder distributionPolicy(DistributionPolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.distributionPolicy = __value;
            return this;
        }

        private Builder distributionPolicy(String __value) {
            return this.distributionPolicy(DistributionPolicy.Enum.valueOf(__value));
        }

        public Builder maxHitsPerNode(int __value) {
            this.maxHitsPerNode = __value;
            return this;
        }

        private Builder maxHitsPerNode(String __value) {
            return this.maxHitsPerNode(Integer.valueOf(__value));
        }

        public Builder topKProbability(double __value) {
            this.topKProbability = __value;
            return this;
        }

        private Builder topKProbability(String __value) {
            return this.topKProbability(Double.valueOf(__value));
        }

        public Builder useMultilevelDispatch(boolean __value) {
            this.useMultilevelDispatch = __value;
            return this;
        }

        private Builder useMultilevelDispatch(String __value) {
            return this.useMultilevelDispatch(Boolean.valueOf(__value));
        }

        public Builder useLocalNode(boolean __value) {
            this.useLocalNode = __value;
            return this;
        }

        private Builder useLocalNode(String __value) {
            return this.useLocalNode(Boolean.valueOf(__value));
        }

        public Builder searchableCopies(long __value) {
            this.searchableCopies = __value;
            return this;
        }

        private Builder searchableCopies(String __value) {
            return this.searchableCopies(Long.valueOf(__value));
        }

        public Builder redundancy(long __value) {
            this.redundancy = __value;
            return this;
        }

        private Builder redundancy(String __value) {
            return this.redundancy(Long.valueOf(__value));
        }

        public Builder minSearchCoverage(double __value) {
            this.minSearchCoverage = __value;
            return this;
        }

        private Builder minSearchCoverage(String __value) {
            return this.minSearchCoverage(Double.valueOf(__value));
        }

        public Builder minWaitAfterCoverageFactor(double __value) {
            this.minWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder minWaitAfterCoverageFactor(String __value) {
            return this.minWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder maxWaitAfterCoverageFactor(double __value) {
            this.maxWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder maxWaitAfterCoverageFactor(String __value) {
            return this.maxWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder numJrtTransportThreads(int __value) {
            this.numJrtTransportThreads = __value;
            return this;
        }

        private Builder numJrtTransportThreads(String __value) {
            return this.numJrtTransportThreads(Integer.valueOf(__value));
        }

        public Builder numJrtConnectionsPerNode(int __value) {
            this.numJrtConnectionsPerNode = __value;
            return this;
        }

        private Builder numJrtConnectionsPerNode(String __value) {
            return this.numJrtConnectionsPerNode(Integer.valueOf(__value));
        }

        public Builder warmuptime(double __value) {
            this.warmuptime = __value;
            return this;
        }

        private Builder warmuptime(String __value) {
            return this.warmuptime(Double.valueOf(__value));
        }

        public Builder node(Node.Builder __builder) {
            this.node.add(__builder);
            return this;
        }

        public Builder node(Consumer<Node.Builder> __func) {
            Node.Builder __inner = new Node.Builder();
            __func.accept(__inner);
            this.node.add(__inner);
            return this;
        }

        public Builder node(List<Node.Builder> __builders) {
            this.node = __builders;
            return this;
        }

        public Builder mergeGroupingResultInSearchInvokerEnabled(boolean __value) {
            this.mergeGroupingResultInSearchInvokerEnabled = __value;
            return this;
        }

        private Builder mergeGroupingResultInSearchInvokerEnabled(String __value) {
            return this.mergeGroupingResultInSearchInvokerEnabled(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DispatchConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DispatchConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DispatchConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DispatchConfig build() {
            return new DispatchConfig(this);
        }
    }

    public static final class DistributionPolicy
    extends EnumNode<Enum> {
        public static final Enum ROUNDROBIN = Enum.ROUNDROBIN;
        public static final Enum BEST_OF_RANDOM_2 = Enum.BEST_OF_RANDOM_2;
        public static final Enum LATENCY_AMORTIZED_OVER_REQUESTS = Enum.LATENCY_AMORTIZED_OVER_REQUESTS;
        public static final Enum LATENCY_AMORTIZED_OVER_TIME = Enum.LATENCY_AMORTIZED_OVER_TIME;
        public static final Enum ADAPTIVE = Enum.ADAPTIVE;

        public DistributionPolicy() {
            this.value = null;
        }

        public DistributionPolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ROUNDROBIN,
            BEST_OF_RANDOM_2,
            LATENCY_AMORTIZED_OVER_REQUESTS,
            LATENCY_AMORTIZED_OVER_TIME,
            ADAPTIVE;

        }
    }

    public static final class Node
    extends InnerNode {
        private final IntegerNode key;
        private final IntegerNode group;
        private final StringNode host;
        private final IntegerNode port;

        public Node(Builder builder) {
            this(builder, true);
        }

        private Node(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for dispatch.node[] must be initialized: " + builder.__uninitialized);
            }
            this.key = builder.key == null ? new IntegerNode() : new IntegerNode(builder.key.intValue());
            this.group = builder.group == null ? new IntegerNode(0) : new IntegerNode(builder.group.intValue());
            this.host = builder.host == null ? new StringNode() : new StringNode(builder.host);
            this.port = builder.port == null ? new IntegerNode() : new IntegerNode(builder.port.intValue());
        }

        public int key() {
            return this.key.value();
        }

        public int group() {
            return this.group.value();
        }

        public String host() {
            return this.host.value();
        }

        public int port() {
            return this.port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
            return changes;
        }

        private static InnerNodeVector<Node> createVector(List<Builder> builders) {
            ArrayList<Node> elems = new ArrayList<Node>();
            for (Builder b : builders) {
                elems.add(new Node(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("key", "host", "port"));
            private Integer key = null;
            private Integer group = null;
            private String host = null;
            private Integer port = null;

            public Builder() {
            }

            public Builder(Node config) {
                this.key(config.key());
                this.group(config.group());
                this.host(config.host());
                this.port(config.port());
            }

            private Builder override(Builder __superior) {
                if (__superior.key != null) {
                    this.key(__superior.key);
                }
                if (__superior.group != null) {
                    this.group(__superior.group);
                }
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                return this;
            }

            public Builder key(int __value) {
                this.key = __value;
                this.__uninitialized.remove("key");
                return this;
            }

            private Builder key(String __value) {
                return this.key(Integer.valueOf(__value));
            }

            public Builder group(int __value) {
                this.group = __value;
                return this;
            }

            private Builder group(String __value) {
                return this.group(Integer.valueOf(__value));
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                this.__uninitialized.remove("host");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                this.__uninitialized.remove("port");
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Node build() {
                return new Node(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

