/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class DistributionConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "38063abe32cb8050720cc9487f733ba0";
    public static final String CONFIG_DEF_NAME = "distribution";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "cluster{}.active_per_leaf_group bool default=false", "cluster{}.ready_copies int default=0", "cluster{}.redundancy int default=3", "cluster{}.initial_redundancy int default=0", "cluster{}.group[].index string", "cluster{}.group[].name string", "cluster{}.group[].capacity double default=1", "cluster{}.group[].partitions string default=\"\"", "cluster{}.group[].nodes[].index int", "cluster{}.group[].nodes[].retired bool default=false"};
    private final Map<String, Cluster> cluster;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DistributionConfig(Builder builder) {
        this(builder, true);
    }

    private DistributionConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for distribution must be initialized: " + builder.__uninitialized);
        }
        this.cluster = Cluster.createMap(builder.cluster);
    }

    public Map<String, Cluster> cluster() {
        return Collections.unmodifiableMap(this.cluster);
    }

    public Cluster cluster(String key) {
        return this.cluster.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DistributionConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Cluster.Builder> cluster = new LinkedHashMap<String, Cluster.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DistributionConfig config) {
            for (Map.Entry<String, Cluster> __entry : config.cluster().entrySet()) {
                this.cluster(__entry.getKey(), new Cluster.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.cluster(__superior.cluster);
            return this;
        }

        public Builder cluster(String __key, Cluster.Builder __value) {
            this.cluster.put(__key, __value);
            return this;
        }

        public Builder cluster(Map<String, Cluster.Builder> __values) {
            this.cluster.putAll(__values);
            return this;
        }

        public Builder cluster(String __key, Consumer<Cluster.Builder> __func) {
            Cluster.Builder __inner = new Cluster.Builder();
            __func.accept(__inner);
            this.cluster.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DistributionConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DistributionConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DistributionConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DistributionConfig build() {
            return new DistributionConfig(this);
        }
    }

    public static final class Cluster
    extends InnerNode {
        private final BooleanNode active_per_leaf_group;
        private final IntegerNode ready_copies;
        private final IntegerNode redundancy;
        private final IntegerNode initial_redundancy;
        private final InnerNodeVector<Group> group;

        public Cluster(Builder builder) {
            this(builder, true);
        }

        private Cluster(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for distribution.cluster{} must be initialized: " + builder.__uninitialized);
            }
            this.active_per_leaf_group = builder.active_per_leaf_group == null ? new BooleanNode(false) : new BooleanNode(builder.active_per_leaf_group.booleanValue());
            this.ready_copies = builder.ready_copies == null ? new IntegerNode(0) : new IntegerNode(builder.ready_copies.intValue());
            this.redundancy = builder.redundancy == null ? new IntegerNode(3) : new IntegerNode(builder.redundancy.intValue());
            this.initial_redundancy = builder.initial_redundancy == null ? new IntegerNode(0) : new IntegerNode(builder.initial_redundancy.intValue());
            this.group = Group.createVector(builder.group);
        }

        public boolean active_per_leaf_group() {
            return this.active_per_leaf_group.value();
        }

        public int ready_copies() {
            return this.ready_copies.value();
        }

        public int redundancy() {
            return this.redundancy.value();
        }

        public int initial_redundancy() {
            return this.initial_redundancy.value();
        }

        public List<Group> group() {
            return this.group;
        }

        public Group group(int i) {
            return (Group)((Object)this.group.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Cluster newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster");
            return changes;
        }

        private static Map<String, Cluster> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Cluster> ret = new LinkedHashMap<String, Cluster>();
            for (String key : builders.keySet()) {
                ret.put(key, new Cluster(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean active_per_leaf_group = null;
            private Integer ready_copies = null;
            private Integer redundancy = null;
            private Integer initial_redundancy = null;
            public List<Group.Builder> group = new ArrayList<Group.Builder>();

            public Builder() {
            }

            public Builder(Cluster config) {
                this.active_per_leaf_group(config.active_per_leaf_group());
                this.ready_copies(config.ready_copies());
                this.redundancy(config.redundancy());
                this.initial_redundancy(config.initial_redundancy());
                for (Group g : config.group()) {
                    this.group(new Group.Builder(g));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.active_per_leaf_group != null) {
                    this.active_per_leaf_group(__superior.active_per_leaf_group);
                }
                if (__superior.ready_copies != null) {
                    this.ready_copies(__superior.ready_copies);
                }
                if (__superior.redundancy != null) {
                    this.redundancy(__superior.redundancy);
                }
                if (__superior.initial_redundancy != null) {
                    this.initial_redundancy(__superior.initial_redundancy);
                }
                if (!__superior.group.isEmpty()) {
                    this.group.addAll(__superior.group);
                }
                return this;
            }

            public Builder active_per_leaf_group(boolean __value) {
                this.active_per_leaf_group = __value;
                return this;
            }

            private Builder active_per_leaf_group(String __value) {
                return this.active_per_leaf_group(Boolean.valueOf(__value));
            }

            public Builder ready_copies(int __value) {
                this.ready_copies = __value;
                return this;
            }

            private Builder ready_copies(String __value) {
                return this.ready_copies(Integer.valueOf(__value));
            }

            public Builder redundancy(int __value) {
                this.redundancy = __value;
                return this;
            }

            private Builder redundancy(String __value) {
                return this.redundancy(Integer.valueOf(__value));
            }

            public Builder initial_redundancy(int __value) {
                this.initial_redundancy = __value;
                return this;
            }

            private Builder initial_redundancy(String __value) {
                return this.initial_redundancy(Integer.valueOf(__value));
            }

            public Builder group(Group.Builder __builder) {
                this.group.add(__builder);
                return this;
            }

            public Builder group(Consumer<Group.Builder> __func) {
                Group.Builder __inner = new Group.Builder();
                __func.accept(__inner);
                this.group.add(__inner);
                return this;
            }

            public Builder group(List<Group.Builder> __builders) {
                this.group = __builders;
                return this;
            }

            public Cluster build() {
                return new Cluster(this);
            }
        }

        public static final class Group
        extends InnerNode {
            private final StringNode index;
            private final StringNode name;
            private final DoubleNode capacity;
            private final StringNode partitions;
            private final InnerNodeVector<Nodes> nodes;

            public Group(Builder builder) {
                this(builder, true);
            }

            private Group(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for distribution.cluster{}.group[] must be initialized: " + builder.__uninitialized);
                }
                this.index = builder.index == null ? new StringNode() : new StringNode(builder.index);
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.capacity = builder.capacity == null ? new DoubleNode(1.0) : new DoubleNode(builder.capacity.doubleValue());
                this.partitions = builder.partitions == null ? new StringNode("") : new StringNode(builder.partitions);
                this.nodes = Nodes.createVector(builder.nodes);
            }

            public String index() {
                return this.index.value();
            }

            public String name() {
                return this.name.value();
            }

            public double capacity() {
                return this.capacity.value();
            }

            public String partitions() {
                return this.partitions.value();
            }

            public List<Nodes> nodes() {
                return this.nodes;
            }

            public Nodes nodes(int i) {
                return (Nodes)((Object)this.nodes.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Group newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("group");
                return changes;
            }

            private static InnerNodeVector<Group> createVector(List<Builder> builders) {
                ArrayList<Group> elems = new ArrayList<Group>();
                for (Builder b : builders) {
                    elems.add(new Group(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("index", "name"));
                private String index = null;
                private String name = null;
                private Double capacity = null;
                private String partitions = null;
                public List<Nodes.Builder> nodes = new ArrayList<Nodes.Builder>();

                public Builder() {
                }

                public Builder(Group config) {
                    this.index(config.index());
                    this.name(config.name());
                    this.capacity(config.capacity());
                    this.partitions(config.partitions());
                    for (Nodes n : config.nodes()) {
                        this.nodes(new Nodes.Builder(n));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.index != null) {
                        this.index(__superior.index);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.capacity != null) {
                        this.capacity(__superior.capacity);
                    }
                    if (__superior.partitions != null) {
                        this.partitions(__superior.partitions);
                    }
                    if (!__superior.nodes.isEmpty()) {
                        this.nodes.addAll(__superior.nodes);
                    }
                    return this;
                }

                public Builder index(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.index = __value;
                    this.__uninitialized.remove("index");
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder capacity(double __value) {
                    this.capacity = __value;
                    return this;
                }

                private Builder capacity(String __value) {
                    return this.capacity(Double.valueOf(__value));
                }

                public Builder partitions(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.partitions = __value;
                    return this;
                }

                public Builder nodes(Nodes.Builder __builder) {
                    this.nodes.add(__builder);
                    return this;
                }

                public Builder nodes(Consumer<Nodes.Builder> __func) {
                    Nodes.Builder __inner = new Nodes.Builder();
                    __func.accept(__inner);
                    this.nodes.add(__inner);
                    return this;
                }

                public Builder nodes(List<Nodes.Builder> __builders) {
                    this.nodes = __builders;
                    return this;
                }

                public Group build() {
                    return new Group(this);
                }
            }

            public static final class Nodes
            extends InnerNode {
                private final IntegerNode index;
                private final BooleanNode retired;

                public Nodes(Builder builder) {
                    this(builder, true);
                }

                private Nodes(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for distribution.cluster{}.group[].nodes[] must be initialized: " + builder.__uninitialized);
                    }
                    this.index = builder.index == null ? new IntegerNode() : new IntegerNode(builder.index.intValue());
                    this.retired = builder.retired == null ? new BooleanNode(false) : new BooleanNode(builder.retired.booleanValue());
                }

                public int index() {
                    return this.index.value();
                }

                public boolean retired() {
                    return this.retired.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Nodes newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("nodes");
                    return changes;
                }

                private static InnerNodeVector<Nodes> createVector(List<Builder> builders) {
                    ArrayList<Nodes> elems = new ArrayList<Nodes>();
                    for (Builder b : builders) {
                        elems.add(new Nodes(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("index"));
                    private Integer index = null;
                    private Boolean retired = null;

                    public Builder() {
                    }

                    public Builder(Nodes config) {
                        this.index(config.index());
                        this.retired(config.retired());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.index != null) {
                            this.index(__superior.index);
                        }
                        if (__superior.retired != null) {
                            this.retired(__superior.retired);
                        }
                        return this;
                    }

                    public Builder index(int __value) {
                        this.index = __value;
                        this.__uninitialized.remove("index");
                        return this;
                    }

                    private Builder index(String __value) {
                        return this.index(Integer.valueOf(__value));
                    }

                    public Builder retired(boolean __value) {
                        this.retired = __value;
                        return this;
                    }

                    private Builder retired(String __value) {
                        return this.retired(Boolean.valueOf(__value));
                    }

                    public Nodes build() {
                        return new Nodes(this);
                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

