/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.orchestrator.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class OrchestratorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "6e219d782624697a8256471110590f04";
    public static final String CONFIG_DEF_NAME = "orchestrator";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.orchestrator.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.orchestrator.config", "serviceMonitorConvergenceLatencySeconds int default=0", "numProxies int default=0", "numProxiesAllowedDown int default=1", "numProxiesAllowedDownRatio double default=0.1"};
    private final IntegerNode serviceMonitorConvergenceLatencySeconds;
    private final IntegerNode numProxies;
    private final IntegerNode numProxiesAllowedDown;
    private final DoubleNode numProxiesAllowedDownRatio;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OrchestratorConfig(Builder builder) {
        this(builder, true);
    }

    private OrchestratorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for orchestrator must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.serviceMonitorConvergenceLatencySeconds = builder.serviceMonitorConvergenceLatencySeconds == null ? new IntegerNode(0) : new IntegerNode(builder.serviceMonitorConvergenceLatencySeconds.intValue());
        this.numProxies = builder.numProxies == null ? new IntegerNode(0) : new IntegerNode(builder.numProxies.intValue());
        this.numProxiesAllowedDown = builder.numProxiesAllowedDown == null ? new IntegerNode(1) : new IntegerNode(builder.numProxiesAllowedDown.intValue());
        this.numProxiesAllowedDownRatio = builder.numProxiesAllowedDownRatio == null ? new DoubleNode(0.1) : new DoubleNode(builder.numProxiesAllowedDownRatio.doubleValue());
    }

    public int serviceMonitorConvergenceLatencySeconds() {
        return this.serviceMonitorConvergenceLatencySeconds.value();
    }

    public int numProxies() {
        return this.numProxies.value();
    }

    public int numProxiesAllowedDown() {
        return this.numProxiesAllowedDown.value();
    }

    public double numProxiesAllowedDownRatio() {
        return this.numProxiesAllowedDownRatio.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OrchestratorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer serviceMonitorConvergenceLatencySeconds = null;
        private Integer numProxies = null;
        private Integer numProxiesAllowedDown = null;
        private Double numProxiesAllowedDownRatio = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OrchestratorConfig config) {
            this.serviceMonitorConvergenceLatencySeconds(config.serviceMonitorConvergenceLatencySeconds());
            this.numProxies(config.numProxies());
            this.numProxiesAllowedDown(config.numProxiesAllowedDown());
            this.numProxiesAllowedDownRatio(config.numProxiesAllowedDownRatio());
        }

        private Builder override(Builder __superior) {
            if (__superior.serviceMonitorConvergenceLatencySeconds != null) {
                this.serviceMonitorConvergenceLatencySeconds(__superior.serviceMonitorConvergenceLatencySeconds);
            }
            if (__superior.numProxies != null) {
                this.numProxies(__superior.numProxies);
            }
            if (__superior.numProxiesAllowedDown != null) {
                this.numProxiesAllowedDown(__superior.numProxiesAllowedDown);
            }
            if (__superior.numProxiesAllowedDownRatio != null) {
                this.numProxiesAllowedDownRatio(__superior.numProxiesAllowedDownRatio);
            }
            return this;
        }

        public Builder serviceMonitorConvergenceLatencySeconds(int __value) {
            this.serviceMonitorConvergenceLatencySeconds = __value;
            return this;
        }

        private Builder serviceMonitorConvergenceLatencySeconds(String __value) {
            return this.serviceMonitorConvergenceLatencySeconds(Integer.valueOf(__value));
        }

        public Builder numProxies(int __value) {
            this.numProxies = __value;
            return this;
        }

        private Builder numProxies(String __value) {
            return this.numProxies(Integer.valueOf(__value));
        }

        public Builder numProxiesAllowedDown(int __value) {
            this.numProxiesAllowedDown = __value;
            return this;
        }

        private Builder numProxiesAllowedDown(String __value) {
            return this.numProxiesAllowedDown(Integer.valueOf(__value));
        }

        public Builder numProxiesAllowedDownRatio(double __value) {
            this.numProxiesAllowedDownRatio = __value;
            return this;
        }

        private Builder numProxiesAllowedDownRatio(String __value) {
            return this.numProxiesAllowedDownRatio(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OrchestratorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OrchestratorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OrchestratorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OrchestratorConfig build() {
            return new OrchestratorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

