/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class IndexschemaConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3f4a875b74c4ef2e4ffe929c7172fdeb";
    public static final String CONFIG_DEF_NAME = "indexschema";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "indexfield[].name string", "indexfield[].datatype enum { STRING, INT64 } default=STRING", "indexfield[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE", "indexfield[].prefix bool default=false", "indexfield[].phrases bool default=false", "indexfield[].positions bool default=true", "indexfield[].averageelementlen int default=512", "indexfield[].interleavedfeatures bool default=false", "fieldset[].name string", "fieldset[].field[].name string"};
    private final InnerNodeVector<Indexfield> indexfield;
    private final InnerNodeVector<Fieldset> fieldset;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public IndexschemaConfig(Builder builder) {
        this(builder, true);
    }

    private IndexschemaConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for indexschema must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.indexfield = Indexfield.createVector(builder.indexfield);
        this.fieldset = Fieldset.createVector(builder.fieldset);
    }

    public List<Indexfield> indexfield() {
        return this.indexfield;
    }

    public Indexfield indexfield(int i) {
        return (Indexfield)((Object)this.indexfield.get(i));
    }

    public List<Fieldset> fieldset() {
        return this.fieldset;
    }

    public Fieldset fieldset(int i) {
        return (Fieldset)((Object)this.fieldset.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(IndexschemaConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Indexfield.Builder> indexfield = new ArrayList<Indexfield.Builder>();
        public List<Fieldset.Builder> fieldset = new ArrayList<Fieldset.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(IndexschemaConfig config) {
            for (Indexfield i : config.indexfield()) {
                this.indexfield(new Indexfield.Builder(i));
            }
            for (Fieldset f : config.fieldset()) {
                this.fieldset(new Fieldset.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.indexfield.isEmpty()) {
                this.indexfield.addAll(__superior.indexfield);
            }
            if (!__superior.fieldset.isEmpty()) {
                this.fieldset.addAll(__superior.fieldset);
            }
            return this;
        }

        public Builder indexfield(Indexfield.Builder __builder) {
            this.indexfield.add(__builder);
            return this;
        }

        public Builder indexfield(Consumer<Indexfield.Builder> __func) {
            Indexfield.Builder __inner = new Indexfield.Builder();
            __func.accept(__inner);
            this.indexfield.add(__inner);
            return this;
        }

        public Builder indexfield(List<Indexfield.Builder> __builders) {
            this.indexfield = __builders;
            return this;
        }

        public Builder fieldset(Fieldset.Builder __builder) {
            this.fieldset.add(__builder);
            return this;
        }

        public Builder fieldset(Consumer<Fieldset.Builder> __func) {
            Fieldset.Builder __inner = new Fieldset.Builder();
            __func.accept(__inner);
            this.fieldset.add(__inner);
            return this;
        }

        public Builder fieldset(List<Fieldset.Builder> __builders) {
            this.fieldset = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return IndexschemaConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return IndexschemaConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return IndexschemaConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public IndexschemaConfig build() {
            return new IndexschemaConfig(this);
        }
    }

    public static final class Indexfield
    extends InnerNode {
        private final StringNode name;
        private final Datatype datatype;
        private final Collectiontype collectiontype;
        private final BooleanNode prefix;
        private final BooleanNode phrases;
        private final BooleanNode positions;
        private final IntegerNode averageelementlen;
        private final BooleanNode interleavedfeatures;

        public Indexfield(Builder builder) {
            this(builder, true);
        }

        private Indexfield(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for indexschema.indexfield[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.datatype = builder.datatype == null ? new Datatype(Datatype.STRING) : new Datatype(builder.datatype);
            this.collectiontype = builder.collectiontype == null ? new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
            this.prefix = builder.prefix == null ? new BooleanNode(false) : new BooleanNode(builder.prefix.booleanValue());
            this.phrases = builder.phrases == null ? new BooleanNode(false) : new BooleanNode(builder.phrases.booleanValue());
            this.positions = builder.positions == null ? new BooleanNode(true) : new BooleanNode(builder.positions.booleanValue());
            this.averageelementlen = builder.averageelementlen == null ? new IntegerNode(512) : new IntegerNode(builder.averageelementlen.intValue());
            this.interleavedfeatures = builder.interleavedfeatures == null ? new BooleanNode(false) : new BooleanNode(builder.interleavedfeatures.booleanValue());
        }

        public String name() {
            return this.name.value();
        }

        public Datatype.Enum datatype() {
            return (Datatype.Enum)((Object)this.datatype.value());
        }

        public Collectiontype.Enum collectiontype() {
            return (Collectiontype.Enum)((Object)this.collectiontype.value());
        }

        public boolean prefix() {
            return this.prefix.value();
        }

        public boolean phrases() {
            return this.phrases.value();
        }

        public boolean positions() {
            return this.positions.value();
        }

        public int averageelementlen() {
            return this.averageelementlen.value();
        }

        public boolean interleavedfeatures() {
            return this.interleavedfeatures.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Indexfield newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("indexfield");
            return changes;
        }

        private static InnerNodeVector<Indexfield> createVector(List<Builder> builders) {
            ArrayList<Indexfield> elems = new ArrayList<Indexfield>();
            for (Builder b : builders) {
                elems.add(new Indexfield(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
            private String name = null;
            private Datatype.Enum datatype = null;
            private Collectiontype.Enum collectiontype = null;
            private Boolean prefix = null;
            private Boolean phrases = null;
            private Boolean positions = null;
            private Integer averageelementlen = null;
            private Boolean interleavedfeatures = null;

            public Builder() {
            }

            public Builder(Indexfield config) {
                this.name(config.name());
                this.datatype(config.datatype());
                this.collectiontype(config.collectiontype());
                this.prefix(config.prefix());
                this.phrases(config.phrases());
                this.positions(config.positions());
                this.averageelementlen(config.averageelementlen());
                this.interleavedfeatures(config.interleavedfeatures());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (__superior.collectiontype != null) {
                    this.collectiontype(__superior.collectiontype);
                }
                if (__superior.prefix != null) {
                    this.prefix(__superior.prefix);
                }
                if (__superior.phrases != null) {
                    this.phrases(__superior.phrases);
                }
                if (__superior.positions != null) {
                    this.positions(__superior.positions);
                }
                if (__superior.averageelementlen != null) {
                    this.averageelementlen(__superior.averageelementlen);
                }
                if (__superior.interleavedfeatures != null) {
                    this.interleavedfeatures(__superior.interleavedfeatures);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder datatype(Datatype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Datatype.Enum.valueOf(__value));
            }

            public Builder collectiontype(Collectiontype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.collectiontype = __value;
                return this;
            }

            private Builder collectiontype(String __value) {
                return this.collectiontype(Collectiontype.Enum.valueOf(__value));
            }

            public Builder prefix(boolean __value) {
                this.prefix = __value;
                return this;
            }

            private Builder prefix(String __value) {
                return this.prefix(Boolean.valueOf(__value));
            }

            public Builder phrases(boolean __value) {
                this.phrases = __value;
                return this;
            }

            private Builder phrases(String __value) {
                return this.phrases(Boolean.valueOf(__value));
            }

            public Builder positions(boolean __value) {
                this.positions = __value;
                return this;
            }

            private Builder positions(String __value) {
                return this.positions(Boolean.valueOf(__value));
            }

            public Builder averageelementlen(int __value) {
                this.averageelementlen = __value;
                return this;
            }

            private Builder averageelementlen(String __value) {
                return this.averageelementlen(Integer.valueOf(__value));
            }

            public Builder interleavedfeatures(boolean __value) {
                this.interleavedfeatures = __value;
                return this;
            }

            private Builder interleavedfeatures(String __value) {
                return this.interleavedfeatures(Boolean.valueOf(__value));
            }

            public Indexfield build() {
                return new Indexfield(this);
            }
        }

        public static final class Datatype
        extends EnumNode<Enum> {
            public static final Enum STRING = Enum.STRING;
            public static final Enum INT64 = Enum.INT64;

            public Datatype() {
                this.value = null;
            }

            public Datatype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STRING,
                INT64;

            }
        }

        public static final class Collectiontype
        extends EnumNode<Enum> {
            public static final Enum SINGLE = Enum.SINGLE;
            public static final Enum ARRAY = Enum.ARRAY;
            public static final Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

            public Collectiontype() {
                this.value = null;
            }

            public Collectiontype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SINGLE,
                ARRAY,
                WEIGHTEDSET;

            }
        }
    }

    public static final class Fieldset
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Field> field;

        public Fieldset(Builder builder) {
            this(builder, true);
        }

        private Fieldset(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for indexschema.fieldset[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.field = Field.createVector(builder.field);
        }

        public String name() {
            return this.name.value();
        }

        public List<Field> field() {
            return this.field;
        }

        public Field field(int i) {
            return (Field)((Object)this.field.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fieldset newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldset");
            return changes;
        }

        private static InnerNodeVector<Fieldset> createVector(List<Builder> builders) {
            ArrayList<Fieldset> elems = new ArrayList<Fieldset>();
            for (Builder b : builders) {
                elems.add(new Fieldset(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
            private String name = null;
            public List<Field.Builder> field = new ArrayList<Field.Builder>();

            public Builder() {
            }

            public Builder(Fieldset config) {
                this.name(config.name());
                for (Field f : config.field()) {
                    this.field(new Field.Builder(f));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.field.isEmpty()) {
                    this.field.addAll(__superior.field);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder field(Field.Builder __builder) {
                this.field.add(__builder);
                return this;
            }

            public Builder field(Consumer<Field.Builder> __func) {
                Field.Builder __inner = new Field.Builder();
                __func.accept(__inner);
                this.field.add(__inner);
                return this;
            }

            public Builder field(List<Field.Builder> __builders) {
                this.field = __builders;
                return this;
            }

            public Fieldset build() {
                return new Fieldset(this);
            }
        }

        public static final class Field
        extends InnerNode {
            private final StringNode name;

            public Field(Builder builder) {
                this(builder, true);
            }

            private Field(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for indexschema.fieldset[].field[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                return changes;
            }

            private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                ArrayList<Field> elems = new ArrayList<Field>();
                for (Builder b : builders) {
                    elems.add(new Field(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;

                public Builder() {
                }

                public Builder(Field config) {
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Field build() {
                    return new Field(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

