/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class LbServicesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "71d168615a8aa43c5ca2bbc6526adb7c";
    public static final String CONFIG_DEF_NAME = "lb-services";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "tenants{}.applications{}.activeRotation bool default=true", "tenants{}.applications{}.endpoints[].dnsName string", "tenants{}.applications{}.endpoints[].clusterId string", "tenants{}.applications{}.endpoints[].scope enum {application, global, zone}", "tenants{}.applications{}.endpoints[].routingMethod enum {shared, sharedLayer4}", "tenants{}.applications{}.endpoints[].weight int default=1", "tenants{}.applications{}.endpoints[].hosts[] string"};
    private final Map<String, Tenants> tenants;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LbServicesConfig(Builder builder) {
        this(builder, true);
    }

    private LbServicesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for lb-services must be initialized: " + builder.__uninitialized);
        }
        this.tenants = Tenants.createMap(builder.tenants);
    }

    public Map<String, Tenants> tenants() {
        return Collections.unmodifiableMap(this.tenants);
    }

    public Tenants tenants(String key) {
        return this.tenants.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LbServicesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Tenants.Builder> tenants = new LinkedHashMap<String, Tenants.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LbServicesConfig config) {
            for (Map.Entry<String, Tenants> __entry : config.tenants().entrySet()) {
                this.tenants(__entry.getKey(), new Tenants.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.tenants(__superior.tenants);
            return this;
        }

        public Builder tenants(String __key, Tenants.Builder __value) {
            this.tenants.put(__key, __value);
            return this;
        }

        public Builder tenants(Map<String, Tenants.Builder> __values) {
            this.tenants.putAll(__values);
            return this;
        }

        public Builder tenants(String __key, Consumer<Tenants.Builder> __func) {
            Tenants.Builder __inner = new Tenants.Builder();
            __func.accept(__inner);
            this.tenants.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LbServicesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LbServicesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LbServicesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LbServicesConfig build() {
            return new LbServicesConfig(this);
        }
    }

    public static final class Tenants
    extends InnerNode {
        private final Map<String, Applications> applications;

        public Tenants(Builder builder) {
            this(builder, true);
        }

        private Tenants(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{} must be initialized: " + builder.__uninitialized);
            }
            this.applications = Applications.createMap(builder.applications);
        }

        public Map<String, Applications> applications() {
            return Collections.unmodifiableMap(this.applications);
        }

        public Applications applications(String key) {
            return this.applications.get(key);
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Tenants newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("tenants");
            return changes;
        }

        private static Map<String, Tenants> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Tenants> ret = new LinkedHashMap<String, Tenants>();
            for (String key : builders.keySet()) {
                ret.put(key, new Tenants(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Map<String, Applications.Builder> applications = new LinkedHashMap<String, Applications.Builder>();

            public Builder() {
            }

            public Builder(Tenants config) {
                for (Map.Entry<String, Applications> __entry : config.applications().entrySet()) {
                    this.applications(__entry.getKey(), new Applications.Builder(__entry.getValue()));
                }
            }

            private Builder override(Builder __superior) {
                this.applications(__superior.applications);
                return this;
            }

            public Builder applications(String __key, Applications.Builder __value) {
                this.applications.put(__key, __value);
                return this;
            }

            public Builder applications(Map<String, Applications.Builder> __values) {
                this.applications.putAll(__values);
                return this;
            }

            public Builder applications(String __key, Consumer<Applications.Builder> __func) {
                Applications.Builder __inner = new Applications.Builder();
                __func.accept(__inner);
                this.applications.put(__key, __inner);
                return this;
            }

            public Tenants build() {
                return new Tenants(this);
            }
        }

        public static final class Applications
        extends InnerNode {
            private final BooleanNode activeRotation;
            private final InnerNodeVector<Endpoints> endpoints;

            public Applications(Builder builder) {
                this(builder, true);
            }

            private Applications(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{} must be initialized: " + builder.__uninitialized);
                }
                this.activeRotation = builder.activeRotation == null ? new BooleanNode(true) : new BooleanNode(builder.activeRotation.booleanValue());
                this.endpoints = Endpoints.createVector(builder.endpoints);
            }

            public boolean activeRotation() {
                return this.activeRotation.value();
            }

            public List<Endpoints> endpoints() {
                return this.endpoints;
            }

            public Endpoints endpoints(int i) {
                return (Endpoints)((Object)this.endpoints.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Applications newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("applications");
                return changes;
            }

            private static Map<String, Applications> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, Applications> ret = new LinkedHashMap<String, Applications>();
                for (String key : builders.keySet()) {
                    ret.put(key, new Applications(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean activeRotation = null;
                public List<Endpoints.Builder> endpoints = new ArrayList<Endpoints.Builder>();

                public Builder() {
                }

                public Builder(Applications config) {
                    this.activeRotation(config.activeRotation());
                    for (Endpoints e : config.endpoints()) {
                        this.endpoints(new Endpoints.Builder(e));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.activeRotation != null) {
                        this.activeRotation(__superior.activeRotation);
                    }
                    if (!__superior.endpoints.isEmpty()) {
                        this.endpoints.addAll(__superior.endpoints);
                    }
                    return this;
                }

                public Builder activeRotation(boolean __value) {
                    this.activeRotation = __value;
                    return this;
                }

                private Builder activeRotation(String __value) {
                    return this.activeRotation(Boolean.valueOf(__value));
                }

                public Builder endpoints(Endpoints.Builder __builder) {
                    this.endpoints.add(__builder);
                    return this;
                }

                public Builder endpoints(Consumer<Endpoints.Builder> __func) {
                    Endpoints.Builder __inner = new Endpoints.Builder();
                    __func.accept(__inner);
                    this.endpoints.add(__inner);
                    return this;
                }

                public Builder endpoints(List<Endpoints.Builder> __builders) {
                    this.endpoints = __builders;
                    return this;
                }

                public Applications build() {
                    return new Applications(this);
                }
            }

            public static final class Endpoints
            extends InnerNode {
                private final StringNode dnsName;
                private final StringNode clusterId;
                private final Scope scope;
                private final RoutingMethod routingMethod;
                private final IntegerNode weight;
                private final LeafNodeVector<String, StringNode> hosts;

                public Endpoints(Builder builder) {
                    this(builder, true);
                }

                private Endpoints(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{}.endpoints[] must be initialized: " + builder.__uninitialized);
                    }
                    this.dnsName = builder.dnsName == null ? new StringNode() : new StringNode(builder.dnsName);
                    this.clusterId = builder.clusterId == null ? new StringNode() : new StringNode(builder.clusterId);
                    this.scope = builder.scope == null ? new Scope() : new Scope(builder.scope);
                    this.routingMethod = builder.routingMethod == null ? new RoutingMethod() : new RoutingMethod(builder.routingMethod);
                    this.weight = builder.weight == null ? new IntegerNode(1) : new IntegerNode(builder.weight.intValue());
                    this.hosts = new LeafNodeVector(builder.hosts, (LeafNode)new StringNode());
                }

                public String dnsName() {
                    return this.dnsName.value();
                }

                public String clusterId() {
                    return this.clusterId.value();
                }

                public Scope.Enum scope() {
                    return (Scope.Enum)((Object)this.scope.value());
                }

                public RoutingMethod.Enum routingMethod() {
                    return (RoutingMethod.Enum)((Object)this.routingMethod.value());
                }

                public int weight() {
                    return this.weight.value();
                }

                public List<String> hosts() {
                    return this.hosts.asList();
                }

                public String hosts(int i) {
                    return ((StringNode)this.hosts.get(i)).value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Endpoints newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("endpoints");
                    return changes;
                }

                private static InnerNodeVector<Endpoints> createVector(List<Builder> builders) {
                    ArrayList<Endpoints> elems = new ArrayList<Endpoints>();
                    for (Builder b : builders) {
                        elems.add(new Endpoints(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("dnsName", "clusterId", "scope", "routingMethod"));
                    private String dnsName = null;
                    private String clusterId = null;
                    private Scope.Enum scope = null;
                    private RoutingMethod.Enum routingMethod = null;
                    private Integer weight = null;
                    public List<String> hosts = new ArrayList<String>();

                    public Builder() {
                    }

                    public Builder(Endpoints config) {
                        this.dnsName(config.dnsName());
                        this.clusterId(config.clusterId());
                        this.scope(config.scope());
                        this.routingMethod(config.routingMethod());
                        this.weight(config.weight());
                        this.hosts(config.hosts());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.dnsName != null) {
                            this.dnsName(__superior.dnsName);
                        }
                        if (__superior.clusterId != null) {
                            this.clusterId(__superior.clusterId);
                        }
                        if (__superior.scope != null) {
                            this.scope(__superior.scope);
                        }
                        if (__superior.routingMethod != null) {
                            this.routingMethod(__superior.routingMethod);
                        }
                        if (__superior.weight != null) {
                            this.weight(__superior.weight);
                        }
                        if (!__superior.hosts.isEmpty()) {
                            this.hosts.addAll(__superior.hosts);
                        }
                        return this;
                    }

                    public Builder dnsName(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.dnsName = __value;
                        this.__uninitialized.remove("dnsName");
                        return this;
                    }

                    public Builder clusterId(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.clusterId = __value;
                        this.__uninitialized.remove("clusterId");
                        return this;
                    }

                    public Builder scope(Scope.Enum __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.scope = __value;
                        this.__uninitialized.remove("scope");
                        return this;
                    }

                    private Builder scope(String __value) {
                        return this.scope(Scope.Enum.valueOf(__value));
                    }

                    public Builder routingMethod(RoutingMethod.Enum __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.routingMethod = __value;
                        this.__uninitialized.remove("routingMethod");
                        return this;
                    }

                    private Builder routingMethod(String __value) {
                        return this.routingMethod(RoutingMethod.Enum.valueOf(__value));
                    }

                    public Builder weight(int __value) {
                        this.weight = __value;
                        return this;
                    }

                    private Builder weight(String __value) {
                        return this.weight(Integer.valueOf(__value));
                    }

                    public Builder hosts(String __value) {
                        this.hosts.add(__value);
                        return this;
                    }

                    public Builder hosts(Collection<String> __values) {
                        this.hosts.addAll(__values);
                        return this;
                    }

                    public Endpoints build() {
                        return new Endpoints(this);
                    }
                }

                public static final class Scope
                extends EnumNode<Enum> {
                    public static final Enum application = Enum.application;
                    public static final Enum global = Enum.global;
                    public static final Enum zone = Enum.zone;

                    public Scope() {
                        this.value = null;
                    }

                    public Scope(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        application,
                        global,
                        zone;

                    }
                }

                public static final class RoutingMethod
                extends EnumNode<Enum> {
                    public static final Enum shared = Enum.shared;
                    public static final Enum sharedLayer4 = Enum.sharedLayer4;

                    public RoutingMethod() {
                        this.value = null;
                    }

                    public RoutingMethod(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        shared,
                        sharedLayer4;

                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

