/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class BertBaseEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c5bffd334dab9189e0ab0d01a931a449";
    public static final String CONFIG_DEF_NAME = "bert-base-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding", "tokenizerVocab model", "transformerModel model", "transformerMaxTokens int default=384", "poolingStrategy enum { cls, mean } default=mean", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerTokenTypeIds string default=token_type_ids", "transformerStartSequenceToken int default=101", "transformerEndSequenceToken int default=102", "transformerOutput string default=output_0", "onnxExecutionMode enum { parallel, sequential } default=sequential", "onnxInterOpThreads int default=1", "onnxIntraOpThreads int default=-4", "onnxGpuDevice int default=0"};
    private final ModelNode tokenizerVocab;
    private final ModelNode transformerModel;
    private final IntegerNode transformerMaxTokens;
    private final PoolingStrategy poolingStrategy;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final StringNode transformerTokenTypeIds;
    private final IntegerNode transformerStartSequenceToken;
    private final IntegerNode transformerEndSequenceToken;
    private final StringNode transformerOutput;
    private final OnnxExecutionMode onnxExecutionMode;
    private final IntegerNode onnxInterOpThreads;
    private final IntegerNode onnxIntraOpThreads;
    private final IntegerNode onnxGpuDevice;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public BertBaseEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private BertBaseEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for bert-base-embedder must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.tokenizerVocab = builder.tokenizerVocab == null ? new ModelNode() : new ModelNode(builder.tokenizerVocab);
        this.transformerModel = builder.transformerModel == null ? new ModelNode() : new ModelNode(builder.transformerModel);
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(384) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.poolingStrategy = builder.poolingStrategy == null ? new PoolingStrategy(PoolingStrategy.mean) : new PoolingStrategy(builder.poolingStrategy);
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerTokenTypeIds = builder.transformerTokenTypeIds == null ? new StringNode("token_type_ids") : new StringNode(builder.transformerTokenTypeIds);
        this.transformerStartSequenceToken = builder.transformerStartSequenceToken == null ? new IntegerNode(101) : new IntegerNode(builder.transformerStartSequenceToken.intValue());
        this.transformerEndSequenceToken = builder.transformerEndSequenceToken == null ? new IntegerNode(102) : new IntegerNode(builder.transformerEndSequenceToken.intValue());
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("output_0") : new StringNode(builder.transformerOutput);
        this.onnxExecutionMode = builder.onnxExecutionMode == null ? new OnnxExecutionMode(OnnxExecutionMode.sequential) : new OnnxExecutionMode(builder.onnxExecutionMode);
        this.onnxInterOpThreads = builder.onnxInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.onnxInterOpThreads.intValue());
        this.onnxIntraOpThreads = builder.onnxIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.onnxIntraOpThreads.intValue());
        this.onnxGpuDevice = builder.onnxGpuDevice == null ? new IntegerNode(0) : new IntegerNode(builder.onnxGpuDevice.intValue());
    }

    public Path tokenizerVocab() {
        return (Path)this.tokenizerVocab.value();
    }

    public Path transformerModel() {
        return (Path)this.transformerModel.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public PoolingStrategy.Enum poolingStrategy() {
        return (PoolingStrategy.Enum)((Object)this.poolingStrategy.value());
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public String transformerTokenTypeIds() {
        return this.transformerTokenTypeIds.value();
    }

    public int transformerStartSequenceToken() {
        return this.transformerStartSequenceToken.value();
    }

    public int transformerEndSequenceToken() {
        return this.transformerEndSequenceToken.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    public OnnxExecutionMode.Enum onnxExecutionMode() {
        return (OnnxExecutionMode.Enum)((Object)this.onnxExecutionMode.value());
    }

    public int onnxInterOpThreads() {
        return this.onnxInterOpThreads.value();
    }

    public int onnxIntraOpThreads() {
        return this.onnxIntraOpThreads.value();
    }

    public int onnxGpuDevice() {
        return this.onnxGpuDevice.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(BertBaseEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("tokenizerVocab", "transformerModel"));
        private ModelReference tokenizerVocab = null;
        private ModelReference transformerModel = null;
        private Integer transformerMaxTokens = null;
        private PoolingStrategy.Enum poolingStrategy = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private String transformerTokenTypeIds = null;
        private Integer transformerStartSequenceToken = null;
        private Integer transformerEndSequenceToken = null;
        private String transformerOutput = null;
        private OnnxExecutionMode.Enum onnxExecutionMode = null;
        private Integer onnxInterOpThreads = null;
        private Integer onnxIntraOpThreads = null;
        private Integer onnxGpuDevice = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(BertBaseEmbedderConfig config) {
            this.tokenizerVocab(config.tokenizerVocab.getModelReference());
            this.transformerModel(config.transformerModel.getModelReference());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.poolingStrategy(config.poolingStrategy());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerTokenTypeIds(config.transformerTokenTypeIds());
            this.transformerStartSequenceToken(config.transformerStartSequenceToken());
            this.transformerEndSequenceToken(config.transformerEndSequenceToken());
            this.transformerOutput(config.transformerOutput());
            this.onnxExecutionMode(config.onnxExecutionMode());
            this.onnxInterOpThreads(config.onnxInterOpThreads());
            this.onnxIntraOpThreads(config.onnxIntraOpThreads());
            this.onnxGpuDevice(config.onnxGpuDevice());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerVocab != null) {
                this.tokenizerVocab(__superior.tokenizerVocab);
            }
            if (__superior.transformerModel != null) {
                this.transformerModel(__superior.transformerModel);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.poolingStrategy != null) {
                this.poolingStrategy(__superior.poolingStrategy);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerTokenTypeIds != null) {
                this.transformerTokenTypeIds(__superior.transformerTokenTypeIds);
            }
            if (__superior.transformerStartSequenceToken != null) {
                this.transformerStartSequenceToken(__superior.transformerStartSequenceToken);
            }
            if (__superior.transformerEndSequenceToken != null) {
                this.transformerEndSequenceToken(__superior.transformerEndSequenceToken);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            if (__superior.onnxExecutionMode != null) {
                this.onnxExecutionMode(__superior.onnxExecutionMode);
            }
            if (__superior.onnxInterOpThreads != null) {
                this.onnxInterOpThreads(__superior.onnxInterOpThreads);
            }
            if (__superior.onnxIntraOpThreads != null) {
                this.onnxIntraOpThreads(__superior.onnxIntraOpThreads);
            }
            if (__superior.onnxGpuDevice != null) {
                this.onnxGpuDevice(__superior.onnxGpuDevice);
            }
            return this;
        }

        public Builder tokenizerVocab(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerVocab = __value;
            this.__uninitialized.remove("tokenizerVocab");
            return this;
        }

        public Builder transformerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModel = __value;
            this.__uninitialized.remove("transformerModel");
            return this;
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder poolingStrategy(PoolingStrategy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.poolingStrategy = __value;
            return this;
        }

        private Builder poolingStrategy(String __value) {
            return this.poolingStrategy(PoolingStrategy.Enum.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerTokenTypeIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerTokenTypeIds = __value;
            return this;
        }

        public Builder transformerStartSequenceToken(int __value) {
            this.transformerStartSequenceToken = __value;
            return this;
        }

        private Builder transformerStartSequenceToken(String __value) {
            return this.transformerStartSequenceToken(Integer.valueOf(__value));
        }

        public Builder transformerEndSequenceToken(int __value) {
            this.transformerEndSequenceToken = __value;
            return this;
        }

        private Builder transformerEndSequenceToken(String __value) {
            return this.transformerEndSequenceToken(Integer.valueOf(__value));
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public Builder onnxExecutionMode(OnnxExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.onnxExecutionMode = __value;
            return this;
        }

        private Builder onnxExecutionMode(String __value) {
            return this.onnxExecutionMode(OnnxExecutionMode.Enum.valueOf(__value));
        }

        public Builder onnxInterOpThreads(int __value) {
            this.onnxInterOpThreads = __value;
            return this;
        }

        private Builder onnxInterOpThreads(String __value) {
            return this.onnxInterOpThreads(Integer.valueOf(__value));
        }

        public Builder onnxIntraOpThreads(int __value) {
            this.onnxIntraOpThreads = __value;
            return this;
        }

        private Builder onnxIntraOpThreads(String __value) {
            return this.onnxIntraOpThreads(Integer.valueOf(__value));
        }

        public Builder onnxGpuDevice(int __value) {
            this.onnxGpuDevice = __value;
            return this;
        }

        private Builder onnxGpuDevice(String __value) {
            return this.onnxGpuDevice(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return BertBaseEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return BertBaseEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return BertBaseEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public BertBaseEmbedderConfig build() {
            return new BertBaseEmbedderConfig(this);
        }
    }

    public static final class PoolingStrategy
    extends EnumNode<Enum> {
        public static final Enum cls = Enum.cls;
        public static final Enum mean = Enum.mean;

        public PoolingStrategy() {
            this.value = null;
        }

        public PoolingStrategy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            cls,
            mean;

        }
    }

    public static final class OnnxExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public OnnxExecutionMode() {
            this.value = null;
        }

        public OnnxExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

