/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding.huggingface;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class HuggingFaceEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "99c0116dea995843f194c9ec092a90e6";
    public static final String CONFIG_DEF_NAME = "hugging-face-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding.huggingface";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding.huggingface", "tokenizerPath model", "transformerModel model", "transformerMaxTokens int default=512", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerTokenTypeIds string default=token_type_ids", "transformerOutput string default=last_hidden_state", "prependQuery string default=\"\"", "prependDocument string default=\"\"", "normalize bool default=false", "poolingStrategy enum { cls, mean } default=mean", "transformerExecutionMode enum { parallel, sequential } default=sequential", "transformerInterOpThreads int default=1", "transformerIntraOpThreads int default=-4", "transformerGpuDevice int default=0"};
    private final ModelNode tokenizerPath;
    private final ModelNode transformerModel;
    private final IntegerNode transformerMaxTokens;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final StringNode transformerTokenTypeIds;
    private final StringNode transformerOutput;
    private final StringNode prependQuery;
    private final StringNode prependDocument;
    private final BooleanNode normalize;
    private final PoolingStrategy poolingStrategy;
    private final TransformerExecutionMode transformerExecutionMode;
    private final IntegerNode transformerInterOpThreads;
    private final IntegerNode transformerIntraOpThreads;
    private final IntegerNode transformerGpuDevice;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HuggingFaceEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private HuggingFaceEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for hugging-face-embedder must be initialized: " + builder.__uninitialized);
        }
        this.tokenizerPath = builder.tokenizerPath == null ? new ModelNode() : new ModelNode(builder.tokenizerPath);
        this.transformerModel = builder.transformerModel == null ? new ModelNode() : new ModelNode(builder.transformerModel);
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(512) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerTokenTypeIds = builder.transformerTokenTypeIds == null ? new StringNode("token_type_ids") : new StringNode(builder.transformerTokenTypeIds);
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("last_hidden_state") : new StringNode(builder.transformerOutput);
        this.prependQuery = builder.prependQuery == null ? new StringNode("") : new StringNode(builder.prependQuery);
        this.prependDocument = builder.prependDocument == null ? new StringNode("") : new StringNode(builder.prependDocument);
        this.normalize = builder.normalize == null ? new BooleanNode(false) : new BooleanNode(builder.normalize.booleanValue());
        this.poolingStrategy = builder.poolingStrategy == null ? new PoolingStrategy(PoolingStrategy.mean) : new PoolingStrategy(builder.poolingStrategy);
        this.transformerExecutionMode = builder.transformerExecutionMode == null ? new TransformerExecutionMode(TransformerExecutionMode.sequential) : new TransformerExecutionMode(builder.transformerExecutionMode);
        this.transformerInterOpThreads = builder.transformerInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.transformerInterOpThreads.intValue());
        this.transformerIntraOpThreads = builder.transformerIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.transformerIntraOpThreads.intValue());
        this.transformerGpuDevice = builder.transformerGpuDevice == null ? new IntegerNode(0) : new IntegerNode(builder.transformerGpuDevice.intValue());
    }

    public Path tokenizerPath() {
        return (Path)this.tokenizerPath.value();
    }

    public Path transformerModel() {
        return (Path)this.transformerModel.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public String transformerTokenTypeIds() {
        return this.transformerTokenTypeIds.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    public String prependQuery() {
        return this.prependQuery.value();
    }

    public String prependDocument() {
        return this.prependDocument.value();
    }

    public boolean normalize() {
        return this.normalize.value();
    }

    public PoolingStrategy.Enum poolingStrategy() {
        return (PoolingStrategy.Enum)((Object)this.poolingStrategy.value());
    }

    public TransformerExecutionMode.Enum transformerExecutionMode() {
        return (TransformerExecutionMode.Enum)((Object)this.transformerExecutionMode.value());
    }

    public int transformerInterOpThreads() {
        return this.transformerInterOpThreads.value();
    }

    public int transformerIntraOpThreads() {
        return this.transformerIntraOpThreads.value();
    }

    public int transformerGpuDevice() {
        return this.transformerGpuDevice.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HuggingFaceEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("tokenizerPath", "transformerModel"));
        private ModelReference tokenizerPath = null;
        private ModelReference transformerModel = null;
        private Integer transformerMaxTokens = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private String transformerTokenTypeIds = null;
        private String transformerOutput = null;
        private String prependQuery = null;
        private String prependDocument = null;
        private Boolean normalize = null;
        private PoolingStrategy.Enum poolingStrategy = null;
        private TransformerExecutionMode.Enum transformerExecutionMode = null;
        private Integer transformerInterOpThreads = null;
        private Integer transformerIntraOpThreads = null;
        private Integer transformerGpuDevice = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HuggingFaceEmbedderConfig config) {
            this.tokenizerPath(config.tokenizerPath.getModelReference());
            this.transformerModel(config.transformerModel.getModelReference());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerTokenTypeIds(config.transformerTokenTypeIds());
            this.transformerOutput(config.transformerOutput());
            this.prependQuery(config.prependQuery());
            this.prependDocument(config.prependDocument());
            this.normalize(config.normalize());
            this.poolingStrategy(config.poolingStrategy());
            this.transformerExecutionMode(config.transformerExecutionMode());
            this.transformerInterOpThreads(config.transformerInterOpThreads());
            this.transformerIntraOpThreads(config.transformerIntraOpThreads());
            this.transformerGpuDevice(config.transformerGpuDevice());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerPath != null) {
                this.tokenizerPath(__superior.tokenizerPath);
            }
            if (__superior.transformerModel != null) {
                this.transformerModel(__superior.transformerModel);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerTokenTypeIds != null) {
                this.transformerTokenTypeIds(__superior.transformerTokenTypeIds);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            if (__superior.prependQuery != null) {
                this.prependQuery(__superior.prependQuery);
            }
            if (__superior.prependDocument != null) {
                this.prependDocument(__superior.prependDocument);
            }
            if (__superior.normalize != null) {
                this.normalize(__superior.normalize);
            }
            if (__superior.poolingStrategy != null) {
                this.poolingStrategy(__superior.poolingStrategy);
            }
            if (__superior.transformerExecutionMode != null) {
                this.transformerExecutionMode(__superior.transformerExecutionMode);
            }
            if (__superior.transformerInterOpThreads != null) {
                this.transformerInterOpThreads(__superior.transformerInterOpThreads);
            }
            if (__superior.transformerIntraOpThreads != null) {
                this.transformerIntraOpThreads(__superior.transformerIntraOpThreads);
            }
            if (__superior.transformerGpuDevice != null) {
                this.transformerGpuDevice(__superior.transformerGpuDevice);
            }
            return this;
        }

        public Builder tokenizerPath(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerPath = __value;
            this.__uninitialized.remove("tokenizerPath");
            return this;
        }

        public Builder transformerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModel = __value;
            this.__uninitialized.remove("transformerModel");
            return this;
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerTokenTypeIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerTokenTypeIds = __value;
            return this;
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public Builder prependQuery(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.prependQuery = __value;
            return this;
        }

        public Builder prependDocument(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.prependDocument = __value;
            return this;
        }

        public Builder normalize(boolean __value) {
            this.normalize = __value;
            return this;
        }

        private Builder normalize(String __value) {
            return this.normalize(Boolean.valueOf(__value));
        }

        public Builder poolingStrategy(PoolingStrategy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.poolingStrategy = __value;
            return this;
        }

        private Builder poolingStrategy(String __value) {
            return this.poolingStrategy(PoolingStrategy.Enum.valueOf(__value));
        }

        public Builder transformerExecutionMode(TransformerExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerExecutionMode = __value;
            return this;
        }

        private Builder transformerExecutionMode(String __value) {
            return this.transformerExecutionMode(TransformerExecutionMode.Enum.valueOf(__value));
        }

        public Builder transformerInterOpThreads(int __value) {
            this.transformerInterOpThreads = __value;
            return this;
        }

        private Builder transformerInterOpThreads(String __value) {
            return this.transformerInterOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerIntraOpThreads(int __value) {
            this.transformerIntraOpThreads = __value;
            return this;
        }

        private Builder transformerIntraOpThreads(String __value) {
            return this.transformerIntraOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerGpuDevice(int __value) {
            this.transformerGpuDevice = __value;
            return this;
        }

        private Builder transformerGpuDevice(String __value) {
            return this.transformerGpuDevice(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HuggingFaceEmbedderConfig build() {
            return new HuggingFaceEmbedderConfig(this);
        }
    }

    public static final class PoolingStrategy
    extends EnumNode<Enum> {
        public static final Enum cls = Enum.cls;
        public static final Enum mean = Enum.mean;

        public PoolingStrategy() {
            this.value = null;
        }

        public PoolingStrategy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            cls,
            mean;

        }
    }

    public static final class TransformerExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public TransformerExecutionMode() {
            this.value = null;
        }

        public TransformerExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

