/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class RankingExpressionsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "ff17c6b7529b1bccd49409790771212b";
    public static final String CONFIG_DEF_NAME = "ranking-expressions";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "expression[].name string", "expression[].fileref file"};
    private final InnerNodeVector<Expression> expression;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public RankingExpressionsConfig(Builder builder) {
        this(builder, true);
    }

    private RankingExpressionsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for ranking-expressions must be initialized: " + builder.__uninitialized);
        }
        this.expression = Expression.createVector(builder.expression);
    }

    public List<Expression> expression() {
        return this.expression;
    }

    public Expression expression(int i) {
        return (Expression)((Object)this.expression.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RankingExpressionsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Expression.Builder> expression = new ArrayList<Expression.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RankingExpressionsConfig config) {
            for (Expression e : config.expression()) {
                this.expression(new Expression.Builder(e));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.expression.isEmpty()) {
                this.expression.addAll(__superior.expression);
            }
            return this;
        }

        public Builder expression(Expression.Builder __builder) {
            this.expression.add(__builder);
            return this;
        }

        public Builder expression(Consumer<Expression.Builder> __func) {
            Expression.Builder __inner = new Expression.Builder();
            __func.accept(__inner);
            this.expression.add(__inner);
            return this;
        }

        public Builder expression(List<Expression.Builder> __builders) {
            this.expression = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RankingExpressionsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RankingExpressionsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RankingExpressionsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RankingExpressionsConfig build() {
            return new RankingExpressionsConfig(this);
        }
    }

    public static final class Expression
    extends InnerNode {
        private final StringNode name;
        private final FileNode fileref;

        public Expression(Builder builder) {
            this(builder, true);
        }

        private Expression(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for ranking-expressions.expression[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.fileref = builder.fileref == null ? new FileNode() : new FileNode(builder.fileref);
        }

        public String name() {
            return this.name.value();
        }

        public FileReference fileref() {
            return this.fileref.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Expression newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("expression");
            return changes;
        }

        private static InnerNodeVector<Expression> createVector(List<Builder> builders) {
            ArrayList<Expression> elems = new ArrayList<Expression>();
            for (Builder b : builders) {
                elems.add(new Expression(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name", "fileref"));
            private String name = null;
            private String fileref = null;

            public Builder() {
            }

            public Builder(Expression config) {
                this.name(config.name());
                this.fileref(config.fileref().value());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.fileref != null) {
                    this.fileref(__superior.fileref);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder fileref(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileref = __value;
                this.__uninitialized.remove("fileref");
                return this;
            }

            public Expression build() {
                return new Expression(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

