/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class PersistenceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "e2ec2c9ef2aa6c99583a99ab1bcb5065";
    public static final String CONFIG_DEF_NAME = "persistence";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "abort_operations_with_changed_bucket_ownership bool default=true", "abort_outdated_mutating_ideal_state_ops bool default=true", "abort_outdated_mutating_external_load_ops bool default=true", "fail_partition_on_error bool default=true", "revert_time_period int default=300", "keep_remove_time_period int default=604800", "maximum_versions_of_single_document_stored int default=5"};
    private final BooleanNode abort_operations_with_changed_bucket_ownership;
    private final BooleanNode abort_outdated_mutating_ideal_state_ops;
    private final BooleanNode abort_outdated_mutating_external_load_ops;
    private final BooleanNode fail_partition_on_error;
    private final IntegerNode revert_time_period;
    private final IntegerNode keep_remove_time_period;
    private final IntegerNode maximum_versions_of_single_document_stored;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public PersistenceConfig(Builder builder) {
        this(builder, true);
    }

    private PersistenceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for persistence must be initialized: " + builder.__uninitialized);
        }
        this.abort_operations_with_changed_bucket_ownership = builder.abort_operations_with_changed_bucket_ownership == null ? new BooleanNode(true) : new BooleanNode(builder.abort_operations_with_changed_bucket_ownership.booleanValue());
        this.abort_outdated_mutating_ideal_state_ops = builder.abort_outdated_mutating_ideal_state_ops == null ? new BooleanNode(true) : new BooleanNode(builder.abort_outdated_mutating_ideal_state_ops.booleanValue());
        this.abort_outdated_mutating_external_load_ops = builder.abort_outdated_mutating_external_load_ops == null ? new BooleanNode(true) : new BooleanNode(builder.abort_outdated_mutating_external_load_ops.booleanValue());
        this.fail_partition_on_error = builder.fail_partition_on_error == null ? new BooleanNode(true) : new BooleanNode(builder.fail_partition_on_error.booleanValue());
        this.revert_time_period = builder.revert_time_period == null ? new IntegerNode(300) : new IntegerNode(builder.revert_time_period.intValue());
        this.keep_remove_time_period = builder.keep_remove_time_period == null ? new IntegerNode(604800) : new IntegerNode(builder.keep_remove_time_period.intValue());
        this.maximum_versions_of_single_document_stored = builder.maximum_versions_of_single_document_stored == null ? new IntegerNode(5) : new IntegerNode(builder.maximum_versions_of_single_document_stored.intValue());
    }

    public boolean abort_operations_with_changed_bucket_ownership() {
        return this.abort_operations_with_changed_bucket_ownership.value();
    }

    public boolean abort_outdated_mutating_ideal_state_ops() {
        return this.abort_outdated_mutating_ideal_state_ops.value();
    }

    public boolean abort_outdated_mutating_external_load_ops() {
        return this.abort_outdated_mutating_external_load_ops.value();
    }

    public boolean fail_partition_on_error() {
        return this.fail_partition_on_error.value();
    }

    public int revert_time_period() {
        return this.revert_time_period.value();
    }

    public int keep_remove_time_period() {
        return this.keep_remove_time_period.value();
    }

    public int maximum_versions_of_single_document_stored() {
        return this.maximum_versions_of_single_document_stored.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(PersistenceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean abort_operations_with_changed_bucket_ownership = null;
        private Boolean abort_outdated_mutating_ideal_state_ops = null;
        private Boolean abort_outdated_mutating_external_load_ops = null;
        private Boolean fail_partition_on_error = null;
        private Integer revert_time_period = null;
        private Integer keep_remove_time_period = null;
        private Integer maximum_versions_of_single_document_stored = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(PersistenceConfig config) {
            this.abort_operations_with_changed_bucket_ownership(config.abort_operations_with_changed_bucket_ownership());
            this.abort_outdated_mutating_ideal_state_ops(config.abort_outdated_mutating_ideal_state_ops());
            this.abort_outdated_mutating_external_load_ops(config.abort_outdated_mutating_external_load_ops());
            this.fail_partition_on_error(config.fail_partition_on_error());
            this.revert_time_period(config.revert_time_period());
            this.keep_remove_time_period(config.keep_remove_time_period());
            this.maximum_versions_of_single_document_stored(config.maximum_versions_of_single_document_stored());
        }

        private Builder override(Builder __superior) {
            if (__superior.abort_operations_with_changed_bucket_ownership != null) {
                this.abort_operations_with_changed_bucket_ownership(__superior.abort_operations_with_changed_bucket_ownership);
            }
            if (__superior.abort_outdated_mutating_ideal_state_ops != null) {
                this.abort_outdated_mutating_ideal_state_ops(__superior.abort_outdated_mutating_ideal_state_ops);
            }
            if (__superior.abort_outdated_mutating_external_load_ops != null) {
                this.abort_outdated_mutating_external_load_ops(__superior.abort_outdated_mutating_external_load_ops);
            }
            if (__superior.fail_partition_on_error != null) {
                this.fail_partition_on_error(__superior.fail_partition_on_error);
            }
            if (__superior.revert_time_period != null) {
                this.revert_time_period(__superior.revert_time_period);
            }
            if (__superior.keep_remove_time_period != null) {
                this.keep_remove_time_period(__superior.keep_remove_time_period);
            }
            if (__superior.maximum_versions_of_single_document_stored != null) {
                this.maximum_versions_of_single_document_stored(__superior.maximum_versions_of_single_document_stored);
            }
            return this;
        }

        public Builder abort_operations_with_changed_bucket_ownership(boolean __value) {
            this.abort_operations_with_changed_bucket_ownership = __value;
            return this;
        }

        private Builder abort_operations_with_changed_bucket_ownership(String __value) {
            return this.abort_operations_with_changed_bucket_ownership(Boolean.valueOf(__value));
        }

        public Builder abort_outdated_mutating_ideal_state_ops(boolean __value) {
            this.abort_outdated_mutating_ideal_state_ops = __value;
            return this;
        }

        private Builder abort_outdated_mutating_ideal_state_ops(String __value) {
            return this.abort_outdated_mutating_ideal_state_ops(Boolean.valueOf(__value));
        }

        public Builder abort_outdated_mutating_external_load_ops(boolean __value) {
            this.abort_outdated_mutating_external_load_ops = __value;
            return this;
        }

        private Builder abort_outdated_mutating_external_load_ops(String __value) {
            return this.abort_outdated_mutating_external_load_ops(Boolean.valueOf(__value));
        }

        public Builder fail_partition_on_error(boolean __value) {
            this.fail_partition_on_error = __value;
            return this;
        }

        private Builder fail_partition_on_error(String __value) {
            return this.fail_partition_on_error(Boolean.valueOf(__value));
        }

        public Builder revert_time_period(int __value) {
            this.revert_time_period = __value;
            return this;
        }

        private Builder revert_time_period(String __value) {
            return this.revert_time_period(Integer.valueOf(__value));
        }

        public Builder keep_remove_time_period(int __value) {
            this.keep_remove_time_period = __value;
            return this;
        }

        private Builder keep_remove_time_period(String __value) {
            return this.keep_remove_time_period(Integer.valueOf(__value));
        }

        public Builder maximum_versions_of_single_document_stored(int __value) {
            this.maximum_versions_of_single_document_stored = __value;
            return this;
        }

        private Builder maximum_versions_of_single_document_stored(String __value) {
            return this.maximum_versions_of_single_document_stored(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return PersistenceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return PersistenceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return PersistenceConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public PersistenceConfig build() {
            return new PersistenceConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

