/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.security.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class CloudTokenDataPlaneFilterConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "78394f8ff526a398631884b738ad8758";
    public static final String CONFIG_DEF_NAME = "cloud-token-data-plane-filter";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http.filter.security.cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http.filter.security.cloud.config", "tokenContext string default=\"\"", "clients[].id string", "clients[].permissions[] string", "clients[].tokens[].id string", "clients[].tokens[].fingerprints[] string", "clients[].tokens[].checkAccessHashes[] string", "clients[].tokens[].expirations[] string"};
    private final StringNode tokenContext;
    private final InnerNodeVector<Clients> clients;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public CloudTokenDataPlaneFilterConfig(Builder builder) {
        this(builder, true);
    }

    private CloudTokenDataPlaneFilterConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cloud-token-data-plane-filter must be initialized: " + builder.__uninitialized);
        }
        this.tokenContext = builder.tokenContext == null ? new StringNode("") : new StringNode(builder.tokenContext);
        this.clients = Clients.createVector(builder.clients);
    }

    public String tokenContext() {
        return this.tokenContext.value();
    }

    public List<Clients> clients() {
        return this.clients;
    }

    public Clients clients(int i) {
        return (Clients)((Object)this.clients.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(CloudTokenDataPlaneFilterConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String tokenContext = null;
        public List<Clients.Builder> clients = new ArrayList<Clients.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(CloudTokenDataPlaneFilterConfig config) {
            this.tokenContext(config.tokenContext());
            for (Clients c : config.clients()) {
                this.clients(new Clients.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenContext != null) {
                this.tokenContext(__superior.tokenContext);
            }
            if (!__superior.clients.isEmpty()) {
                this.clients.addAll(__superior.clients);
            }
            return this;
        }

        public Builder tokenContext(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenContext = __value;
            return this;
        }

        public Builder clients(Clients.Builder __builder) {
            this.clients.add(__builder);
            return this;
        }

        public Builder clients(Consumer<Clients.Builder> __func) {
            Clients.Builder __inner = new Clients.Builder();
            __func.accept(__inner);
            this.clients.add(__inner);
            return this;
        }

        public Builder clients(List<Clients.Builder> __builders) {
            this.clients = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return CloudTokenDataPlaneFilterConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return CloudTokenDataPlaneFilterConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return CloudTokenDataPlaneFilterConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public CloudTokenDataPlaneFilterConfig build() {
            return new CloudTokenDataPlaneFilterConfig(this);
        }
    }

    public static final class Clients
    extends InnerNode {
        private final StringNode id;
        private final LeafNodeVector<String, StringNode> permissions;
        private final InnerNodeVector<Tokens> tokens;

        public Clients(Builder builder) {
            this(builder, true);
        }

        private Clients(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for cloud-token-data-plane-filter.clients[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.permissions = new LeafNodeVector(builder.permissions, (LeafNode)new StringNode());
            this.tokens = Tokens.createVector(builder.tokens);
        }

        public String id() {
            return this.id.value();
        }

        public List<String> permissions() {
            return this.permissions.asList();
        }

        public String permissions(int i) {
            return ((StringNode)this.permissions.get(i)).value();
        }

        public List<Tokens> tokens() {
            return this.tokens;
        }

        public Tokens tokens(int i) {
            return (Tokens)((Object)this.tokens.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Clients newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("clients");
            return changes;
        }

        private static InnerNodeVector<Clients> createVector(List<Builder> builders) {
            ArrayList<Clients> elems = new ArrayList<Clients>();
            for (Builder b : builders) {
                elems.add(new Clients(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id"));
            private String id = null;
            public List<String> permissions = new ArrayList<String>();
            public List<Tokens.Builder> tokens = new ArrayList<Tokens.Builder>();

            public Builder() {
            }

            public Builder(Clients config) {
                this.id(config.id());
                this.permissions(config.permissions());
                for (Tokens t : config.tokens()) {
                    this.tokens(new Tokens.Builder(t));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (!__superior.permissions.isEmpty()) {
                    this.permissions.addAll(__superior.permissions);
                }
                if (!__superior.tokens.isEmpty()) {
                    this.tokens.addAll(__superior.tokens);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder permissions(String __value) {
                this.permissions.add(__value);
                return this;
            }

            public Builder permissions(Collection<String> __values) {
                this.permissions.addAll(__values);
                return this;
            }

            public Builder tokens(Tokens.Builder __builder) {
                this.tokens.add(__builder);
                return this;
            }

            public Builder tokens(Consumer<Tokens.Builder> __func) {
                Tokens.Builder __inner = new Tokens.Builder();
                __func.accept(__inner);
                this.tokens.add(__inner);
                return this;
            }

            public Builder tokens(List<Tokens.Builder> __builders) {
                this.tokens = __builders;
                return this;
            }

            public Clients build() {
                return new Clients(this);
            }
        }

        public static final class Tokens
        extends InnerNode {
            private final StringNode id;
            private final LeafNodeVector<String, StringNode> fingerprints;
            private final LeafNodeVector<String, StringNode> checkAccessHashes;
            private final LeafNodeVector<String, StringNode> expirations;

            public Tokens(Builder builder) {
                this(builder, true);
            }

            private Tokens(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for cloud-token-data-plane-filter.clients[].tokens[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
                this.fingerprints = new LeafNodeVector(builder.fingerprints, (LeafNode)new StringNode());
                this.checkAccessHashes = new LeafNodeVector(builder.checkAccessHashes, (LeafNode)new StringNode());
                this.expirations = new LeafNodeVector(builder.expirations, (LeafNode)new StringNode());
            }

            public String id() {
                return this.id.value();
            }

            public List<String> fingerprints() {
                return this.fingerprints.asList();
            }

            public String fingerprints(int i) {
                return ((StringNode)this.fingerprints.get(i)).value();
            }

            public List<String> checkAccessHashes() {
                return this.checkAccessHashes.asList();
            }

            public String checkAccessHashes(int i) {
                return ((StringNode)this.checkAccessHashes.get(i)).value();
            }

            public List<String> expirations() {
                return this.expirations.asList();
            }

            public String expirations(int i) {
                return ((StringNode)this.expirations.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Tokens newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("tokens");
                return changes;
            }

            private static InnerNodeVector<Tokens> createVector(List<Builder> builders) {
                ArrayList<Tokens> elems = new ArrayList<Tokens>();
                for (Builder b : builders) {
                    elems.add(new Tokens(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("id"));
                private String id = null;
                public List<String> fingerprints = new ArrayList<String>();
                public List<String> checkAccessHashes = new ArrayList<String>();
                public List<String> expirations = new ArrayList<String>();

                public Builder() {
                }

                public Builder(Tokens config) {
                    this.id(config.id());
                    this.fingerprints(config.fingerprints());
                    this.checkAccessHashes(config.checkAccessHashes());
                    this.expirations(config.expirations());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    if (!__superior.fingerprints.isEmpty()) {
                        this.fingerprints.addAll(__superior.fingerprints);
                    }
                    if (!__superior.checkAccessHashes.isEmpty()) {
                        this.checkAccessHashes.addAll(__superior.checkAccessHashes);
                    }
                    if (!__superior.expirations.isEmpty()) {
                        this.expirations.addAll(__superior.expirations);
                    }
                    return this;
                }

                public Builder id(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                public Builder fingerprints(String __value) {
                    this.fingerprints.add(__value);
                    return this;
                }

                public Builder fingerprints(Collection<String> __values) {
                    this.fingerprints.addAll(__values);
                    return this;
                }

                public Builder checkAccessHashes(String __value) {
                    this.checkAccessHashes.add(__value);
                    return this;
                }

                public Builder checkAccessHashes(Collection<String> __values) {
                    this.checkAccessHashes.addAll(__values);
                    return this;
                }

                public Builder expirations(String __value) {
                    this.expirations.add(__value);
                    return this;
                }

                public Builder expirations(Collection<String> __values) {
                    this.expirations.addAll(__values);
                    return this;
                }

                public Tokens build() {
                    return new Tokens(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

