/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class DispatchNodesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "de348ed663f532c8bfb79fa82ab85566";
    public static final String CONFIG_DEF_NAME = "dispatch-nodes";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "node[].key int", "node[].group int default=0", "node[].host string", "node[].port int"};
    private final InnerNodeVector<Node> node;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DispatchNodesConfig(Builder builder) {
        this(builder, true);
    }

    private DispatchNodesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for dispatch-nodes must be initialized: " + builder.__uninitialized);
        }
        this.node = Node.createVector(builder.node);
    }

    public List<Node> node() {
        return this.node;
    }

    public Node node(int i) {
        return (Node)((Object)this.node.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DispatchNodesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Node.Builder> node = new ArrayList<Node.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DispatchNodesConfig config) {
            for (Node n : config.node()) {
                this.node(new Node.Builder(n));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.node.isEmpty()) {
                this.node.addAll(__superior.node);
            }
            return this;
        }

        public Builder node(Node.Builder __builder) {
            this.node.add(__builder);
            return this;
        }

        public Builder node(Consumer<Node.Builder> __func) {
            Node.Builder __inner = new Node.Builder();
            __func.accept(__inner);
            this.node.add(__inner);
            return this;
        }

        public Builder node(List<Node.Builder> __builders) {
            this.node = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DispatchNodesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DispatchNodesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DispatchNodesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DispatchNodesConfig build() {
            return new DispatchNodesConfig(this);
        }
    }

    public static final class Node
    extends InnerNode {
        private final IntegerNode key;
        private final IntegerNode group;
        private final StringNode host;
        private final IntegerNode port;

        public Node(Builder builder) {
            this(builder, true);
        }

        private Node(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for dispatch-nodes.node[] must be initialized: " + builder.__uninitialized);
            }
            this.key = builder.key == null ? new IntegerNode() : new IntegerNode(builder.key.intValue());
            this.group = builder.group == null ? new IntegerNode(0) : new IntegerNode(builder.group.intValue());
            this.host = builder.host == null ? new StringNode() : new StringNode(builder.host);
            this.port = builder.port == null ? new IntegerNode() : new IntegerNode(builder.port.intValue());
        }

        public int key() {
            return this.key.value();
        }

        public int group() {
            return this.group.value();
        }

        public String host() {
            return this.host.value();
        }

        public int port() {
            return this.port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
            return changes;
        }

        private static InnerNodeVector<Node> createVector(List<Builder> builders) {
            ArrayList<Node> elems = new ArrayList<Node>();
            for (Builder b : builders) {
                elems.add(new Node(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("key", "host", "port"));
            private Integer key = null;
            private Integer group = null;
            private String host = null;
            private Integer port = null;

            public Builder() {
            }

            public Builder(Node config) {
                this.key(config.key());
                this.group(config.group());
                this.host(config.host());
                this.port(config.port());
            }

            private Builder override(Builder __superior) {
                if (__superior.key != null) {
                    this.key(__superior.key);
                }
                if (__superior.group != null) {
                    this.group(__superior.group);
                }
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                return this;
            }

            public Builder key(int __value) {
                this.key = __value;
                this.__uninitialized.remove("key");
                return this;
            }

            private Builder key(String __value) {
                return this.key(Integer.valueOf(__value));
            }

            public Builder group(int __value) {
                this.group = __value;
                return this;
            }

            private Builder group(String __value) {
                return this.group(Integer.valueOf(__value));
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                this.__uninitialized.remove("host");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                this.__uninitialized.remove("port");
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Node build() {
                return new Node(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

