/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.significance.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SignificanceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "e1e79ccc650d25b40101e7f6c40574f2";
    public static final String CONFIG_DEF_NAME = "significance";
    public static final String CONFIG_DEF_NAMESPACE = "search.significance.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.significance.config", "model[].language string", "model[].path model"};
    private final InnerNodeVector<Model> model;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SignificanceConfig(Builder builder) {
        this(builder, true);
    }

    private SignificanceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for significance must be initialized: " + builder.__uninitialized);
        }
        this.model = Model.createVector(builder.model);
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SignificanceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SignificanceConfig config) {
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(Consumer<Model.Builder> __func) {
            Model.Builder __inner = new Model.Builder();
            __func.accept(__inner);
            this.model.add(__inner);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SignificanceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SignificanceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SignificanceConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SignificanceConfig build() {
            return new SignificanceConfig(this);
        }
    }

    public static final class Model
    extends InnerNode {
        private final StringNode language;
        private final ModelNode path;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for significance.model[] must be initialized: " + builder.__uninitialized);
            }
            this.language = builder.language == null ? new StringNode() : new StringNode(builder.language);
            this.path = builder.path == null ? new ModelNode() : new ModelNode(builder.path);
        }

        public String language() {
            return this.language.value();
        }

        public Path path() {
            return (Path)this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("language", "path"));
            private String language = null;
            private ModelReference path = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.language(config.language());
                this.path(config.path.getModelReference());
            }

            private Builder override(Builder __superior) {
                if (__superior.language != null) {
                    this.language(__superior.language);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder language(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.language = __value;
                this.__uninitialized.remove("language");
                return this;
            }

            public Builder path(ModelReference __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

