/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LongNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class HwinfoConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "5549a24b7fba7a1233af3b6f426c2d00";
    public static final String CONFIG_DEF_NAME = "hwinfo";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "disk.writespeed double default = 0.0", "disk.sampletime long default = 0"};
    private final Disk disk;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HwinfoConfig(Builder builder) {
        this(builder, true);
    }

    private HwinfoConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for hwinfo must be initialized: " + builder.__uninitialized);
        }
        this.disk = new Disk(builder.disk, throwIfUninitialized);
    }

    public Disk disk() {
        return this.disk;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HwinfoConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Disk.Builder disk = new Disk.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HwinfoConfig config) {
            this.disk(new Disk.Builder(config.disk()));
        }

        private Builder override(Builder __superior) {
            this.disk(this.disk.override(__superior.disk));
            return this;
        }

        public Builder disk(Disk.Builder __builder) {
            this.disk = __builder;
            return this;
        }

        public Builder disk(Consumer<Disk.Builder> __func) {
            Disk.Builder __inner = new Disk.Builder();
            __func.accept(__inner);
            this.disk = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HwinfoConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HwinfoConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HwinfoConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HwinfoConfig build() {
            return new HwinfoConfig(this);
        }
    }

    public static final class Disk
    extends InnerNode {
        private final DoubleNode writespeed;
        private final LongNode sampletime;

        public Disk(Builder builder) {
            this(builder, true);
        }

        private Disk(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for hwinfo.disk must be initialized: " + builder.__uninitialized);
            }
            this.writespeed = builder.writespeed == null ? new DoubleNode(0.0) : new DoubleNode(builder.writespeed.doubleValue());
            this.sampletime = builder.sampletime == null ? new LongNode(0L) : new LongNode(builder.sampletime.longValue());
        }

        public double writespeed() {
            return this.writespeed.value();
        }

        public long sampletime() {
            return this.sampletime.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Disk newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("disk");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double writespeed = null;
            private Long sampletime = null;

            public Builder() {
            }

            public Builder(Disk config) {
                this.writespeed(config.writespeed());
                this.sampletime(config.sampletime());
            }

            private Builder override(Builder __superior) {
                if (__superior.writespeed != null) {
                    this.writespeed(__superior.writespeed);
                }
                if (__superior.sampletime != null) {
                    this.sampletime(__superior.sampletime);
                }
                return this;
            }

            public Builder writespeed(double __value) {
                this.writespeed = __value;
                return this;
            }

            private Builder writespeed(String __value) {
                return this.writespeed(Double.valueOf(__value));
            }

            public Builder sampletime(long __value) {
                this.sampletime = __value;
                return this;
            }

            private Builder sampletime(String __value) {
                return this.sampletime(Long.valueOf(__value));
            }

            public Disk build() {
                return new Disk(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

