/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class DataplaneProxyConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "56a3c55c1eb3689f1d33d214e668f3ef";
    public static final String CONFIG_DEF_NAME = "dataplane-proxy";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "port int", "serverCertificate string", "serverKey string"};
    private final IntegerNode port;
    private final StringNode serverCertificate;
    private final StringNode serverKey;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DataplaneProxyConfig(Builder builder) {
        this(builder, true);
    }

    private DataplaneProxyConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for dataplane-proxy must be initialized: " + builder.__uninitialized);
        }
        this.port = builder.port == null ? new IntegerNode() : new IntegerNode(builder.port.intValue());
        this.serverCertificate = builder.serverCertificate == null ? new StringNode() : new StringNode(builder.serverCertificate);
        this.serverKey = builder.serverKey == null ? new StringNode() : new StringNode(builder.serverKey);
    }

    public int port() {
        return this.port.value();
    }

    public String serverCertificate() {
        return this.serverCertificate.value();
    }

    public String serverKey() {
        return this.serverKey.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DataplaneProxyConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("port", "serverCertificate", "serverKey"));
        private Integer port = null;
        private String serverCertificate = null;
        private String serverKey = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DataplaneProxyConfig config) {
            this.port(config.port());
            this.serverCertificate(config.serverCertificate());
            this.serverKey(config.serverKey());
        }

        private Builder override(Builder __superior) {
            if (__superior.port != null) {
                this.port(__superior.port);
            }
            if (__superior.serverCertificate != null) {
                this.serverCertificate(__superior.serverCertificate);
            }
            if (__superior.serverKey != null) {
                this.serverKey(__superior.serverKey);
            }
            return this;
        }

        public Builder port(int __value) {
            this.port = __value;
            this.__uninitialized.remove("port");
            return this;
        }

        private Builder port(String __value) {
            return this.port(Integer.valueOf(__value));
        }

        public Builder serverCertificate(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.serverCertificate = __value;
            this.__uninitialized.remove("serverCertificate");
            return this;
        }

        public Builder serverKey(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.serverKey = __value;
            this.__uninitialized.remove("serverKey");
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DataplaneProxyConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DataplaneProxyConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DataplaneProxyConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DataplaneProxyConfig build() {
            return new DataplaneProxyConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

