/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.reindexing;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LongNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class ReindexingConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "163d32a177d2bad9278217cbb6c0d042";
    public static final String CONFIG_DEF_NAME = "reindexing";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.reindexing";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.reindexing", "enabled bool default=false", "clusters{}.documentTypes{}.readyAtMillis long", "clusters{}.documentTypes{}.speed double default=0.2"};
    private final BooleanNode enabled;
    private final Map<String, Clusters> clusters;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ReindexingConfig(Builder builder) {
        this(builder, true);
    }

    private ReindexingConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for reindexing must be initialized: " + builder.__uninitialized);
        }
        this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
        this.clusters = Clusters.createMap(builder.clusters);
    }

    public boolean enabled() {
        return this.enabled.value();
    }

    public Map<String, Clusters> clusters() {
        return Collections.unmodifiableMap(this.clusters);
    }

    public Clusters clusters(String key) {
        return this.clusters.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ReindexingConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean enabled = null;
        public Map<String, Clusters.Builder> clusters = new LinkedHashMap<String, Clusters.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ReindexingConfig config) {
            this.enabled(config.enabled());
            for (Map.Entry<String, Clusters> __entry : config.clusters().entrySet()) {
                this.clusters(__entry.getKey(), new Clusters.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.enabled != null) {
                this.enabled(__superior.enabled);
            }
            this.clusters(__superior.clusters);
            return this;
        }

        public Builder enabled(boolean __value) {
            this.enabled = __value;
            return this;
        }

        private Builder enabled(String __value) {
            return this.enabled(Boolean.valueOf(__value));
        }

        public Builder clusters(String __key, Clusters.Builder __value) {
            this.clusters.put(__key, __value);
            return this;
        }

        public Builder clusters(Map<String, Clusters.Builder> __values) {
            this.clusters.putAll(__values);
            return this;
        }

        public Builder clusters(String __key, Consumer<Clusters.Builder> __func) {
            Clusters.Builder __inner = new Clusters.Builder();
            __func.accept(__inner);
            this.clusters.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ReindexingConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ReindexingConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ReindexingConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ReindexingConfig build() {
            return new ReindexingConfig(this);
        }
    }

    public static final class Clusters
    extends InnerNode {
        private final Map<String, DocumentTypes> documentTypes;

        public Clusters(Builder builder) {
            this(builder, true);
        }

        private Clusters(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for reindexing.clusters{} must be initialized: " + builder.__uninitialized);
            }
            this.documentTypes = DocumentTypes.createMap(builder.documentTypes);
        }

        public Map<String, DocumentTypes> documentTypes() {
            return Collections.unmodifiableMap(this.documentTypes);
        }

        public DocumentTypes documentTypes(String key) {
            return this.documentTypes.get(key);
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Clusters newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("clusters");
            return changes;
        }

        private static Map<String, Clusters> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Clusters> ret = new LinkedHashMap<String, Clusters>();
            for (String key : builders.keySet()) {
                ret.put(key, new Clusters(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Map<String, DocumentTypes.Builder> documentTypes = new LinkedHashMap<String, DocumentTypes.Builder>();

            public Builder() {
            }

            public Builder(Clusters config) {
                for (Map.Entry<String, DocumentTypes> __entry : config.documentTypes().entrySet()) {
                    this.documentTypes(__entry.getKey(), new DocumentTypes.Builder(__entry.getValue()));
                }
            }

            private Builder override(Builder __superior) {
                this.documentTypes(__superior.documentTypes);
                return this;
            }

            public Builder documentTypes(String __key, DocumentTypes.Builder __value) {
                this.documentTypes.put(__key, __value);
                return this;
            }

            public Builder documentTypes(Map<String, DocumentTypes.Builder> __values) {
                this.documentTypes.putAll(__values);
                return this;
            }

            public Builder documentTypes(String __key, Consumer<DocumentTypes.Builder> __func) {
                DocumentTypes.Builder __inner = new DocumentTypes.Builder();
                __func.accept(__inner);
                this.documentTypes.put(__key, __inner);
                return this;
            }

            public Clusters build() {
                return new Clusters(this);
            }
        }

        public static final class DocumentTypes
        extends InnerNode {
            private final LongNode readyAtMillis;
            private final DoubleNode speed;

            public DocumentTypes(Builder builder) {
                this(builder, true);
            }

            private DocumentTypes(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for reindexing.clusters{}.documentTypes{} must be initialized: " + builder.__uninitialized);
                }
                this.readyAtMillis = builder.readyAtMillis == null ? new LongNode() : new LongNode(builder.readyAtMillis.longValue());
                this.speed = builder.speed == null ? new DoubleNode(0.2) : new DoubleNode(builder.speed.doubleValue());
            }

            public long readyAtMillis() {
                return this.readyAtMillis.value();
            }

            public double speed() {
                return this.speed.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(DocumentTypes newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("documentTypes");
                return changes;
            }

            private static Map<String, DocumentTypes> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, DocumentTypes> ret = new LinkedHashMap<String, DocumentTypes>();
                for (String key : builders.keySet()) {
                    ret.put(key, new DocumentTypes(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("readyAtMillis"));
                private Long readyAtMillis = null;
                private Double speed = null;

                public Builder() {
                }

                public Builder(DocumentTypes config) {
                    this.readyAtMillis(config.readyAtMillis());
                    this.speed(config.speed());
                }

                private Builder override(Builder __superior) {
                    if (__superior.readyAtMillis != null) {
                        this.readyAtMillis(__superior.readyAtMillis);
                    }
                    if (__superior.speed != null) {
                        this.speed(__superior.speed);
                    }
                    return this;
                }

                public Builder readyAtMillis(long __value) {
                    this.readyAtMillis = __value;
                    this.__uninitialized.remove("readyAtMillis");
                    return this;
                }

                private Builder readyAtMillis(String __value) {
                    return this.readyAtMillis(Long.valueOf(__value));
                }

                public Builder speed(double __value) {
                    this.speed = __value;
                    return this;
                }

                private Builder speed(String __value) {
                    return this.speed(Double.valueOf(__value));
                }

                public DocumentTypes build() {
                    return new DocumentTypes(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

