/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.jdisc.http.filter;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class RuleBasedFilterConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3f19c877297fd6cd3c0000ae0f3a7180";
    public static final String CONFIG_DEF_NAME = "rule-based-filter";
    public static final String CONFIG_DEF_NAMESPACE = "com.yahoo.vespa.config.jdisc.http.filter";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=com.yahoo.vespa.config.jdisc.http.filter", "dryrun bool default=false", "defaultRule.action enum { ALLOW, BLOCK }", "defaultRule.blockResponseCode int default=403", "defaultRule.blockResponseMessage string default=\"\"", "defaultRule.blockResponseHeaders[].name string", "defaultRule.blockResponseHeaders[].value string", "rule[].name string", "rule[].action enum { ALLOW, BLOCK }", "rule[].hostNames[] string", "rule[].methods[] enum { GET, POST, PUT, PATCH, DELETE }", "rule[].pathExpressions[] string", "rule[].blockResponseCode int default=403", "rule[].blockResponseMessage string default=\"\"", "rule[].blockResponseHeaders[].name string", "rule[].blockResponseHeaders[].value string"};
    private final BooleanNode dryrun;
    private final DefaultRule defaultRule;
    private final InnerNodeVector<Rule> rule;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public RuleBasedFilterConfig(Builder builder) {
        this(builder, true);
    }

    private RuleBasedFilterConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for rule-based-filter must be initialized: " + builder.__uninitialized);
        }
        this.dryrun = builder.dryrun == null ? new BooleanNode(false) : new BooleanNode(builder.dryrun.booleanValue());
        this.defaultRule = new DefaultRule(builder.defaultRule, throwIfUninitialized);
        this.rule = Rule.createVector(builder.rule);
    }

    public boolean dryrun() {
        return this.dryrun.value();
    }

    public DefaultRule defaultRule() {
        return this.defaultRule;
    }

    public List<Rule> rule() {
        return this.rule;
    }

    public Rule rule(int i) {
        return (Rule)((Object)this.rule.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RuleBasedFilterConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean dryrun = null;
        public DefaultRule.Builder defaultRule = new DefaultRule.Builder();
        public List<Rule.Builder> rule = new ArrayList<Rule.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RuleBasedFilterConfig config) {
            this.dryrun(config.dryrun());
            this.defaultRule(new DefaultRule.Builder(config.defaultRule()));
            for (Rule r : config.rule()) {
                this.rule(new Rule.Builder(r));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.dryrun != null) {
                this.dryrun(__superior.dryrun);
            }
            this.defaultRule(this.defaultRule.override(__superior.defaultRule));
            if (!__superior.rule.isEmpty()) {
                this.rule.addAll(__superior.rule);
            }
            return this;
        }

        public Builder dryrun(boolean __value) {
            this.dryrun = __value;
            return this;
        }

        private Builder dryrun(String __value) {
            return this.dryrun(Boolean.valueOf(__value));
        }

        public Builder defaultRule(DefaultRule.Builder __builder) {
            this.defaultRule = __builder;
            return this;
        }

        public Builder defaultRule(Consumer<DefaultRule.Builder> __func) {
            DefaultRule.Builder __inner = new DefaultRule.Builder();
            __func.accept(__inner);
            this.defaultRule = __inner;
            return this;
        }

        public Builder rule(Rule.Builder __builder) {
            this.rule.add(__builder);
            return this;
        }

        public Builder rule(Consumer<Rule.Builder> __func) {
            Rule.Builder __inner = new Rule.Builder();
            __func.accept(__inner);
            this.rule.add(__inner);
            return this;
        }

        public Builder rule(List<Rule.Builder> __builders) {
            this.rule = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RuleBasedFilterConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RuleBasedFilterConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RuleBasedFilterConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RuleBasedFilterConfig build() {
            return new RuleBasedFilterConfig(this);
        }
    }

    public static final class DefaultRule
    extends InnerNode {
        private final Action action;
        private final IntegerNode blockResponseCode;
        private final StringNode blockResponseMessage;
        private final InnerNodeVector<BlockResponseHeaders> blockResponseHeaders;

        public DefaultRule(Builder builder) {
            this(builder, true);
        }

        private DefaultRule(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for rule-based-filter.defaultRule must be initialized: " + builder.__uninitialized);
            }
            this.action = builder.action == null ? new Action() : new Action(builder.action);
            this.blockResponseCode = builder.blockResponseCode == null ? new IntegerNode(403) : new IntegerNode(builder.blockResponseCode.intValue());
            this.blockResponseMessage = builder.blockResponseMessage == null ? new StringNode("") : new StringNode(builder.blockResponseMessage);
            this.blockResponseHeaders = BlockResponseHeaders.createVector(builder.blockResponseHeaders);
        }

        public Action.Enum action() {
            return (Action.Enum)((Object)this.action.value());
        }

        public int blockResponseCode() {
            return this.blockResponseCode.value();
        }

        public String blockResponseMessage() {
            return this.blockResponseMessage.value();
        }

        public List<BlockResponseHeaders> blockResponseHeaders() {
            return this.blockResponseHeaders;
        }

        public BlockResponseHeaders blockResponseHeaders(int i) {
            return (BlockResponseHeaders)((Object)this.blockResponseHeaders.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(DefaultRule newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("defaultRule");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("action"));
            private Action.Enum action = null;
            private Integer blockResponseCode = null;
            private String blockResponseMessage = null;
            public List<BlockResponseHeaders.Builder> blockResponseHeaders = new ArrayList<BlockResponseHeaders.Builder>();

            public Builder() {
            }

            public Builder(DefaultRule config) {
                this.action(config.action());
                this.blockResponseCode(config.blockResponseCode());
                this.blockResponseMessage(config.blockResponseMessage());
                for (BlockResponseHeaders b : config.blockResponseHeaders()) {
                    this.blockResponseHeaders(new BlockResponseHeaders.Builder(b));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.action != null) {
                    this.action(__superior.action);
                }
                if (__superior.blockResponseCode != null) {
                    this.blockResponseCode(__superior.blockResponseCode);
                }
                if (__superior.blockResponseMessage != null) {
                    this.blockResponseMessage(__superior.blockResponseMessage);
                }
                if (!__superior.blockResponseHeaders.isEmpty()) {
                    this.blockResponseHeaders.addAll(__superior.blockResponseHeaders);
                }
                return this;
            }

            public Builder action(Action.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.action = __value;
                this.__uninitialized.remove("action");
                return this;
            }

            private Builder action(String __value) {
                return this.action(Action.Enum.valueOf(__value));
            }

            public Builder blockResponseCode(int __value) {
                this.blockResponseCode = __value;
                return this;
            }

            private Builder blockResponseCode(String __value) {
                return this.blockResponseCode(Integer.valueOf(__value));
            }

            public Builder blockResponseMessage(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.blockResponseMessage = __value;
                return this;
            }

            public Builder blockResponseHeaders(BlockResponseHeaders.Builder __builder) {
                this.blockResponseHeaders.add(__builder);
                return this;
            }

            public Builder blockResponseHeaders(Consumer<BlockResponseHeaders.Builder> __func) {
                BlockResponseHeaders.Builder __inner = new BlockResponseHeaders.Builder();
                __func.accept(__inner);
                this.blockResponseHeaders.add(__inner);
                return this;
            }

            public Builder blockResponseHeaders(List<BlockResponseHeaders.Builder> __builders) {
                this.blockResponseHeaders = __builders;
                return this;
            }

            public DefaultRule build() {
                return new DefaultRule(this);
            }
        }

        public static final class Action
        extends EnumNode<Enum> {
            public static final Enum ALLOW = Enum.ALLOW;
            public static final Enum BLOCK = Enum.BLOCK;

            public Action() {
                this.value = null;
            }

            public Action(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                ALLOW,
                BLOCK;

            }
        }

        public static final class BlockResponseHeaders
        extends InnerNode {
            private final StringNode name;
            private final StringNode value;

            public BlockResponseHeaders(Builder builder) {
                this(builder, true);
            }

            private BlockResponseHeaders(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for rule-based-filter.defaultRule.blockResponseHeaders[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
            }

            public String name() {
                return this.name.value();
            }

            public String value() {
                return this.value.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(BlockResponseHeaders newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("blockResponseHeaders");
                return changes;
            }

            private static InnerNodeVector<BlockResponseHeaders> createVector(List<Builder> builders) {
                ArrayList<BlockResponseHeaders> elems = new ArrayList<BlockResponseHeaders>();
                for (Builder b : builders) {
                    elems.add(new BlockResponseHeaders(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "value"));
                private String name = null;
                private String value = null;

                public Builder() {
                }

                public Builder(BlockResponseHeaders config) {
                    this.name(config.name());
                    this.value(config.value());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.value != null) {
                        this.value(__superior.value);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder value(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.value = __value;
                    this.__uninitialized.remove("value");
                    return this;
                }

                public BlockResponseHeaders build() {
                    return new BlockResponseHeaders(this);
                }
            }
        }
    }

    public static final class Rule
    extends InnerNode {
        private final StringNode name;
        private final Action action;
        private final LeafNodeVector<String, StringNode> hostNames;
        private final LeafNodeVector<Methods.Enum, Methods> methods;
        private final LeafNodeVector<String, StringNode> pathExpressions;
        private final IntegerNode blockResponseCode;
        private final StringNode blockResponseMessage;
        private final InnerNodeVector<BlockResponseHeaders> blockResponseHeaders;

        public Rule(Builder builder) {
            this(builder, true);
        }

        private Rule(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for rule-based-filter.rule[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.action = builder.action == null ? new Action() : new Action(builder.action);
            this.hostNames = new LeafNodeVector(builder.hostNames, (LeafNode)new StringNode());
            this.methods = new LeafNodeVector(builder.methods, (LeafNode)new Methods());
            this.pathExpressions = new LeafNodeVector(builder.pathExpressions, (LeafNode)new StringNode());
            this.blockResponseCode = builder.blockResponseCode == null ? new IntegerNode(403) : new IntegerNode(builder.blockResponseCode.intValue());
            this.blockResponseMessage = builder.blockResponseMessage == null ? new StringNode("") : new StringNode(builder.blockResponseMessage);
            this.blockResponseHeaders = BlockResponseHeaders.createVector(builder.blockResponseHeaders);
        }

        public String name() {
            return this.name.value();
        }

        public Action.Enum action() {
            return (Action.Enum)((Object)this.action.value());
        }

        public List<String> hostNames() {
            return this.hostNames.asList();
        }

        public String hostNames(int i) {
            return ((StringNode)this.hostNames.get(i)).value();
        }

        public List<Methods.Enum> methods() {
            return this.methods.asList();
        }

        public Methods.Enum methods(int i) {
            return (Methods.Enum)((Object)((Methods)((Object)this.methods.get(i))).value());
        }

        public List<String> pathExpressions() {
            return this.pathExpressions.asList();
        }

        public String pathExpressions(int i) {
            return ((StringNode)this.pathExpressions.get(i)).value();
        }

        public int blockResponseCode() {
            return this.blockResponseCode.value();
        }

        public String blockResponseMessage() {
            return this.blockResponseMessage.value();
        }

        public List<BlockResponseHeaders> blockResponseHeaders() {
            return this.blockResponseHeaders;
        }

        public BlockResponseHeaders blockResponseHeaders(int i) {
            return (BlockResponseHeaders)((Object)this.blockResponseHeaders.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rule newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rule");
            return changes;
        }

        private static InnerNodeVector<Rule> createVector(List<Builder> builders) {
            ArrayList<Rule> elems = new ArrayList<Rule>();
            for (Builder b : builders) {
                elems.add(new Rule(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "action"));
            private String name = null;
            private Action.Enum action = null;
            public List<String> hostNames = new ArrayList<String>();
            public List<Methods.Enum> methods = new ArrayList<Methods.Enum>();
            public List<String> pathExpressions = new ArrayList<String>();
            private Integer blockResponseCode = null;
            private String blockResponseMessage = null;
            public List<BlockResponseHeaders.Builder> blockResponseHeaders = new ArrayList<BlockResponseHeaders.Builder>();

            public Builder() {
            }

            public Builder(Rule config) {
                this.name(config.name());
                this.action(config.action());
                this.hostNames(config.hostNames());
                this.methods(config.methods());
                this.pathExpressions(config.pathExpressions());
                this.blockResponseCode(config.blockResponseCode());
                this.blockResponseMessage(config.blockResponseMessage());
                for (BlockResponseHeaders b : config.blockResponseHeaders()) {
                    this.blockResponseHeaders(new BlockResponseHeaders.Builder(b));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.action != null) {
                    this.action(__superior.action);
                }
                if (!__superior.hostNames.isEmpty()) {
                    this.hostNames.addAll(__superior.hostNames);
                }
                if (!__superior.methods.isEmpty()) {
                    this.methods.addAll(__superior.methods);
                }
                if (!__superior.pathExpressions.isEmpty()) {
                    this.pathExpressions.addAll(__superior.pathExpressions);
                }
                if (__superior.blockResponseCode != null) {
                    this.blockResponseCode(__superior.blockResponseCode);
                }
                if (__superior.blockResponseMessage != null) {
                    this.blockResponseMessage(__superior.blockResponseMessage);
                }
                if (!__superior.blockResponseHeaders.isEmpty()) {
                    this.blockResponseHeaders.addAll(__superior.blockResponseHeaders);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder action(Action.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.action = __value;
                this.__uninitialized.remove("action");
                return this;
            }

            private Builder action(String __value) {
                return this.action(Action.Enum.valueOf(__value));
            }

            public Builder hostNames(String __value) {
                this.hostNames.add(__value);
                return this;
            }

            public Builder hostNames(Collection<String> __values) {
                this.hostNames.addAll(__values);
                return this;
            }

            public Builder methods(Methods.Enum __value) {
                this.methods.add(__value);
                return this;
            }

            public Builder methods(Collection<Methods.Enum> __values) {
                this.methods.addAll(__values);
                return this;
            }

            private Builder methods(String __value) {
                return this.methods(Methods.Enum.valueOf(__value));
            }

            public Builder pathExpressions(String __value) {
                this.pathExpressions.add(__value);
                return this;
            }

            public Builder pathExpressions(Collection<String> __values) {
                this.pathExpressions.addAll(__values);
                return this;
            }

            public Builder blockResponseCode(int __value) {
                this.blockResponseCode = __value;
                return this;
            }

            private Builder blockResponseCode(String __value) {
                return this.blockResponseCode(Integer.valueOf(__value));
            }

            public Builder blockResponseMessage(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.blockResponseMessage = __value;
                return this;
            }

            public Builder blockResponseHeaders(BlockResponseHeaders.Builder __builder) {
                this.blockResponseHeaders.add(__builder);
                return this;
            }

            public Builder blockResponseHeaders(Consumer<BlockResponseHeaders.Builder> __func) {
                BlockResponseHeaders.Builder __inner = new BlockResponseHeaders.Builder();
                __func.accept(__inner);
                this.blockResponseHeaders.add(__inner);
                return this;
            }

            public Builder blockResponseHeaders(List<BlockResponseHeaders.Builder> __builders) {
                this.blockResponseHeaders = __builders;
                return this;
            }

            public Rule build() {
                return new Rule(this);
            }
        }

        public static final class Action
        extends EnumNode<Enum> {
            public static final Enum ALLOW = Enum.ALLOW;
            public static final Enum BLOCK = Enum.BLOCK;

            public Action() {
                this.value = null;
            }

            public Action(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                ALLOW,
                BLOCK;

            }
        }

        public static final class Methods
        extends EnumNode<Enum> {
            public static final Enum GET = Enum.GET;
            public static final Enum POST = Enum.POST;
            public static final Enum PUT = Enum.PUT;
            public static final Enum PATCH = Enum.PATCH;
            public static final Enum DELETE = Enum.DELETE;

            public Methods() {
                this.value = null;
            }

            public Methods(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                GET,
                POST,
                PUT,
                PATCH,
                DELETE;

            }
        }

        public static final class BlockResponseHeaders
        extends InnerNode {
            private final StringNode name;
            private final StringNode value;

            public BlockResponseHeaders(Builder builder) {
                this(builder, true);
            }

            private BlockResponseHeaders(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for rule-based-filter.rule[].blockResponseHeaders[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
            }

            public String name() {
                return this.name.value();
            }

            public String value() {
                return this.value.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(BlockResponseHeaders newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("blockResponseHeaders");
                return changes;
            }

            private static InnerNodeVector<BlockResponseHeaders> createVector(List<Builder> builders) {
                ArrayList<BlockResponseHeaders> elems = new ArrayList<BlockResponseHeaders>();
                for (Builder b : builders) {
                    elems.add(new BlockResponseHeaders(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "value"));
                private String name = null;
                private String value = null;

                public Builder() {
                }

                public Builder(BlockResponseHeaders config) {
                    this.name(config.name());
                    this.value(config.value());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.value != null) {
                        this.value(__superior.value);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder value(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.value = __value;
                    this.__uninitialized.remove("value");
                    return this;
                }

                public BlockResponseHeaders build() {
                    return new BlockResponseHeaders(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

