/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.hosted.athenz.instanceproviderservice.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class AthenzProviderServiceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "7a2835cf8ef7489620ef7ec37014d034";
    public static final String CONFIG_DEF_NAME = "athenz-provider-service";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.hosted.athenz.instanceproviderservice.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.hosted.athenz.instanceproviderservice.config", "domain string", "serviceName string", "secretName string", "secretVersion int", "caCertSecretName string", "certDnsSuffix string default=\"\"", "ztsUrl string default=\"\"", "athenzCaTrustStore string default=\"\"", "updatePeriodDays int default=1", "tenantService string default=vespa.vespa.tenant"};
    private final StringNode domain;
    private final StringNode serviceName;
    private final StringNode secretName;
    private final IntegerNode secretVersion;
    private final StringNode caCertSecretName;
    private final StringNode certDnsSuffix;
    private final StringNode ztsUrl;
    private final StringNode athenzCaTrustStore;
    private final IntegerNode updatePeriodDays;
    private final StringNode tenantService;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public AthenzProviderServiceConfig(Builder builder) {
        this(builder, true);
    }

    private AthenzProviderServiceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for athenz-provider-service must be initialized: " + builder.__uninitialized);
        }
        this.domain = builder.domain == null ? new StringNode() : new StringNode(builder.domain);
        this.serviceName = builder.serviceName == null ? new StringNode() : new StringNode(builder.serviceName);
        this.secretName = builder.secretName == null ? new StringNode() : new StringNode(builder.secretName);
        this.secretVersion = builder.secretVersion == null ? new IntegerNode() : new IntegerNode(builder.secretVersion.intValue());
        this.caCertSecretName = builder.caCertSecretName == null ? new StringNode() : new StringNode(builder.caCertSecretName);
        this.certDnsSuffix = builder.certDnsSuffix == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.certDnsSuffix);
        this.ztsUrl = builder.ztsUrl == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.ztsUrl);
        this.athenzCaTrustStore = builder.athenzCaTrustStore == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.athenzCaTrustStore);
        this.updatePeriodDays = builder.updatePeriodDays == null ? new IntegerNode(1) : new IntegerNode(builder.updatePeriodDays.intValue());
        this.tenantService = builder.tenantService == null ? new StringNode("vespa.vespa.tenant") : new StringNode(builder.tenantService);
    }

    public String domain() {
        return this.domain.value();
    }

    public String serviceName() {
        return this.serviceName.value();
    }

    public String secretName() {
        return this.secretName.value();
    }

    public int secretVersion() {
        return this.secretVersion.value();
    }

    public String caCertSecretName() {
        return this.caCertSecretName.value();
    }

    public String certDnsSuffix() {
        return this.certDnsSuffix.value();
    }

    public String ztsUrl() {
        return this.ztsUrl.value();
    }

    public String athenzCaTrustStore() {
        return this.athenzCaTrustStore.value();
    }

    public int updatePeriodDays() {
        return this.updatePeriodDays.value();
    }

    public String tenantService() {
        return this.tenantService.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AthenzProviderServiceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("domain", "serviceName", "secretName", "secretVersion", "caCertSecretName"));
        private String domain = null;
        private String serviceName = null;
        private String secretName = null;
        private Integer secretVersion = null;
        private String caCertSecretName = null;
        private String certDnsSuffix = null;
        private String ztsUrl = null;
        private String athenzCaTrustStore = null;
        private Integer updatePeriodDays = null;
        private String tenantService = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(AthenzProviderServiceConfig config) {
            this.domain(config.domain());
            this.serviceName(config.serviceName());
            this.secretName(config.secretName());
            this.secretVersion(config.secretVersion());
            this.caCertSecretName(config.caCertSecretName());
            this.certDnsSuffix(config.certDnsSuffix());
            this.ztsUrl(config.ztsUrl());
            this.athenzCaTrustStore(config.athenzCaTrustStore());
            this.updatePeriodDays(config.updatePeriodDays());
            this.tenantService(config.tenantService());
        }

        private Builder override(Builder __superior) {
            if (__superior.domain != null) {
                this.domain(__superior.domain);
            }
            if (__superior.serviceName != null) {
                this.serviceName(__superior.serviceName);
            }
            if (__superior.secretName != null) {
                this.secretName(__superior.secretName);
            }
            if (__superior.secretVersion != null) {
                this.secretVersion(__superior.secretVersion);
            }
            if (__superior.caCertSecretName != null) {
                this.caCertSecretName(__superior.caCertSecretName);
            }
            if (__superior.certDnsSuffix != null) {
                this.certDnsSuffix(__superior.certDnsSuffix);
            }
            if (__superior.ztsUrl != null) {
                this.ztsUrl(__superior.ztsUrl);
            }
            if (__superior.athenzCaTrustStore != null) {
                this.athenzCaTrustStore(__superior.athenzCaTrustStore);
            }
            if (__superior.updatePeriodDays != null) {
                this.updatePeriodDays(__superior.updatePeriodDays);
            }
            if (__superior.tenantService != null) {
                this.tenantService(__superior.tenantService);
            }
            return this;
        }

        public Builder domain(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.domain = __value;
            this.__uninitialized.remove("domain");
            return this;
        }

        public Builder serviceName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.serviceName = __value;
            this.__uninitialized.remove("serviceName");
            return this;
        }

        public Builder secretName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.secretName = __value;
            this.__uninitialized.remove("secretName");
            return this;
        }

        public Builder secretVersion(int __value) {
            this.secretVersion = __value;
            this.__uninitialized.remove("secretVersion");
            return this;
        }

        private Builder secretVersion(String __value) {
            return this.secretVersion(Integer.valueOf(__value));
        }

        public Builder caCertSecretName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.caCertSecretName = __value;
            this.__uninitialized.remove("caCertSecretName");
            return this;
        }

        public Builder certDnsSuffix(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.certDnsSuffix = __value;
            return this;
        }

        public Builder ztsUrl(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.ztsUrl = __value;
            return this;
        }

        public Builder athenzCaTrustStore(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.athenzCaTrustStore = __value;
            return this;
        }

        public Builder updatePeriodDays(int __value) {
            this.updatePeriodDays = __value;
            return this;
        }

        private Builder updatePeriodDays(String __value) {
            return this.updatePeriodDays(Integer.valueOf(__value));
        }

        public Builder tenantService(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tenantService = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AthenzProviderServiceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AthenzProviderServiceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AthenzProviderServiceConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public AthenzProviderServiceConfig build() {
            return new AthenzProviderServiceConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

