/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.PathNode;
import com.yahoo.config.StringNode;
import com.yahoo.config.UrlNode;
import com.yahoo.config.UrlReference;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class BertBaseEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "74cda80d8ca639547ddac67c993c6f27";
    public static final String CONFIG_DEF_NAME = "bert-base-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding", "tokenizerVocabUrl url", "tokenizerVocabPath path", "transformerModelUrl url", "transformerModelPath path", "transformerMaxTokens int default=384", "poolingStrategy enum { cls, mean } default=mean", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerTokenTypeIds string default=token_type_ids", "transformerOutput string default=output_0", "onnxExecutionMode enum { parallel, sequential } default=sequential", "onnxInterOpThreads int default=1", "onnxIntraOpThreads int default=-4"};
    private final UrlNode tokenizerVocabUrl;
    private final PathNode tokenizerVocabPath;
    private final UrlNode transformerModelUrl;
    private final PathNode transformerModelPath;
    private final IntegerNode transformerMaxTokens;
    private final PoolingStrategy poolingStrategy;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final StringNode transformerTokenTypeIds;
    private final StringNode transformerOutput;
    private final OnnxExecutionMode onnxExecutionMode;
    private final IntegerNode onnxInterOpThreads;
    private final IntegerNode onnxIntraOpThreads;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public BertBaseEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private BertBaseEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for bert-base-embedder must be initialized: " + builder.__uninitialized);
        }
        this.tokenizerVocabUrl = builder.tokenizerVocabUrl == null ? new UrlNode() : new UrlNode(builder.tokenizerVocabUrl);
        this.tokenizerVocabPath = builder.tokenizerVocabPath == null ? new PathNode() : new PathNode(builder.tokenizerVocabPath);
        this.transformerModelUrl = builder.transformerModelUrl == null ? new UrlNode() : new UrlNode(builder.transformerModelUrl);
        this.transformerModelPath = builder.transformerModelPath == null ? new PathNode() : new PathNode(builder.transformerModelPath);
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(384) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.poolingStrategy = builder.poolingStrategy == null ? new PoolingStrategy(PoolingStrategy.mean) : new PoolingStrategy(builder.poolingStrategy);
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerTokenTypeIds = builder.transformerTokenTypeIds == null ? new StringNode("token_type_ids") : new StringNode(builder.transformerTokenTypeIds);
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("output_0") : new StringNode(builder.transformerOutput);
        this.onnxExecutionMode = builder.onnxExecutionMode == null ? new OnnxExecutionMode(OnnxExecutionMode.sequential) : new OnnxExecutionMode(builder.onnxExecutionMode);
        this.onnxInterOpThreads = builder.onnxInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.onnxInterOpThreads.intValue());
        this.onnxIntraOpThreads = builder.onnxIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.onnxIntraOpThreads.intValue());
    }

    public File tokenizerVocabUrl() {
        return this.tokenizerVocabUrl.value();
    }

    public Path tokenizerVocabPath() {
        return this.tokenizerVocabPath.value();
    }

    public File transformerModelUrl() {
        return this.transformerModelUrl.value();
    }

    public Path transformerModelPath() {
        return this.transformerModelPath.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public PoolingStrategy.Enum poolingStrategy() {
        return (PoolingStrategy.Enum)((Object)this.poolingStrategy.value());
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public String transformerTokenTypeIds() {
        return this.transformerTokenTypeIds.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    public OnnxExecutionMode.Enum onnxExecutionMode() {
        return (OnnxExecutionMode.Enum)((Object)this.onnxExecutionMode.value());
    }

    public int onnxInterOpThreads() {
        return this.onnxInterOpThreads.value();
    }

    public int onnxIntraOpThreads() {
        return this.onnxIntraOpThreads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(BertBaseEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("tokenizerVocabUrl", "tokenizerVocabPath", "transformerModelUrl", "transformerModelPath"));
        private UrlReference tokenizerVocabUrl = null;
        private FileReference tokenizerVocabPath = null;
        private UrlReference transformerModelUrl = null;
        private FileReference transformerModelPath = null;
        private Integer transformerMaxTokens = null;
        private PoolingStrategy.Enum poolingStrategy = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private String transformerTokenTypeIds = null;
        private String transformerOutput = null;
        private OnnxExecutionMode.Enum onnxExecutionMode = null;
        private Integer onnxInterOpThreads = null;
        private Integer onnxIntraOpThreads = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(BertBaseEmbedderConfig config) {
            this.tokenizerVocabUrl(config.tokenizerVocabUrl.getUrlReference());
            this.tokenizerVocabPath(config.tokenizerVocabPath.getFileReference());
            this.transformerModelUrl(config.transformerModelUrl.getUrlReference());
            this.transformerModelPath(config.transformerModelPath.getFileReference());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.poolingStrategy(config.poolingStrategy());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerTokenTypeIds(config.transformerTokenTypeIds());
            this.transformerOutput(config.transformerOutput());
            this.onnxExecutionMode(config.onnxExecutionMode());
            this.onnxInterOpThreads(config.onnxInterOpThreads());
            this.onnxIntraOpThreads(config.onnxIntraOpThreads());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerVocabUrl != null) {
                this.tokenizerVocabUrl(__superior.tokenizerVocabUrl);
            }
            if (__superior.tokenizerVocabPath != null) {
                this.tokenizerVocabPath(__superior.tokenizerVocabPath);
            }
            if (__superior.transformerModelUrl != null) {
                this.transformerModelUrl(__superior.transformerModelUrl);
            }
            if (__superior.transformerModelPath != null) {
                this.transformerModelPath(__superior.transformerModelPath);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.poolingStrategy != null) {
                this.poolingStrategy(__superior.poolingStrategy);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerTokenTypeIds != null) {
                this.transformerTokenTypeIds(__superior.transformerTokenTypeIds);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            if (__superior.onnxExecutionMode != null) {
                this.onnxExecutionMode(__superior.onnxExecutionMode);
            }
            if (__superior.onnxInterOpThreads != null) {
                this.onnxInterOpThreads(__superior.onnxInterOpThreads);
            }
            if (__superior.onnxIntraOpThreads != null) {
                this.onnxIntraOpThreads(__superior.onnxIntraOpThreads);
            }
            return this;
        }

        public Builder tokenizerVocabUrl(UrlReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerVocabUrl = __value;
            this.__uninitialized.remove("tokenizerVocabUrl");
            return this;
        }

        private Builder tokenizerVocabUrl(String __value) {
            return this.tokenizerVocabUrl(UrlReference.valueOf((String)__value));
        }

        public Builder tokenizerVocabPath(FileReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerVocabPath = __value;
            this.__uninitialized.remove("tokenizerVocabPath");
            return this;
        }

        public Builder transformerModelUrl(UrlReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModelUrl = __value;
            this.__uninitialized.remove("transformerModelUrl");
            return this;
        }

        private Builder transformerModelUrl(String __value) {
            return this.transformerModelUrl(UrlReference.valueOf((String)__value));
        }

        public Builder transformerModelPath(FileReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModelPath = __value;
            this.__uninitialized.remove("transformerModelPath");
            return this;
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder poolingStrategy(PoolingStrategy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.poolingStrategy = __value;
            return this;
        }

        private Builder poolingStrategy(String __value) {
            return this.poolingStrategy(PoolingStrategy.Enum.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerTokenTypeIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerTokenTypeIds = __value;
            return this;
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public Builder onnxExecutionMode(OnnxExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.onnxExecutionMode = __value;
            return this;
        }

        private Builder onnxExecutionMode(String __value) {
            return this.onnxExecutionMode(OnnxExecutionMode.Enum.valueOf(__value));
        }

        public Builder onnxInterOpThreads(int __value) {
            this.onnxInterOpThreads = __value;
            return this;
        }

        private Builder onnxInterOpThreads(String __value) {
            return this.onnxInterOpThreads(Integer.valueOf(__value));
        }

        public Builder onnxIntraOpThreads(int __value) {
            this.onnxIntraOpThreads = __value;
            return this;
        }

        private Builder onnxIntraOpThreads(String __value) {
            return this.onnxIntraOpThreads(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return BertBaseEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return BertBaseEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return BertBaseEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public BertBaseEmbedderConfig build() {
            return new BertBaseEmbedderConfig(this);
        }
    }

    public static final class PoolingStrategy
    extends EnumNode<Enum> {
        public static final Enum cls = Enum.cls;
        public static final Enum mean = Enum.mean;

        public PoolingStrategy() {
            this.value = null;
        }

        public PoolingStrategy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            cls,
            mean;

        }
    }

    public static final class OnnxExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public OnnxExecutionMode() {
            this.value = null;
        }

        public OnnxExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

