/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class RankProfilesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "07c50f2a77ea7c8b26345fc12e211d3b";
    public static final String CONFIG_DEF_NAME = "rank-profiles";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "rankprofile[].name string", "rankprofile[].fef.property[].name string", "rankprofile[].fef.property[].value string"};
    private final InnerNodeVector<Rankprofile> rankprofile;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public RankProfilesConfig(Builder builder) {
        this(builder, true);
    }

    private RankProfilesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for rank-profiles must be initialized: " + builder.__uninitialized);
        }
        this.rankprofile = Rankprofile.createVector(builder.rankprofile);
    }

    public List<Rankprofile> rankprofile() {
        return this.rankprofile;
    }

    public Rankprofile rankprofile(int i) {
        return (Rankprofile)((Object)this.rankprofile.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RankProfilesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Rankprofile.Builder> rankprofile = new ArrayList<Rankprofile.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RankProfilesConfig config) {
            for (Rankprofile r : config.rankprofile()) {
                this.rankprofile(new Rankprofile.Builder(r));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.rankprofile.isEmpty()) {
                this.rankprofile.addAll(__superior.rankprofile);
            }
            return this;
        }

        public Builder rankprofile(Rankprofile.Builder __builder) {
            this.rankprofile.add(__builder);
            return this;
        }

        public Builder rankprofile(Consumer<Rankprofile.Builder> __func) {
            Rankprofile.Builder __inner = new Rankprofile.Builder();
            __func.accept(__inner);
            this.rankprofile.add(__inner);
            return this;
        }

        public Builder rankprofile(List<Rankprofile.Builder> __builders) {
            this.rankprofile = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RankProfilesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RankProfilesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RankProfilesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RankProfilesConfig build() {
            return new RankProfilesConfig(this);
        }
    }

    public static final class Rankprofile
    extends InnerNode {
        private final StringNode name;
        private final Fef fef;

        public Rankprofile(Builder builder) {
            this(builder, true);
        }

        private Rankprofile(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for rank-profiles.rankprofile[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.fef = new Fef(builder.fef, throwIfUninitialized);
        }

        public String name() {
            return this.name.value();
        }

        public Fef fef() {
            return this.fef;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rankprofile newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rankprofile");
            return changes;
        }

        private static InnerNodeVector<Rankprofile> createVector(List<Builder> builders) {
            ArrayList<Rankprofile> elems = new ArrayList<Rankprofile>();
            for (Builder b : builders) {
                elems.add(new Rankprofile(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public Fef.Builder fef = new Fef.Builder();

            public Builder() {
            }

            public Builder(Rankprofile config) {
                this.name(config.name());
                this.fef(new Fef.Builder(config.fef()));
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                this.fef(this.fef.override(__superior.fef));
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder fef(Fef.Builder __builder) {
                this.fef = __builder;
                return this;
            }

            public Builder fef(Consumer<Fef.Builder> __func) {
                Fef.Builder __inner = new Fef.Builder();
                __func.accept(__inner);
                this.fef = __inner;
                return this;
            }

            public Rankprofile build() {
                return new Rankprofile(this);
            }
        }

        public static final class Fef
        extends InnerNode {
            private final InnerNodeVector<Property> property;

            public Fef(Builder builder) {
                this(builder, true);
            }

            private Fef(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for rank-profiles.rankprofile[].fef must be initialized: " + builder.__uninitialized);
                }
                this.property = Property.createVector(builder.property);
            }

            public List<Property> property() {
                return this.property;
            }

            public Property property(int i) {
                return (Property)((Object)this.property.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fef newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fef");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public List<Property.Builder> property = new ArrayList<Property.Builder>();

                public Builder() {
                }

                public Builder(Fef config) {
                    for (Property p : config.property()) {
                        this.property(new Property.Builder(p));
                    }
                }

                private Builder override(Builder __superior) {
                    if (!__superior.property.isEmpty()) {
                        this.property.addAll(__superior.property);
                    }
                    return this;
                }

                public Builder property(Property.Builder __builder) {
                    this.property.add(__builder);
                    return this;
                }

                public Builder property(Consumer<Property.Builder> __func) {
                    Property.Builder __inner = new Property.Builder();
                    __func.accept(__inner);
                    this.property.add(__inner);
                    return this;
                }

                public Builder property(List<Property.Builder> __builders) {
                    this.property = __builders;
                    return this;
                }

                public Fef build() {
                    return new Fef(this);
                }
            }

            public static final class Property
            extends InnerNode {
                private final StringNode name;
                private final StringNode value;

                public Property(Builder builder) {
                    this(builder, true);
                }

                private Property(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for rank-profiles.rankprofile[].fef.property[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
                }

                public String name() {
                    return this.name.value();
                }

                public String value() {
                    return this.value.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Property newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("property");
                    return changes;
                }

                private static InnerNodeVector<Property> createVector(List<Builder> builders) {
                    ArrayList<Property> elems = new ArrayList<Property>();
                    for (Builder b : builders) {
                        elems.add(new Property(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "value"));
                    private String name = null;
                    private String value = null;

                    public Builder() {
                    }

                    public Builder(Property config) {
                        this.name(config.name());
                        this.value(config.value());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.value != null) {
                            this.value(__superior.value);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder value(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.value = __value;
                        this.__uninitialized.remove("value");
                        return this;
                    }

                    public Property build() {
                        return new Property(this);
                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

