/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SummaryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c880827c36ba31f8e4d4995169eeae8a";
    public static final String CONFIG_DEF_NAME = "summary";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "defaultsummaryid int default=-1", "usev8geopositions bool default=false", "classes[].id int", "classes[].name string", "classes[].omitsummaryfeatures bool default=false", "classes[].fields[].name string", "classes[].fields[].type string"};
    private final IntegerNode defaultsummaryid;
    private final BooleanNode usev8geopositions;
    private final InnerNodeVector<Classes> classes;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public SummaryConfig(Builder builder) {
        this(builder, true);
    }

    private SummaryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for summary must be initialized: " + builder.__uninitialized);
        }
        this.defaultsummaryid = builder.defaultsummaryid == null ? new IntegerNode(-1) : new IntegerNode(builder.defaultsummaryid.intValue());
        this.usev8geopositions = builder.usev8geopositions == null ? new BooleanNode(false) : new BooleanNode(builder.usev8geopositions.booleanValue());
        this.classes = Classes.createVector(builder.classes);
    }

    public int defaultsummaryid() {
        return this.defaultsummaryid.value();
    }

    public boolean usev8geopositions() {
        return this.usev8geopositions.value();
    }

    public List<Classes> classes() {
        return this.classes;
    }

    public Classes classes(int i) {
        return (Classes)((Object)this.classes.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SummaryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer defaultsummaryid = null;
        private Boolean usev8geopositions = null;
        public List<Classes.Builder> classes = new ArrayList<Classes.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SummaryConfig config) {
            this.defaultsummaryid(config.defaultsummaryid());
            this.usev8geopositions(config.usev8geopositions());
            for (Classes c : config.classes()) {
                this.classes(new Classes.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.defaultsummaryid != null) {
                this.defaultsummaryid(__superior.defaultsummaryid);
            }
            if (__superior.usev8geopositions != null) {
                this.usev8geopositions(__superior.usev8geopositions);
            }
            if (!__superior.classes.isEmpty()) {
                this.classes.addAll(__superior.classes);
            }
            return this;
        }

        public Builder defaultsummaryid(int __value) {
            this.defaultsummaryid = __value;
            return this;
        }

        private Builder defaultsummaryid(String __value) {
            return this.defaultsummaryid(Integer.valueOf(__value));
        }

        public Builder usev8geopositions(boolean __value) {
            this.usev8geopositions = __value;
            return this;
        }

        private Builder usev8geopositions(String __value) {
            return this.usev8geopositions(Boolean.valueOf(__value));
        }

        public Builder classes(Classes.Builder __builder) {
            this.classes.add(__builder);
            return this;
        }

        public Builder classes(Consumer<Classes.Builder> __func) {
            Classes.Builder __inner = new Classes.Builder();
            __func.accept(__inner);
            this.classes.add(__inner);
            return this;
        }

        public Builder classes(List<Classes.Builder> __builders) {
            this.classes = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SummaryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SummaryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SummaryConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SummaryConfig build() {
            return new SummaryConfig(this);
        }
    }

    public static final class Classes
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final BooleanNode omitsummaryfeatures;
        private final InnerNodeVector<Fields> fields;

        public Classes(Builder builder) {
            this(builder, true);
        }

        private Classes(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for summary.classes[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.omitsummaryfeatures = builder.omitsummaryfeatures == null ? new BooleanNode(false) : new BooleanNode(builder.omitsummaryfeatures.booleanValue());
            this.fields = Fields.createVector(builder.fields);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public boolean omitsummaryfeatures() {
            return this.omitsummaryfeatures.value();
        }

        public List<Fields> fields() {
            return this.fields;
        }

        public Fields fields(int i) {
            return (Fields)((Object)this.fields.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Classes newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("classes");
            return changes;
        }

        private static InnerNodeVector<Classes> createVector(List<Builder> builders) {
            ArrayList<Classes> elems = new ArrayList<Classes>();
            for (Builder b : builders) {
                elems.add(new Classes(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "name"));
            private Integer id = null;
            private String name = null;
            private Boolean omitsummaryfeatures = null;
            public List<Fields.Builder> fields = new ArrayList<Fields.Builder>();

            public Builder() {
            }

            public Builder(Classes config) {
                this.id(config.id());
                this.name(config.name());
                this.omitsummaryfeatures(config.omitsummaryfeatures());
                for (Fields f : config.fields()) {
                    this.fields(new Fields.Builder(f));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.omitsummaryfeatures != null) {
                    this.omitsummaryfeatures(__superior.omitsummaryfeatures);
                }
                if (!__superior.fields.isEmpty()) {
                    this.fields.addAll(__superior.fields);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder omitsummaryfeatures(boolean __value) {
                this.omitsummaryfeatures = __value;
                return this;
            }

            private Builder omitsummaryfeatures(String __value) {
                return this.omitsummaryfeatures(Boolean.valueOf(__value));
            }

            public Builder fields(Fields.Builder __builder) {
                this.fields.add(__builder);
                return this;
            }

            public Builder fields(Consumer<Fields.Builder> __func) {
                Fields.Builder __inner = new Fields.Builder();
                __func.accept(__inner);
                this.fields.add(__inner);
                return this;
            }

            public Builder fields(List<Fields.Builder> __builders) {
                this.fields = __builders;
                return this;
            }

            public Classes build() {
                return new Classes(this);
            }
        }

        public static final class Fields
        extends InnerNode {
            private final StringNode name;
            private final StringNode type;

            public Fields(Builder builder) {
                this(builder, true);
            }

            private Fields(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for summary.classes[].fields[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
            }

            public String name() {
                return this.name.value();
            }

            public String type() {
                return this.type.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fields newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fields");
                return changes;
            }

            private static InnerNodeVector<Fields> createVector(List<Builder> builders) {
                ArrayList<Fields> elems = new ArrayList<Fields>();
                for (Builder b : builders) {
                    elems.add(new Fields(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "type"));
                private String name = null;
                private String type = null;

                public Builder() {
                }

                public Builder(Fields config) {
                    this.name(config.name());
                    this.type(config.type());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder type(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    this.__uninitialized.remove("type");
                    return this;
                }

                public Fields build() {
                    return new Fields(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

