/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ImportedFieldsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "baa648b23e7f979b8c809e5a5f2cd42b";
    public static final String CONFIG_DEF_NAME = "imported-fields";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "attribute[].name string", "attribute[].referencefield string", "attribute[].targetfield string"};
    private final InnerNodeVector<Attribute> attribute;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ImportedFieldsConfig(Builder builder) {
        this(builder, true);
    }

    private ImportedFieldsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for imported-fields must be initialized: " + builder.__uninitialized);
        }
        this.attribute = Attribute.createVector(builder.attribute);
    }

    public List<Attribute> attribute() {
        return this.attribute;
    }

    public Attribute attribute(int i) {
        return (Attribute)((Object)this.attribute.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ImportedFieldsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Attribute
    extends InnerNode {
        private final StringNode name;
        private final StringNode referencefield;
        private final StringNode targetfield;

        public Attribute(Builder builder) {
            this(builder, true);
        }

        private Attribute(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for imported-fields.attribute[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.referencefield = builder.referencefield == null ? new StringNode() : new StringNode(builder.referencefield);
            this.targetfield = builder.targetfield == null ? new StringNode() : new StringNode(builder.targetfield);
        }

        public String name() {
            return this.name.value();
        }

        public String referencefield() {
            return this.referencefield.value();
        }

        public String targetfield() {
            return this.targetfield.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
            return changes;
        }

        private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
            ArrayList<Attribute> elems = new ArrayList<Attribute>();
            for (Builder b : builders) {
                elems.add(new Attribute(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "referencefield", "targetfield"));
            private String name = null;
            private String referencefield = null;
            private String targetfield = null;

            public Builder() {
            }

            public Builder(Attribute config) {
                this.name(config.name());
                this.referencefield(config.referencefield());
                this.targetfield(config.targetfield());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.referencefield != null) {
                    this.referencefield(__superior.referencefield);
                }
                if (__superior.targetfield != null) {
                    this.targetfield(__superior.targetfield);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder referencefield(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.referencefield = __value;
                this.__uninitialized.remove("referencefield");
                return this;
            }

            public Builder targetfield(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.targetfield = __value;
                this.__uninitialized.remove("targetfield");
                return this;
            }

            public Attribute build() {
                return new Attribute(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Attribute.Builder> attribute = new ArrayList<Attribute.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ImportedFieldsConfig config) {
            for (Attribute a : config.attribute()) {
                this.attribute(new Attribute.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.attribute.isEmpty()) {
                this.attribute.addAll(__superior.attribute);
            }
            return this;
        }

        public Builder attribute(Attribute.Builder __builder) {
            this.attribute.add(__builder);
            return this;
        }

        public Builder attribute(Consumer<Attribute.Builder> __func) {
            Attribute.Builder __inner = new Attribute.Builder();
            __func.accept(__inner);
            this.attribute.add(__inner);
            return this;
        }

        public Builder attribute(List<Attribute.Builder> __builders) {
            this.attribute = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ImportedFieldsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ImportedFieldsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ImportedFieldsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ImportedFieldsConfig build() {
            return new ImportedFieldsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

