/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CuratorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "1e17ababc0c136945b956725814017b8";
    public static final String CONFIG_DEF_NAME = "curator";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "server[].hostname string", "server[].port int default=2181", "zookeeperLocalhostAffinity bool default=false"};
    private final InnerNodeVector<Server> server;
    private final BooleanNode zookeeperLocalhostAffinity;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public CuratorConfig(Builder builder) {
        this(builder, true);
    }

    private CuratorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for curator must be initialized: " + builder.__uninitialized);
        }
        this.server = Server.createVector(builder.server);
        this.zookeeperLocalhostAffinity = builder.zookeeperLocalhostAffinity == null ? new BooleanNode(false) : new BooleanNode(builder.zookeeperLocalhostAffinity.booleanValue());
    }

    public List<Server> server() {
        return this.server;
    }

    public Server server(int i) {
        return (Server)((Object)this.server.get(i));
    }

    public boolean zookeeperLocalhostAffinity() {
        return this.zookeeperLocalhostAffinity.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(CuratorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Server
    extends InnerNode {
        private final StringNode hostname;
        private final IntegerNode port;

        public Server(Builder builder) {
            this(builder, true);
        }

        private Server(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for curator.server[] must be initialized: " + builder.__uninitialized);
            }
            this.hostname = builder.hostname == null ? new StringNode() : new StringNode(builder.hostname);
            this.port = builder.port == null ? new IntegerNode(2181) : new IntegerNode(builder.port.intValue());
        }

        public String hostname() {
            return this.hostname.value();
        }

        public int port() {
            return this.port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Server newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("server");
            return changes;
        }

        private static InnerNodeVector<Server> createVector(List<Builder> builders) {
            ArrayList<Server> elems = new ArrayList<Server>();
            for (Builder b : builders) {
                elems.add(new Server(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("hostname"));
            private String hostname = null;
            private Integer port = null;

            public Builder() {
            }

            public Builder(Server config) {
                this.hostname(config.hostname());
                this.port(config.port());
            }

            private Builder override(Builder __superior) {
                if (__superior.hostname != null) {
                    this.hostname(__superior.hostname);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                return this;
            }

            public Builder hostname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hostname = __value;
                this.__uninitialized.remove("hostname");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Server build() {
                return new Server(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Server.Builder> server = new ArrayList<Server.Builder>();
        private Boolean zookeeperLocalhostAffinity = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(CuratorConfig config) {
            for (Server s : config.server()) {
                this.server(new Server.Builder(s));
            }
            this.zookeeperLocalhostAffinity(config.zookeeperLocalhostAffinity());
        }

        private Builder override(Builder __superior) {
            if (!__superior.server.isEmpty()) {
                this.server.addAll(__superior.server);
            }
            if (__superior.zookeeperLocalhostAffinity != null) {
                this.zookeeperLocalhostAffinity(__superior.zookeeperLocalhostAffinity);
            }
            return this;
        }

        public Builder server(Server.Builder __builder) {
            this.server.add(__builder);
            return this;
        }

        public Builder server(List<Server.Builder> __builders) {
            this.server = __builders;
            return this;
        }

        public Builder zookeeperLocalhostAffinity(boolean __value) {
            this.zookeeperLocalhostAffinity = __value;
            return this;
        }

        private Builder zookeeperLocalhostAffinity(String __value) {
            return this.zookeeperLocalhostAffinity(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return CuratorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return CuratorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return CuratorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public CuratorConfig build() {
            return new CuratorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

