/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.reindexing;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ReindexingConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "974492b375cb53eab756c30b1808533c";
    public static final String CONFIG_DEF_NAME = "reindexing";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.reindexing";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.reindexing", "enabled bool default=false", "clusterName string default=\"\"", "status{}.readyAtMillis long", "clusters{}.documentTypes{}.readyAtMillis long", "windowSizeIncrement double default=0.2"};
    private final BooleanNode enabled;
    private final StringNode clusterName;
    private final Map<String, Status> status;
    private final Map<String, Clusters> clusters;
    private final DoubleNode windowSizeIncrement;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ReindexingConfig(Builder builder) {
        this(builder, true);
    }

    private ReindexingConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for reindexing must be initialized: " + builder.__uninitialized);
        }
        this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
        this.clusterName = builder.clusterName == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.clusterName);
        this.status = Status.createMap(builder.status);
        this.clusters = Clusters.createMap(builder.clusters);
        this.windowSizeIncrement = builder.windowSizeIncrement == null ? new DoubleNode(0.2) : new DoubleNode(builder.windowSizeIncrement.doubleValue());
    }

    public boolean enabled() {
        return this.enabled.value();
    }

    public String clusterName() {
        return this.clusterName.value();
    }

    public Map<String, Status> status() {
        return Collections.unmodifiableMap(this.status);
    }

    public Status status(String key) {
        return this.status.get(key);
    }

    public Map<String, Clusters> clusters() {
        return Collections.unmodifiableMap(this.clusters);
    }

    public Clusters clusters(String key) {
        return this.clusters.get(key);
    }

    public double windowSizeIncrement() {
        return this.windowSizeIncrement.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ReindexingConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Clusters
    extends InnerNode {
        private final Map<String, DocumentTypes> documentTypes;

        public Clusters(Builder builder) {
            this(builder, true);
        }

        private Clusters(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for reindexing.clusters{} must be initialized: " + builder.__uninitialized);
            }
            this.documentTypes = DocumentTypes.createMap(builder.documentTypes);
        }

        public Map<String, DocumentTypes> documentTypes() {
            return Collections.unmodifiableMap(this.documentTypes);
        }

        public DocumentTypes documentTypes(String key) {
            return this.documentTypes.get(key);
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Clusters newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("clusters");
            return changes;
        }

        private static Map<String, Clusters> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Clusters> ret = new LinkedHashMap<String, Clusters>();
            for (String key : builders.keySet()) {
                ret.put(key, new Clusters(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static final class DocumentTypes
        extends InnerNode {
            private final LongNode readyAtMillis;

            public DocumentTypes(Builder builder) {
                this(builder, true);
            }

            private DocumentTypes(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for reindexing.clusters{}.documentTypes{} must be initialized: " + builder.__uninitialized);
                }
                this.readyAtMillis = builder.readyAtMillis == null ? new LongNode() : new LongNode(builder.readyAtMillis.longValue());
            }

            public long readyAtMillis() {
                return this.readyAtMillis.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(DocumentTypes newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("documentTypes");
                return changes;
            }

            private static Map<String, DocumentTypes> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, DocumentTypes> ret = new LinkedHashMap<String, DocumentTypes>();
                for (String key : builders.keySet()) {
                    ret.put(key, new DocumentTypes(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("readyAtMillis"));
                private Long readyAtMillis = null;

                public Builder() {
                }

                public Builder(DocumentTypes config) {
                    this.readyAtMillis(config.readyAtMillis());
                }

                private Builder override(Builder __superior) {
                    if (__superior.readyAtMillis != null) {
                        this.readyAtMillis(__superior.readyAtMillis);
                    }
                    return this;
                }

                public Builder readyAtMillis(long __value) {
                    this.readyAtMillis = __value;
                    this.__uninitialized.remove("readyAtMillis");
                    return this;
                }

                private Builder readyAtMillis(String __value) {
                    return this.readyAtMillis(Long.valueOf(__value));
                }

                public DocumentTypes build() {
                    return new DocumentTypes(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Map<String, DocumentTypes.Builder> documentTypes = new LinkedHashMap<String, DocumentTypes.Builder>();

            public Builder() {
            }

            public Builder(Clusters config) {
                for (Map.Entry<String, DocumentTypes> __entry : config.documentTypes().entrySet()) {
                    this.documentTypes(__entry.getKey(), new DocumentTypes.Builder(__entry.getValue()));
                }
            }

            private Builder override(Builder __superior) {
                this.documentTypes(__superior.documentTypes);
                return this;
            }

            public Builder documentTypes(String __key, DocumentTypes.Builder __value) {
                this.documentTypes.put(__key, __value);
                return this;
            }

            public Builder documentTypes(Map<String, DocumentTypes.Builder> __values) {
                this.documentTypes.putAll(__values);
                return this;
            }

            public Clusters build() {
                return new Clusters(this);
            }
        }
    }

    public static final class Status
    extends InnerNode {
        private final LongNode readyAtMillis;

        public Status(Builder builder) {
            this(builder, true);
        }

        private Status(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for reindexing.status{} must be initialized: " + builder.__uninitialized);
            }
            this.readyAtMillis = builder.readyAtMillis == null ? new LongNode() : new LongNode(builder.readyAtMillis.longValue());
        }

        public long readyAtMillis() {
            return this.readyAtMillis.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Status newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("status");
            return changes;
        }

        private static Map<String, Status> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Status> ret = new LinkedHashMap<String, Status>();
            for (String key : builders.keySet()) {
                ret.put(key, new Status(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("readyAtMillis"));
            private Long readyAtMillis = null;

            public Builder() {
            }

            public Builder(Status config) {
                this.readyAtMillis(config.readyAtMillis());
            }

            private Builder override(Builder __superior) {
                if (__superior.readyAtMillis != null) {
                    this.readyAtMillis(__superior.readyAtMillis);
                }
                return this;
            }

            public Builder readyAtMillis(long __value) {
                this.readyAtMillis = __value;
                this.__uninitialized.remove("readyAtMillis");
                return this;
            }

            private Builder readyAtMillis(String __value) {
                return this.readyAtMillis(Long.valueOf(__value));
            }

            public Status build() {
                return new Status(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean enabled = null;
        private String clusterName = null;
        public Map<String, Status.Builder> status = new LinkedHashMap<String, Status.Builder>();
        public Map<String, Clusters.Builder> clusters = new LinkedHashMap<String, Clusters.Builder>();
        private Double windowSizeIncrement = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ReindexingConfig config) {
            this.enabled(config.enabled());
            this.clusterName(config.clusterName());
            for (Map.Entry<String, Status> entry : config.status().entrySet()) {
                this.status(entry.getKey(), new Status.Builder(entry.getValue()));
            }
            for (Map.Entry<String, InnerNode> entry : config.clusters().entrySet()) {
                this.clusters(entry.getKey(), new Clusters.Builder((Clusters)entry.getValue()));
            }
            this.windowSizeIncrement(config.windowSizeIncrement());
        }

        private Builder override(Builder __superior) {
            if (__superior.enabled != null) {
                this.enabled(__superior.enabled);
            }
            if (__superior.clusterName != null) {
                this.clusterName(__superior.clusterName);
            }
            this.status(__superior.status);
            this.clusters(__superior.clusters);
            if (__superior.windowSizeIncrement != null) {
                this.windowSizeIncrement(__superior.windowSizeIncrement);
            }
            return this;
        }

        public Builder enabled(boolean __value) {
            this.enabled = __value;
            return this;
        }

        private Builder enabled(String __value) {
            return this.enabled(Boolean.valueOf(__value));
        }

        public Builder clusterName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clusterName = __value;
            return this;
        }

        public Builder status(String __key, Status.Builder __value) {
            this.status.put(__key, __value);
            return this;
        }

        public Builder status(Map<String, Status.Builder> __values) {
            this.status.putAll(__values);
            return this;
        }

        public Builder clusters(String __key, Clusters.Builder __value) {
            this.clusters.put(__key, __value);
            return this;
        }

        public Builder clusters(Map<String, Clusters.Builder> __values) {
            this.clusters.putAll(__values);
            return this;
        }

        public Builder windowSizeIncrement(double __value) {
            this.windowSizeIncrement = __value;
            return this;
        }

        private Builder windowSizeIncrement(String __value) {
            return this.windowSizeIncrement(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ReindexingConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ReindexingConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ReindexingConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ReindexingConfig build() {
            return new ReindexingConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

