/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorFilestorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b6c24eaf79dfe4b84ef70010ed4b84ec";
    public static final String CONFIG_DEF_NAME = "stor-filestor";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "fail_disk_after_error_count int default=1 restart", "disk_operation_timeout int default=0 restart", "num_threads int default=8 restart", "num_response_threads int default=2 restart", "num_network_threads int default=1 restart", "response_sequencer_type enum {LATENCY, THROUGHPUT, ADAPTIVE} default=ADAPTIVE restart", "common_merge_chain_optimalization_minimum_size int default=64 restart", "bucket_merge_chunk_size int default=4190208 restart", "enable_merge_local_node_choose_docs_optimalization bool default=true restart", "enable_multibit_split_optimalization bool default=true restart", "use_async_message_handling_on_schedule bool default=false restart"};
    private final IntegerNode fail_disk_after_error_count;
    private final IntegerNode disk_operation_timeout;
    private final IntegerNode num_threads;
    private final IntegerNode num_response_threads;
    private final IntegerNode num_network_threads;
    private final Response_sequencer_type response_sequencer_type;
    private final IntegerNode common_merge_chain_optimalization_minimum_size;
    private final IntegerNode bucket_merge_chunk_size;
    private final BooleanNode enable_merge_local_node_choose_docs_optimalization;
    private final BooleanNode enable_multibit_split_optimalization;
    private final BooleanNode use_async_message_handling_on_schedule;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorFilestorConfig(Builder builder) {
        this(builder, true);
    }

    private StorFilestorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-filestor must be initialized: " + builder.__uninitialized);
        }
        this.fail_disk_after_error_count = builder.fail_disk_after_error_count == null ? new IntegerNode(1) : new IntegerNode(builder.fail_disk_after_error_count.intValue());
        this.disk_operation_timeout = builder.disk_operation_timeout == null ? new IntegerNode(0) : new IntegerNode(builder.disk_operation_timeout.intValue());
        this.num_threads = builder.num_threads == null ? new IntegerNode(8) : new IntegerNode(builder.num_threads.intValue());
        this.num_response_threads = builder.num_response_threads == null ? new IntegerNode(2) : new IntegerNode(builder.num_response_threads.intValue());
        this.num_network_threads = builder.num_network_threads == null ? new IntegerNode(1) : new IntegerNode(builder.num_network_threads.intValue());
        this.response_sequencer_type = builder.response_sequencer_type == null ? new Response_sequencer_type(Response_sequencer_type.ADAPTIVE) : new Response_sequencer_type(builder.response_sequencer_type);
        this.common_merge_chain_optimalization_minimum_size = builder.common_merge_chain_optimalization_minimum_size == null ? new IntegerNode(64) : new IntegerNode(builder.common_merge_chain_optimalization_minimum_size.intValue());
        this.bucket_merge_chunk_size = builder.bucket_merge_chunk_size == null ? new IntegerNode(0x3FF000) : new IntegerNode(builder.bucket_merge_chunk_size.intValue());
        this.enable_merge_local_node_choose_docs_optimalization = builder.enable_merge_local_node_choose_docs_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_merge_local_node_choose_docs_optimalization.booleanValue());
        this.enable_multibit_split_optimalization = builder.enable_multibit_split_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_multibit_split_optimalization.booleanValue());
        this.use_async_message_handling_on_schedule = builder.use_async_message_handling_on_schedule == null ? new BooleanNode(false) : new BooleanNode(builder.use_async_message_handling_on_schedule.booleanValue());
    }

    public int fail_disk_after_error_count() {
        return this.fail_disk_after_error_count.value();
    }

    public int disk_operation_timeout() {
        return this.disk_operation_timeout.value();
    }

    public int num_threads() {
        return this.num_threads.value();
    }

    public int num_response_threads() {
        return this.num_response_threads.value();
    }

    public int num_network_threads() {
        return this.num_network_threads.value();
    }

    public Response_sequencer_type.Enum response_sequencer_type() {
        return (Response_sequencer_type.Enum)((Object)this.response_sequencer_type.value());
    }

    public int common_merge_chain_optimalization_minimum_size() {
        return this.common_merge_chain_optimalization_minimum_size.value();
    }

    public int bucket_merge_chunk_size() {
        return this.bucket_merge_chunk_size.value();
    }

    public boolean enable_merge_local_node_choose_docs_optimalization() {
        return this.enable_merge_local_node_choose_docs_optimalization.value();
    }

    public boolean enable_multibit_split_optimalization() {
        return this.enable_multibit_split_optimalization.value();
    }

    public boolean use_async_message_handling_on_schedule() {
        return this.use_async_message_handling_on_schedule.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorFilestorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.fail_disk_after_error_count, (Node)newConfig.fail_disk_after_error_count, "fail_disk_after_error_count", "DETECT FAILURE PARAMETERS\n\nAfter seeing given number of errors on a disk, storage will disable the\ndisk and restart. If set to 0, storage will never disable disks. Note\nthat if you get disk errors, which arent automatically fixed, this will\nmake storage keep failing all operations towards this disk, and all\nretries will use the same disk and same file, so you might end up with a\nlot of operations that can never succeed. Thus, it is not recommended to\nturn this off.");
        changes.compare((Node)this.disk_operation_timeout, (Node)newConfig.disk_operation_timeout, "disk_operation_timeout", "If a disk operation takes more time in seconds than the disk operation\ntimeout, storage will consider that a disk failure, and mark the disk\nbad, restart and not use the disk anymore. Note that currently, this\nincludes CPU time too, so if used, this parameter should be set fairly\nhigh as we still sometimes have some operations that might take a few\nseconds. Disabled by default as we currently have these long operations\nduring normal load.");
        changes.compare((Node)this.num_threads, (Node)newConfig.num_threads, "num_threads", "PERFORMANCE PARAMETERS\n\nNumber of threads to use for each mountpoint.");
        changes.compare((Node)this.num_response_threads, (Node)newConfig.num_response_threads, "num_response_threads", "Number of threads for response processing and delivery\n0 will give legacy sync behavior.\nNegative number will choose a good number based on # cores.");
        changes.compare((Node)this.num_network_threads, (Node)newConfig.num_network_threads, "num_network_threads", "Number of handler objects that might be created by networkthreads\nThis is a temporary setting that only skilled vespa developers should modify\nThis must be kept in line with stor-communicationmanager:rpc.num_network_threads");
        changes.compare((Node)this.response_sequencer_type, (Node)newConfig.response_sequencer_type, "response_sequencer_type", "Type of sequenced thread executor use for persistence replies.");
        changes.compare((Node)this.common_merge_chain_optimalization_minimum_size, (Node)newConfig.common_merge_chain_optimalization_minimum_size, "common_merge_chain_optimalization_minimum_size", "When merging, if we find more than this number of documents that exist on all\nof the same copies, send a separate apply bucket diff with these entries\nto an optimized merge chain that guarantuees minimum data transfer.");
        changes.compare((Node)this.bucket_merge_chunk_size, (Node)newConfig.bucket_merge_chunk_size, "bucket_merge_chunk_size", "Chunksize to use while merging buckets between nodes.\n \nDefault is set to 4 MB.\nNote that this will gradually be increased to reach stor-distributormanager:splitsize which is currently at 32M");
        changes.compare((Node)this.enable_merge_local_node_choose_docs_optimalization, (Node)newConfig.enable_merge_local_node_choose_docs_optimalization, "enable_merge_local_node_choose_docs_optimalization", "When merging, it is possible to send more metadata than needed in order to\nlet local nodes in merge decide which entries fits best to add this time\nbased on disk location. Toggle this option on to use it. Note that memory\nconsumption might increase in a 4.1 to 4.2 upgrade due to this, as 4.1\ndont support to only fill in part of the metadata provided and will always\nfill all.\nNB unused and will be removed shortly.");
        changes.compare((Node)this.enable_multibit_split_optimalization, (Node)newConfig.enable_multibit_split_optimalization, "enable_multibit_split_optimalization", "Whether or not to enable the multibit split optimalization. This is useful\nif splitting is expensive, but listing document identifiers is fairly cheap.\nThis is true for memfile persistence layer, but not for vespa search.");
        changes.compare((Node)this.use_async_message_handling_on_schedule, (Node)newConfig.use_async_message_handling_on_schedule, "use_async_message_handling_on_schedule", "Whether or not to use async message handling when scheduling storage messages from FileStorManager.\n \nWhen turned on, the calling thread (e.g. FNET network thread when using Storage API RPC)\ngets the next async message to handle (if any) as part of scheduling a storage message.\nThis async message is then handled by the calling thread immediately,\ninstead of going via a persistence thread.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Response_sequencer_type
    extends EnumNode<Enum> {
        public static final Enum LATENCY = Enum.LATENCY;
        public static final Enum THROUGHPUT = Enum.THROUGHPUT;
        public static final Enum ADAPTIVE = Enum.ADAPTIVE;

        public Response_sequencer_type() {
            this.value = null;
        }

        public Response_sequencer_type(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            LATENCY,
            THROUGHPUT,
            ADAPTIVE;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer fail_disk_after_error_count = null;
        private Integer disk_operation_timeout = null;
        private Integer num_threads = null;
        private Integer num_response_threads = null;
        private Integer num_network_threads = null;
        private Response_sequencer_type.Enum response_sequencer_type = null;
        private Integer common_merge_chain_optimalization_minimum_size = null;
        private Integer bucket_merge_chunk_size = null;
        private Boolean enable_merge_local_node_choose_docs_optimalization = null;
        private Boolean enable_multibit_split_optimalization = null;
        private Boolean use_async_message_handling_on_schedule = null;

        public Builder() {
        }

        public Builder(StorFilestorConfig config) {
            this.fail_disk_after_error_count(config.fail_disk_after_error_count());
            this.disk_operation_timeout(config.disk_operation_timeout());
            this.num_threads(config.num_threads());
            this.num_response_threads(config.num_response_threads());
            this.num_network_threads(config.num_network_threads());
            this.response_sequencer_type(config.response_sequencer_type());
            this.common_merge_chain_optimalization_minimum_size(config.common_merge_chain_optimalization_minimum_size());
            this.bucket_merge_chunk_size(config.bucket_merge_chunk_size());
            this.enable_merge_local_node_choose_docs_optimalization(config.enable_merge_local_node_choose_docs_optimalization());
            this.enable_multibit_split_optimalization(config.enable_multibit_split_optimalization());
            this.use_async_message_handling_on_schedule(config.use_async_message_handling_on_schedule());
        }

        private Builder override(Builder __superior) {
            if (__superior.fail_disk_after_error_count != null) {
                this.fail_disk_after_error_count(__superior.fail_disk_after_error_count);
            }
            if (__superior.disk_operation_timeout != null) {
                this.disk_operation_timeout(__superior.disk_operation_timeout);
            }
            if (__superior.num_threads != null) {
                this.num_threads(__superior.num_threads);
            }
            if (__superior.num_response_threads != null) {
                this.num_response_threads(__superior.num_response_threads);
            }
            if (__superior.num_network_threads != null) {
                this.num_network_threads(__superior.num_network_threads);
            }
            if (__superior.response_sequencer_type != null) {
                this.response_sequencer_type(__superior.response_sequencer_type);
            }
            if (__superior.common_merge_chain_optimalization_minimum_size != null) {
                this.common_merge_chain_optimalization_minimum_size(__superior.common_merge_chain_optimalization_minimum_size);
            }
            if (__superior.bucket_merge_chunk_size != null) {
                this.bucket_merge_chunk_size(__superior.bucket_merge_chunk_size);
            }
            if (__superior.enable_merge_local_node_choose_docs_optimalization != null) {
                this.enable_merge_local_node_choose_docs_optimalization(__superior.enable_merge_local_node_choose_docs_optimalization);
            }
            if (__superior.enable_multibit_split_optimalization != null) {
                this.enable_multibit_split_optimalization(__superior.enable_multibit_split_optimalization);
            }
            if (__superior.use_async_message_handling_on_schedule != null) {
                this.use_async_message_handling_on_schedule(__superior.use_async_message_handling_on_schedule);
            }
            return this;
        }

        public Builder fail_disk_after_error_count(int __value) {
            this.fail_disk_after_error_count = __value;
            return this;
        }

        private Builder fail_disk_after_error_count(String __value) {
            return this.fail_disk_after_error_count(Integer.valueOf(__value));
        }

        public Builder disk_operation_timeout(int __value) {
            this.disk_operation_timeout = __value;
            return this;
        }

        private Builder disk_operation_timeout(String __value) {
            return this.disk_operation_timeout(Integer.valueOf(__value));
        }

        public Builder num_threads(int __value) {
            this.num_threads = __value;
            return this;
        }

        private Builder num_threads(String __value) {
            return this.num_threads(Integer.valueOf(__value));
        }

        public Builder num_response_threads(int __value) {
            this.num_response_threads = __value;
            return this;
        }

        private Builder num_response_threads(String __value) {
            return this.num_response_threads(Integer.valueOf(__value));
        }

        public Builder num_network_threads(int __value) {
            this.num_network_threads = __value;
            return this;
        }

        private Builder num_network_threads(String __value) {
            return this.num_network_threads(Integer.valueOf(__value));
        }

        public Builder response_sequencer_type(Response_sequencer_type.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.response_sequencer_type = __value;
            return this;
        }

        private Builder response_sequencer_type(String __value) {
            return this.response_sequencer_type(Response_sequencer_type.Enum.valueOf(__value));
        }

        public Builder common_merge_chain_optimalization_minimum_size(int __value) {
            this.common_merge_chain_optimalization_minimum_size = __value;
            return this;
        }

        private Builder common_merge_chain_optimalization_minimum_size(String __value) {
            return this.common_merge_chain_optimalization_minimum_size(Integer.valueOf(__value));
        }

        public Builder bucket_merge_chunk_size(int __value) {
            this.bucket_merge_chunk_size = __value;
            return this;
        }

        private Builder bucket_merge_chunk_size(String __value) {
            return this.bucket_merge_chunk_size(Integer.valueOf(__value));
        }

        public Builder enable_merge_local_node_choose_docs_optimalization(boolean __value) {
            this.enable_merge_local_node_choose_docs_optimalization = __value;
            return this;
        }

        private Builder enable_merge_local_node_choose_docs_optimalization(String __value) {
            return this.enable_merge_local_node_choose_docs_optimalization(Boolean.valueOf(__value));
        }

        public Builder enable_multibit_split_optimalization(boolean __value) {
            this.enable_multibit_split_optimalization = __value;
            return this;
        }

        private Builder enable_multibit_split_optimalization(String __value) {
            return this.enable_multibit_split_optimalization(Boolean.valueOf(__value));
        }

        public Builder use_async_message_handling_on_schedule(boolean __value) {
            this.use_async_message_handling_on_schedule = __value;
            return this;
        }

        private Builder use_async_message_handling_on_schedule(String __value) {
            return this.use_async_message_handling_on_schedule(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorFilestorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorFilestorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorFilestorConfig.CONFIG_DEF_NAMESPACE;
        }

        public StorFilestorConfig build() {
            return new StorFilestorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

