/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FleetcontrollerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "837b2a3ba0eeefb822df0c864d11cb82";
    public static final String CONFIG_DEF_NAME = "fleetcontroller";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "cluster_name string restart", "index int restart", "fleet_controller_count int default=1", "zookeeper_session_timeout double default=30.0", "master_zookeeper_cooldown_period double default=60.0", "state_gather_count int default=2", "zookeeper_server string restart", "rpc_port int default=6500 restart", "http_port int default=0 restart", "storage_transition_time int default=30000", "distributor_transition_time int default=0", "init_progress_time int default=0", "min_time_between_new_systemstates int default=10000", "state_polling_frequency int default=5000", "max_premature_crashes int default=100000", "stable_state_time_period int default=7200000", "event_log_max_size int default=1024", "event_node_log_max_size int default=1024", "total_distributor_count int default=0", "total_storage_count int default=0", "min_distributors_up_count int default=1", "min_storage_up_count int default=1", "min_distributor_up_ratio double default=0.01", "min_storage_up_ratio double default=0.01", "cycle_wait_time double default=0.1", "min_time_before_first_system_state_broadcast double default=5.0", "get_node_state_request_timeout double default=120.0", "max_slobrok_disconnect_grace_period double default=60.0", "show_local_systemstates_in_event_log bool default=true", "ideal_distribution_bits int default=16", "min_node_ratio_per_group double default=0.0", "max_deferred_task_version_wait_time_sec double default=30.0", "cluster_has_global_document_types bool default=false", "min_merge_completion_ratio double default=1.0"};
    private final StringNode cluster_name;
    private final IntegerNode index;
    private final IntegerNode fleet_controller_count;
    private final DoubleNode zookeeper_session_timeout;
    private final DoubleNode master_zookeeper_cooldown_period;
    private final IntegerNode state_gather_count;
    private final StringNode zookeeper_server;
    private final IntegerNode rpc_port;
    private final IntegerNode http_port;
    private final IntegerNode storage_transition_time;
    private final IntegerNode distributor_transition_time;
    private final IntegerNode init_progress_time;
    private final IntegerNode min_time_between_new_systemstates;
    private final IntegerNode state_polling_frequency;
    private final IntegerNode max_premature_crashes;
    private final IntegerNode stable_state_time_period;
    private final IntegerNode event_log_max_size;
    private final IntegerNode event_node_log_max_size;
    private final IntegerNode total_distributor_count;
    private final IntegerNode total_storage_count;
    private final IntegerNode min_distributors_up_count;
    private final IntegerNode min_storage_up_count;
    private final DoubleNode min_distributor_up_ratio;
    private final DoubleNode min_storage_up_ratio;
    private final DoubleNode cycle_wait_time;
    private final DoubleNode min_time_before_first_system_state_broadcast;
    private final DoubleNode get_node_state_request_timeout;
    private final DoubleNode max_slobrok_disconnect_grace_period;
    private final BooleanNode show_local_systemstates_in_event_log;
    private final IntegerNode ideal_distribution_bits;
    private final DoubleNode min_node_ratio_per_group;
    private final DoubleNode max_deferred_task_version_wait_time_sec;
    private final BooleanNode cluster_has_global_document_types;
    private final DoubleNode min_merge_completion_ratio;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public FleetcontrollerConfig(Builder builder) {
        this(builder, true);
    }

    private FleetcontrollerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for fleetcontroller must be initialized: " + builder.__uninitialized);
        }
        this.cluster_name = builder.cluster_name == null ? new StringNode() : new StringNode(builder.cluster_name);
        this.index = builder.index == null ? new IntegerNode() : new IntegerNode(builder.index.intValue());
        this.fleet_controller_count = builder.fleet_controller_count == null ? new IntegerNode(1) : new IntegerNode(builder.fleet_controller_count.intValue());
        this.zookeeper_session_timeout = builder.zookeeper_session_timeout == null ? new DoubleNode(30.0) : new DoubleNode(builder.zookeeper_session_timeout.doubleValue());
        this.master_zookeeper_cooldown_period = builder.master_zookeeper_cooldown_period == null ? new DoubleNode(60.0) : new DoubleNode(builder.master_zookeeper_cooldown_period.doubleValue());
        this.state_gather_count = builder.state_gather_count == null ? new IntegerNode(2) : new IntegerNode(builder.state_gather_count.intValue());
        this.zookeeper_server = builder.zookeeper_server == null ? new StringNode() : new StringNode(builder.zookeeper_server);
        this.rpc_port = builder.rpc_port == null ? new IntegerNode(6500) : new IntegerNode(builder.rpc_port.intValue());
        this.http_port = builder.http_port == null ? new IntegerNode(0) : new IntegerNode(builder.http_port.intValue());
        this.storage_transition_time = builder.storage_transition_time == null ? new IntegerNode(30000) : new IntegerNode(builder.storage_transition_time.intValue());
        this.distributor_transition_time = builder.distributor_transition_time == null ? new IntegerNode(0) : new IntegerNode(builder.distributor_transition_time.intValue());
        this.init_progress_time = builder.init_progress_time == null ? new IntegerNode(0) : new IntegerNode(builder.init_progress_time.intValue());
        this.min_time_between_new_systemstates = builder.min_time_between_new_systemstates == null ? new IntegerNode(10000) : new IntegerNode(builder.min_time_between_new_systemstates.intValue());
        this.state_polling_frequency = builder.state_polling_frequency == null ? new IntegerNode(5000) : new IntegerNode(builder.state_polling_frequency.intValue());
        this.max_premature_crashes = builder.max_premature_crashes == null ? new IntegerNode(100000) : new IntegerNode(builder.max_premature_crashes.intValue());
        this.stable_state_time_period = builder.stable_state_time_period == null ? new IntegerNode(0x6DDD00) : new IntegerNode(builder.stable_state_time_period.intValue());
        this.event_log_max_size = builder.event_log_max_size == null ? new IntegerNode(1024) : new IntegerNode(builder.event_log_max_size.intValue());
        this.event_node_log_max_size = builder.event_node_log_max_size == null ? new IntegerNode(1024) : new IntegerNode(builder.event_node_log_max_size.intValue());
        this.total_distributor_count = builder.total_distributor_count == null ? new IntegerNode(0) : new IntegerNode(builder.total_distributor_count.intValue());
        this.total_storage_count = builder.total_storage_count == null ? new IntegerNode(0) : new IntegerNode(builder.total_storage_count.intValue());
        this.min_distributors_up_count = builder.min_distributors_up_count == null ? new IntegerNode(1) : new IntegerNode(builder.min_distributors_up_count.intValue());
        this.min_storage_up_count = builder.min_storage_up_count == null ? new IntegerNode(1) : new IntegerNode(builder.min_storage_up_count.intValue());
        this.min_distributor_up_ratio = builder.min_distributor_up_ratio == null ? new DoubleNode(0.01) : new DoubleNode(builder.min_distributor_up_ratio.doubleValue());
        this.min_storage_up_ratio = builder.min_storage_up_ratio == null ? new DoubleNode(0.01) : new DoubleNode(builder.min_storage_up_ratio.doubleValue());
        this.cycle_wait_time = builder.cycle_wait_time == null ? new DoubleNode(0.1) : new DoubleNode(builder.cycle_wait_time.doubleValue());
        this.min_time_before_first_system_state_broadcast = builder.min_time_before_first_system_state_broadcast == null ? new DoubleNode(5.0) : new DoubleNode(builder.min_time_before_first_system_state_broadcast.doubleValue());
        this.get_node_state_request_timeout = builder.get_node_state_request_timeout == null ? new DoubleNode(120.0) : new DoubleNode(builder.get_node_state_request_timeout.doubleValue());
        this.max_slobrok_disconnect_grace_period = builder.max_slobrok_disconnect_grace_period == null ? new DoubleNode(60.0) : new DoubleNode(builder.max_slobrok_disconnect_grace_period.doubleValue());
        this.show_local_systemstates_in_event_log = builder.show_local_systemstates_in_event_log == null ? new BooleanNode(true) : new BooleanNode(builder.show_local_systemstates_in_event_log.booleanValue());
        this.ideal_distribution_bits = builder.ideal_distribution_bits == null ? new IntegerNode(16) : new IntegerNode(builder.ideal_distribution_bits.intValue());
        this.min_node_ratio_per_group = builder.min_node_ratio_per_group == null ? new DoubleNode(0.0) : new DoubleNode(builder.min_node_ratio_per_group.doubleValue());
        this.max_deferred_task_version_wait_time_sec = builder.max_deferred_task_version_wait_time_sec == null ? new DoubleNode(30.0) : new DoubleNode(builder.max_deferred_task_version_wait_time_sec.doubleValue());
        this.cluster_has_global_document_types = builder.cluster_has_global_document_types == null ? new BooleanNode(false) : new BooleanNode(builder.cluster_has_global_document_types.booleanValue());
        this.min_merge_completion_ratio = builder.min_merge_completion_ratio == null ? new DoubleNode(1.0) : new DoubleNode(builder.min_merge_completion_ratio.doubleValue());
    }

    public String cluster_name() {
        return this.cluster_name.value();
    }

    public int index() {
        return this.index.value();
    }

    public int fleet_controller_count() {
        return this.fleet_controller_count.value();
    }

    public double zookeeper_session_timeout() {
        return this.zookeeper_session_timeout.value();
    }

    public double master_zookeeper_cooldown_period() {
        return this.master_zookeeper_cooldown_period.value();
    }

    public int state_gather_count() {
        return this.state_gather_count.value();
    }

    public String zookeeper_server() {
        return this.zookeeper_server.value();
    }

    public int rpc_port() {
        return this.rpc_port.value();
    }

    public int http_port() {
        return this.http_port.value();
    }

    public int storage_transition_time() {
        return this.storage_transition_time.value();
    }

    public int distributor_transition_time() {
        return this.distributor_transition_time.value();
    }

    public int init_progress_time() {
        return this.init_progress_time.value();
    }

    public int min_time_between_new_systemstates() {
        return this.min_time_between_new_systemstates.value();
    }

    public int state_polling_frequency() {
        return this.state_polling_frequency.value();
    }

    public int max_premature_crashes() {
        return this.max_premature_crashes.value();
    }

    public int stable_state_time_period() {
        return this.stable_state_time_period.value();
    }

    public int event_log_max_size() {
        return this.event_log_max_size.value();
    }

    public int event_node_log_max_size() {
        return this.event_node_log_max_size.value();
    }

    public int total_distributor_count() {
        return this.total_distributor_count.value();
    }

    public int total_storage_count() {
        return this.total_storage_count.value();
    }

    public int min_distributors_up_count() {
        return this.min_distributors_up_count.value();
    }

    public int min_storage_up_count() {
        return this.min_storage_up_count.value();
    }

    public double min_distributor_up_ratio() {
        return this.min_distributor_up_ratio.value();
    }

    public double min_storage_up_ratio() {
        return this.min_storage_up_ratio.value();
    }

    public double cycle_wait_time() {
        return this.cycle_wait_time.value();
    }

    public double min_time_before_first_system_state_broadcast() {
        return this.min_time_before_first_system_state_broadcast.value();
    }

    public double get_node_state_request_timeout() {
        return this.get_node_state_request_timeout.value();
    }

    public double max_slobrok_disconnect_grace_period() {
        return this.max_slobrok_disconnect_grace_period.value();
    }

    public boolean show_local_systemstates_in_event_log() {
        return this.show_local_systemstates_in_event_log.value();
    }

    public int ideal_distribution_bits() {
        return this.ideal_distribution_bits.value();
    }

    public double min_node_ratio_per_group() {
        return this.min_node_ratio_per_group.value();
    }

    public double max_deferred_task_version_wait_time_sec() {
        return this.max_deferred_task_version_wait_time_sec.value();
    }

    public boolean cluster_has_global_document_types() {
        return this.cluster_has_global_document_types.value();
    }

    public double min_merge_completion_ratio() {
        return this.min_merge_completion_ratio.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FleetcontrollerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.cluster_name, (Node)newConfig.cluster_name, "cluster_name", "Name of VDS cluster");
        changes.compare((Node)this.index, (Node)newConfig.index, "index", "The fleetcontroller index. Each fleetcontroller should have a unique index\nwhich can be used to identify them.");
        changes.compare((Node)this.zookeeper_server, (Node)newConfig.zookeeper_server, "zookeeper_server", "Location of ZooKeeper servers");
        changes.compare((Node)this.rpc_port, (Node)newConfig.rpc_port, "rpc_port", "RPC Port used by fleetcontroller");
        changes.compare((Node)this.http_port, (Node)newConfig.http_port, "http_port", "Port where fleetcontroller listens for HTTP status request");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("cluster_name", "index", "zookeeper_server"));
        private String cluster_name = null;
        private Integer index = null;
        private Integer fleet_controller_count = null;
        private Double zookeeper_session_timeout = null;
        private Double master_zookeeper_cooldown_period = null;
        private Integer state_gather_count = null;
        private String zookeeper_server = null;
        private Integer rpc_port = null;
        private Integer http_port = null;
        private Integer storage_transition_time = null;
        private Integer distributor_transition_time = null;
        private Integer init_progress_time = null;
        private Integer min_time_between_new_systemstates = null;
        private Integer state_polling_frequency = null;
        private Integer max_premature_crashes = null;
        private Integer stable_state_time_period = null;
        private Integer event_log_max_size = null;
        private Integer event_node_log_max_size = null;
        private Integer total_distributor_count = null;
        private Integer total_storage_count = null;
        private Integer min_distributors_up_count = null;
        private Integer min_storage_up_count = null;
        private Double min_distributor_up_ratio = null;
        private Double min_storage_up_ratio = null;
        private Double cycle_wait_time = null;
        private Double min_time_before_first_system_state_broadcast = null;
        private Double get_node_state_request_timeout = null;
        private Double max_slobrok_disconnect_grace_period = null;
        private Boolean show_local_systemstates_in_event_log = null;
        private Integer ideal_distribution_bits = null;
        private Double min_node_ratio_per_group = null;
        private Double max_deferred_task_version_wait_time_sec = null;
        private Boolean cluster_has_global_document_types = null;
        private Double min_merge_completion_ratio = null;

        public Builder() {
        }

        public Builder(FleetcontrollerConfig config) {
            this.cluster_name(config.cluster_name());
            this.index(config.index());
            this.fleet_controller_count(config.fleet_controller_count());
            this.zookeeper_session_timeout(config.zookeeper_session_timeout());
            this.master_zookeeper_cooldown_period(config.master_zookeeper_cooldown_period());
            this.state_gather_count(config.state_gather_count());
            this.zookeeper_server(config.zookeeper_server());
            this.rpc_port(config.rpc_port());
            this.http_port(config.http_port());
            this.storage_transition_time(config.storage_transition_time());
            this.distributor_transition_time(config.distributor_transition_time());
            this.init_progress_time(config.init_progress_time());
            this.min_time_between_new_systemstates(config.min_time_between_new_systemstates());
            this.state_polling_frequency(config.state_polling_frequency());
            this.max_premature_crashes(config.max_premature_crashes());
            this.stable_state_time_period(config.stable_state_time_period());
            this.event_log_max_size(config.event_log_max_size());
            this.event_node_log_max_size(config.event_node_log_max_size());
            this.total_distributor_count(config.total_distributor_count());
            this.total_storage_count(config.total_storage_count());
            this.min_distributors_up_count(config.min_distributors_up_count());
            this.min_storage_up_count(config.min_storage_up_count());
            this.min_distributor_up_ratio(config.min_distributor_up_ratio());
            this.min_storage_up_ratio(config.min_storage_up_ratio());
            this.cycle_wait_time(config.cycle_wait_time());
            this.min_time_before_first_system_state_broadcast(config.min_time_before_first_system_state_broadcast());
            this.get_node_state_request_timeout(config.get_node_state_request_timeout());
            this.max_slobrok_disconnect_grace_period(config.max_slobrok_disconnect_grace_period());
            this.show_local_systemstates_in_event_log(config.show_local_systemstates_in_event_log());
            this.ideal_distribution_bits(config.ideal_distribution_bits());
            this.min_node_ratio_per_group(config.min_node_ratio_per_group());
            this.max_deferred_task_version_wait_time_sec(config.max_deferred_task_version_wait_time_sec());
            this.cluster_has_global_document_types(config.cluster_has_global_document_types());
            this.min_merge_completion_ratio(config.min_merge_completion_ratio());
        }

        private Builder override(Builder __superior) {
            if (__superior.cluster_name != null) {
                this.cluster_name(__superior.cluster_name);
            }
            if (__superior.index != null) {
                this.index(__superior.index);
            }
            if (__superior.fleet_controller_count != null) {
                this.fleet_controller_count(__superior.fleet_controller_count);
            }
            if (__superior.zookeeper_session_timeout != null) {
                this.zookeeper_session_timeout(__superior.zookeeper_session_timeout);
            }
            if (__superior.master_zookeeper_cooldown_period != null) {
                this.master_zookeeper_cooldown_period(__superior.master_zookeeper_cooldown_period);
            }
            if (__superior.state_gather_count != null) {
                this.state_gather_count(__superior.state_gather_count);
            }
            if (__superior.zookeeper_server != null) {
                this.zookeeper_server(__superior.zookeeper_server);
            }
            if (__superior.rpc_port != null) {
                this.rpc_port(__superior.rpc_port);
            }
            if (__superior.http_port != null) {
                this.http_port(__superior.http_port);
            }
            if (__superior.storage_transition_time != null) {
                this.storage_transition_time(__superior.storage_transition_time);
            }
            if (__superior.distributor_transition_time != null) {
                this.distributor_transition_time(__superior.distributor_transition_time);
            }
            if (__superior.init_progress_time != null) {
                this.init_progress_time(__superior.init_progress_time);
            }
            if (__superior.min_time_between_new_systemstates != null) {
                this.min_time_between_new_systemstates(__superior.min_time_between_new_systemstates);
            }
            if (__superior.state_polling_frequency != null) {
                this.state_polling_frequency(__superior.state_polling_frequency);
            }
            if (__superior.max_premature_crashes != null) {
                this.max_premature_crashes(__superior.max_premature_crashes);
            }
            if (__superior.stable_state_time_period != null) {
                this.stable_state_time_period(__superior.stable_state_time_period);
            }
            if (__superior.event_log_max_size != null) {
                this.event_log_max_size(__superior.event_log_max_size);
            }
            if (__superior.event_node_log_max_size != null) {
                this.event_node_log_max_size(__superior.event_node_log_max_size);
            }
            if (__superior.total_distributor_count != null) {
                this.total_distributor_count(__superior.total_distributor_count);
            }
            if (__superior.total_storage_count != null) {
                this.total_storage_count(__superior.total_storage_count);
            }
            if (__superior.min_distributors_up_count != null) {
                this.min_distributors_up_count(__superior.min_distributors_up_count);
            }
            if (__superior.min_storage_up_count != null) {
                this.min_storage_up_count(__superior.min_storage_up_count);
            }
            if (__superior.min_distributor_up_ratio != null) {
                this.min_distributor_up_ratio(__superior.min_distributor_up_ratio);
            }
            if (__superior.min_storage_up_ratio != null) {
                this.min_storage_up_ratio(__superior.min_storage_up_ratio);
            }
            if (__superior.cycle_wait_time != null) {
                this.cycle_wait_time(__superior.cycle_wait_time);
            }
            if (__superior.min_time_before_first_system_state_broadcast != null) {
                this.min_time_before_first_system_state_broadcast(__superior.min_time_before_first_system_state_broadcast);
            }
            if (__superior.get_node_state_request_timeout != null) {
                this.get_node_state_request_timeout(__superior.get_node_state_request_timeout);
            }
            if (__superior.max_slobrok_disconnect_grace_period != null) {
                this.max_slobrok_disconnect_grace_period(__superior.max_slobrok_disconnect_grace_period);
            }
            if (__superior.show_local_systemstates_in_event_log != null) {
                this.show_local_systemstates_in_event_log(__superior.show_local_systemstates_in_event_log);
            }
            if (__superior.ideal_distribution_bits != null) {
                this.ideal_distribution_bits(__superior.ideal_distribution_bits);
            }
            if (__superior.min_node_ratio_per_group != null) {
                this.min_node_ratio_per_group(__superior.min_node_ratio_per_group);
            }
            if (__superior.max_deferred_task_version_wait_time_sec != null) {
                this.max_deferred_task_version_wait_time_sec(__superior.max_deferred_task_version_wait_time_sec);
            }
            if (__superior.cluster_has_global_document_types != null) {
                this.cluster_has_global_document_types(__superior.cluster_has_global_document_types);
            }
            if (__superior.min_merge_completion_ratio != null) {
                this.min_merge_completion_ratio(__superior.min_merge_completion_ratio);
            }
            return this;
        }

        public Builder cluster_name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.cluster_name = __value;
            this.__uninitialized.remove("cluster_name");
            return this;
        }

        public Builder index(int __value) {
            this.index = __value;
            this.__uninitialized.remove("index");
            return this;
        }

        private Builder index(String __value) {
            return this.index(Integer.valueOf(__value));
        }

        public Builder fleet_controller_count(int __value) {
            this.fleet_controller_count = __value;
            return this;
        }

        private Builder fleet_controller_count(String __value) {
            return this.fleet_controller_count(Integer.valueOf(__value));
        }

        public Builder zookeeper_session_timeout(double __value) {
            this.zookeeper_session_timeout = __value;
            return this;
        }

        private Builder zookeeper_session_timeout(String __value) {
            return this.zookeeper_session_timeout(Double.valueOf(__value));
        }

        public Builder master_zookeeper_cooldown_period(double __value) {
            this.master_zookeeper_cooldown_period = __value;
            return this;
        }

        private Builder master_zookeeper_cooldown_period(String __value) {
            return this.master_zookeeper_cooldown_period(Double.valueOf(__value));
        }

        public Builder state_gather_count(int __value) {
            this.state_gather_count = __value;
            return this;
        }

        private Builder state_gather_count(String __value) {
            return this.state_gather_count(Integer.valueOf(__value));
        }

        public Builder zookeeper_server(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.zookeeper_server = __value;
            this.__uninitialized.remove("zookeeper_server");
            return this;
        }

        public Builder rpc_port(int __value) {
            this.rpc_port = __value;
            return this;
        }

        private Builder rpc_port(String __value) {
            return this.rpc_port(Integer.valueOf(__value));
        }

        public Builder http_port(int __value) {
            this.http_port = __value;
            return this;
        }

        private Builder http_port(String __value) {
            return this.http_port(Integer.valueOf(__value));
        }

        public Builder storage_transition_time(int __value) {
            this.storage_transition_time = __value;
            return this;
        }

        private Builder storage_transition_time(String __value) {
            return this.storage_transition_time(Integer.valueOf(__value));
        }

        public Builder distributor_transition_time(int __value) {
            this.distributor_transition_time = __value;
            return this;
        }

        private Builder distributor_transition_time(String __value) {
            return this.distributor_transition_time(Integer.valueOf(__value));
        }

        public Builder init_progress_time(int __value) {
            this.init_progress_time = __value;
            return this;
        }

        private Builder init_progress_time(String __value) {
            return this.init_progress_time(Integer.valueOf(__value));
        }

        public Builder min_time_between_new_systemstates(int __value) {
            this.min_time_between_new_systemstates = __value;
            return this;
        }

        private Builder min_time_between_new_systemstates(String __value) {
            return this.min_time_between_new_systemstates(Integer.valueOf(__value));
        }

        public Builder state_polling_frequency(int __value) {
            this.state_polling_frequency = __value;
            return this;
        }

        private Builder state_polling_frequency(String __value) {
            return this.state_polling_frequency(Integer.valueOf(__value));
        }

        public Builder max_premature_crashes(int __value) {
            this.max_premature_crashes = __value;
            return this;
        }

        private Builder max_premature_crashes(String __value) {
            return this.max_premature_crashes(Integer.valueOf(__value));
        }

        public Builder stable_state_time_period(int __value) {
            this.stable_state_time_period = __value;
            return this;
        }

        private Builder stable_state_time_period(String __value) {
            return this.stable_state_time_period(Integer.valueOf(__value));
        }

        public Builder event_log_max_size(int __value) {
            this.event_log_max_size = __value;
            return this;
        }

        private Builder event_log_max_size(String __value) {
            return this.event_log_max_size(Integer.valueOf(__value));
        }

        public Builder event_node_log_max_size(int __value) {
            this.event_node_log_max_size = __value;
            return this;
        }

        private Builder event_node_log_max_size(String __value) {
            return this.event_node_log_max_size(Integer.valueOf(__value));
        }

        public Builder total_distributor_count(int __value) {
            this.total_distributor_count = __value;
            return this;
        }

        private Builder total_distributor_count(String __value) {
            return this.total_distributor_count(Integer.valueOf(__value));
        }

        public Builder total_storage_count(int __value) {
            this.total_storage_count = __value;
            return this;
        }

        private Builder total_storage_count(String __value) {
            return this.total_storage_count(Integer.valueOf(__value));
        }

        public Builder min_distributors_up_count(int __value) {
            this.min_distributors_up_count = __value;
            return this;
        }

        private Builder min_distributors_up_count(String __value) {
            return this.min_distributors_up_count(Integer.valueOf(__value));
        }

        public Builder min_storage_up_count(int __value) {
            this.min_storage_up_count = __value;
            return this;
        }

        private Builder min_storage_up_count(String __value) {
            return this.min_storage_up_count(Integer.valueOf(__value));
        }

        public Builder min_distributor_up_ratio(double __value) {
            this.min_distributor_up_ratio = __value;
            return this;
        }

        private Builder min_distributor_up_ratio(String __value) {
            return this.min_distributor_up_ratio(Double.valueOf(__value));
        }

        public Builder min_storage_up_ratio(double __value) {
            this.min_storage_up_ratio = __value;
            return this;
        }

        private Builder min_storage_up_ratio(String __value) {
            return this.min_storage_up_ratio(Double.valueOf(__value));
        }

        public Builder cycle_wait_time(double __value) {
            this.cycle_wait_time = __value;
            return this;
        }

        private Builder cycle_wait_time(String __value) {
            return this.cycle_wait_time(Double.valueOf(__value));
        }

        public Builder min_time_before_first_system_state_broadcast(double __value) {
            this.min_time_before_first_system_state_broadcast = __value;
            return this;
        }

        private Builder min_time_before_first_system_state_broadcast(String __value) {
            return this.min_time_before_first_system_state_broadcast(Double.valueOf(__value));
        }

        public Builder get_node_state_request_timeout(double __value) {
            this.get_node_state_request_timeout = __value;
            return this;
        }

        private Builder get_node_state_request_timeout(String __value) {
            return this.get_node_state_request_timeout(Double.valueOf(__value));
        }

        public Builder max_slobrok_disconnect_grace_period(double __value) {
            this.max_slobrok_disconnect_grace_period = __value;
            return this;
        }

        private Builder max_slobrok_disconnect_grace_period(String __value) {
            return this.max_slobrok_disconnect_grace_period(Double.valueOf(__value));
        }

        public Builder show_local_systemstates_in_event_log(boolean __value) {
            this.show_local_systemstates_in_event_log = __value;
            return this;
        }

        private Builder show_local_systemstates_in_event_log(String __value) {
            return this.show_local_systemstates_in_event_log(Boolean.valueOf(__value));
        }

        public Builder ideal_distribution_bits(int __value) {
            this.ideal_distribution_bits = __value;
            return this;
        }

        private Builder ideal_distribution_bits(String __value) {
            return this.ideal_distribution_bits(Integer.valueOf(__value));
        }

        public Builder min_node_ratio_per_group(double __value) {
            this.min_node_ratio_per_group = __value;
            return this;
        }

        private Builder min_node_ratio_per_group(String __value) {
            return this.min_node_ratio_per_group(Double.valueOf(__value));
        }

        public Builder max_deferred_task_version_wait_time_sec(double __value) {
            this.max_deferred_task_version_wait_time_sec = __value;
            return this;
        }

        private Builder max_deferred_task_version_wait_time_sec(String __value) {
            return this.max_deferred_task_version_wait_time_sec(Double.valueOf(__value));
        }

        public Builder cluster_has_global_document_types(boolean __value) {
            this.cluster_has_global_document_types = __value;
            return this;
        }

        private Builder cluster_has_global_document_types(String __value) {
            return this.cluster_has_global_document_types(Boolean.valueOf(__value));
        }

        public Builder min_merge_completion_ratio(double __value) {
            this.min_merge_completion_ratio = __value;
            return this;
        }

        private Builder min_merge_completion_ratio(String __value) {
            return this.min_merge_completion_ratio(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return FleetcontrollerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return FleetcontrollerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return FleetcontrollerConfig.CONFIG_DEF_NAMESPACE;
        }

        public FleetcontrollerConfig build() {
            return new FleetcontrollerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

