/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DispatchConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "38e3ae73a97821635d09932e7d49d45e";
    public static final String CONFIG_DEF_NAME = "dispatch";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "minActivedocsPercentage double default=97.0", "minGroupCoverage double default=100", "maxNodesDownPerGroup int default=0", "distributionPolicy enum { ROUNDROBIN, ADAPTIVE } default=ROUNDROBIN", "useMultilevelDispatch bool default=false", "searchableCopies long default=1", "minSearchCoverage double default=100", "minWaitAfterCoverageFactor double default=0", "maxWaitAfterCoverageFactor double default=1", "node[].key int", "node[].group int default=0", "node[].host string", "node[].port int", "node[].fs4port int default=0"};
    private final DoubleNode minActivedocsPercentage;
    private final DoubleNode minGroupCoverage;
    private final IntegerNode maxNodesDownPerGroup;
    private final DistributionPolicy distributionPolicy;
    private final BooleanNode useMultilevelDispatch;
    private final LongNode searchableCopies;
    private final DoubleNode minSearchCoverage;
    private final DoubleNode minWaitAfterCoverageFactor;
    private final DoubleNode maxWaitAfterCoverageFactor;
    private final InnerNodeVector<Node> node;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public DispatchConfig(Builder builder) {
        this(builder, true);
    }

    private DispatchConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for dispatch must be initialized: " + builder.__uninitialized);
        }
        this.minActivedocsPercentage = builder.minActivedocsPercentage == null ? new DoubleNode(97.0) : new DoubleNode(builder.minActivedocsPercentage.doubleValue());
        this.minGroupCoverage = builder.minGroupCoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minGroupCoverage.doubleValue());
        this.maxNodesDownPerGroup = builder.maxNodesDownPerGroup == null ? new IntegerNode(0) : new IntegerNode(builder.maxNodesDownPerGroup.intValue());
        this.distributionPolicy = builder.distributionPolicy == null ? new DistributionPolicy(DistributionPolicy.ROUNDROBIN) : new DistributionPolicy(builder.distributionPolicy);
        this.useMultilevelDispatch = builder.useMultilevelDispatch == null ? new BooleanNode(false) : new BooleanNode(builder.useMultilevelDispatch.booleanValue());
        this.searchableCopies = builder.searchableCopies == null ? new LongNode(1L) : new LongNode(builder.searchableCopies.longValue());
        this.minSearchCoverage = builder.minSearchCoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minSearchCoverage.doubleValue());
        this.minWaitAfterCoverageFactor = builder.minWaitAfterCoverageFactor == null ? new DoubleNode(0.0) : new DoubleNode(builder.minWaitAfterCoverageFactor.doubleValue());
        this.maxWaitAfterCoverageFactor = builder.maxWaitAfterCoverageFactor == null ? new DoubleNode(1.0) : new DoubleNode(builder.maxWaitAfterCoverageFactor.doubleValue());
        this.node = Node.createVector(builder.node);
    }

    public double minActivedocsPercentage() {
        return this.minActivedocsPercentage.value();
    }

    public double minGroupCoverage() {
        return this.minGroupCoverage.value();
    }

    public int maxNodesDownPerGroup() {
        return this.maxNodesDownPerGroup.value();
    }

    public DistributionPolicy.Enum distributionPolicy() {
        return (DistributionPolicy.Enum)((Object)this.distributionPolicy.value());
    }

    public boolean useMultilevelDispatch() {
        return this.useMultilevelDispatch.value();
    }

    public long searchableCopies() {
        return this.searchableCopies.value();
    }

    public double minSearchCoverage() {
        return this.minSearchCoverage.value();
    }

    public double minWaitAfterCoverageFactor() {
        return this.minWaitAfterCoverageFactor.value();
    }

    public double maxWaitAfterCoverageFactor() {
        return this.maxWaitAfterCoverageFactor.value();
    }

    public List<Node> node() {
        return this.node;
    }

    public Node node(int i) {
        return (Node)((Object)this.node.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DispatchConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Node
    extends InnerNode {
        private final IntegerNode key;
        private final IntegerNode group;
        private final StringNode host;
        private final IntegerNode port;
        private final IntegerNode fs4port;

        public Node(Builder builder) {
            this(builder, true);
        }

        private Node(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for dispatch.node[] must be initialized: " + builder.__uninitialized);
            }
            this.key = builder.key == null ? new IntegerNode() : new IntegerNode(builder.key.intValue());
            this.group = builder.group == null ? new IntegerNode(0) : new IntegerNode(builder.group.intValue());
            this.host = builder.host == null ? new StringNode() : new StringNode(builder.host);
            this.port = builder.port == null ? new IntegerNode() : new IntegerNode(builder.port.intValue());
            this.fs4port = builder.fs4port == null ? new IntegerNode(0) : new IntegerNode(builder.fs4port.intValue());
        }

        public int key() {
            return this.key.value();
        }

        public int group() {
            return this.group.value();
        }

        public String host() {
            return this.host.value();
        }

        public int port() {
            return this.port.value();
        }

        public int fs4port() {
            return this.fs4port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
            return changes;
        }

        private static InnerNodeVector<Node> createVector(List<Builder> builders) {
            ArrayList<Node> elems = new ArrayList<Node>();
            for (Builder b : builders) {
                elems.add(new Node(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("key", "host", "port"));
            private Integer key = null;
            private Integer group = null;
            private String host = null;
            private Integer port = null;
            private Integer fs4port = null;

            public Builder() {
            }

            public Builder(Node config) {
                this.key(config.key());
                this.group(config.group());
                this.host(config.host());
                this.port(config.port());
                this.fs4port(config.fs4port());
            }

            private Builder override(Builder __superior) {
                if (__superior.key != null) {
                    this.key(__superior.key);
                }
                if (__superior.group != null) {
                    this.group(__superior.group);
                }
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (__superior.fs4port != null) {
                    this.fs4port(__superior.fs4port);
                }
                return this;
            }

            public Builder key(int __value) {
                this.key = __value;
                this.__uninitialized.remove("key");
                return this;
            }

            private Builder key(String __value) {
                return this.key(Integer.valueOf(__value));
            }

            public Builder group(int __value) {
                this.group = __value;
                return this;
            }

            private Builder group(String __value) {
                return this.group(Integer.valueOf(__value));
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                this.__uninitialized.remove("host");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                this.__uninitialized.remove("port");
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder fs4port(int __value) {
                this.fs4port = __value;
                return this;
            }

            private Builder fs4port(String __value) {
                return this.fs4port(Integer.valueOf(__value));
            }

            public Node build() {
                return new Node(this);
            }
        }
    }

    public static final class DistributionPolicy
    extends EnumNode<Enum> {
        public static final Enum ROUNDROBIN = Enum.ROUNDROBIN;
        public static final Enum ADAPTIVE = Enum.ADAPTIVE;

        public DistributionPolicy() {
            this.value = null;
        }

        public DistributionPolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ROUNDROBIN,
            ADAPTIVE;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Double minActivedocsPercentage = null;
        private Double minGroupCoverage = null;
        private Integer maxNodesDownPerGroup = null;
        private DistributionPolicy.Enum distributionPolicy = null;
        private Boolean useMultilevelDispatch = null;
        private Long searchableCopies = null;
        private Double minSearchCoverage = null;
        private Double minWaitAfterCoverageFactor = null;
        private Double maxWaitAfterCoverageFactor = null;
        public List<Node.Builder> node = new ArrayList<Node.Builder>();

        public Builder() {
        }

        public Builder(DispatchConfig config) {
            this.minActivedocsPercentage(config.minActivedocsPercentage());
            this.minGroupCoverage(config.minGroupCoverage());
            this.maxNodesDownPerGroup(config.maxNodesDownPerGroup());
            this.distributionPolicy(config.distributionPolicy());
            this.useMultilevelDispatch(config.useMultilevelDispatch());
            this.searchableCopies(config.searchableCopies());
            this.minSearchCoverage(config.minSearchCoverage());
            this.minWaitAfterCoverageFactor(config.minWaitAfterCoverageFactor());
            this.maxWaitAfterCoverageFactor(config.maxWaitAfterCoverageFactor());
            for (Node n : config.node()) {
                this.node(new Node.Builder(n));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.minActivedocsPercentage != null) {
                this.minActivedocsPercentage(__superior.minActivedocsPercentage);
            }
            if (__superior.minGroupCoverage != null) {
                this.minGroupCoverage(__superior.minGroupCoverage);
            }
            if (__superior.maxNodesDownPerGroup != null) {
                this.maxNodesDownPerGroup(__superior.maxNodesDownPerGroup);
            }
            if (__superior.distributionPolicy != null) {
                this.distributionPolicy(__superior.distributionPolicy);
            }
            if (__superior.useMultilevelDispatch != null) {
                this.useMultilevelDispatch(__superior.useMultilevelDispatch);
            }
            if (__superior.searchableCopies != null) {
                this.searchableCopies(__superior.searchableCopies);
            }
            if (__superior.minSearchCoverage != null) {
                this.minSearchCoverage(__superior.minSearchCoverage);
            }
            if (__superior.minWaitAfterCoverageFactor != null) {
                this.minWaitAfterCoverageFactor(__superior.minWaitAfterCoverageFactor);
            }
            if (__superior.maxWaitAfterCoverageFactor != null) {
                this.maxWaitAfterCoverageFactor(__superior.maxWaitAfterCoverageFactor);
            }
            if (!__superior.node.isEmpty()) {
                this.node.addAll(__superior.node);
            }
            return this;
        }

        public Builder minActivedocsPercentage(double __value) {
            this.minActivedocsPercentage = __value;
            return this;
        }

        private Builder minActivedocsPercentage(String __value) {
            return this.minActivedocsPercentage(Double.valueOf(__value));
        }

        public Builder minGroupCoverage(double __value) {
            this.minGroupCoverage = __value;
            return this;
        }

        private Builder minGroupCoverage(String __value) {
            return this.minGroupCoverage(Double.valueOf(__value));
        }

        public Builder maxNodesDownPerGroup(int __value) {
            this.maxNodesDownPerGroup = __value;
            return this;
        }

        private Builder maxNodesDownPerGroup(String __value) {
            return this.maxNodesDownPerGroup(Integer.valueOf(__value));
        }

        public Builder distributionPolicy(DistributionPolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.distributionPolicy = __value;
            return this;
        }

        private Builder distributionPolicy(String __value) {
            return this.distributionPolicy(DistributionPolicy.Enum.valueOf(__value));
        }

        public Builder useMultilevelDispatch(boolean __value) {
            this.useMultilevelDispatch = __value;
            return this;
        }

        private Builder useMultilevelDispatch(String __value) {
            return this.useMultilevelDispatch(Boolean.valueOf(__value));
        }

        public Builder searchableCopies(long __value) {
            this.searchableCopies = __value;
            return this;
        }

        private Builder searchableCopies(String __value) {
            return this.searchableCopies(Long.valueOf(__value));
        }

        public Builder minSearchCoverage(double __value) {
            this.minSearchCoverage = __value;
            return this;
        }

        private Builder minSearchCoverage(String __value) {
            return this.minSearchCoverage(Double.valueOf(__value));
        }

        public Builder minWaitAfterCoverageFactor(double __value) {
            this.minWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder minWaitAfterCoverageFactor(String __value) {
            return this.minWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder maxWaitAfterCoverageFactor(double __value) {
            this.maxWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder maxWaitAfterCoverageFactor(String __value) {
            return this.maxWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder node(Node.Builder __builder) {
            this.node.add(__builder);
            return this;
        }

        public Builder node(List<Node.Builder> __builders) {
            this.node = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DispatchConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DispatchConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DispatchConfig.CONFIG_DEF_NAMESPACE;
        }

        public DispatchConfig build() {
            return new DispatchConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

