/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LbServicesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "1d82ff5e30df99529b82e7df49e7fabf";
    public static final String CONFIG_DEF_NAME = "lb-services";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "tenants{}.applications{}.activeRotation bool default=true", "tenants{}.applications{}.hosts{}.hostname string default=\"(unknownhostname)\"", "tenants{}.applications{}.hosts{}.services{}.type string default=\"(noservicetype)\"", "tenants{}.applications{}.hosts{}.services{}.clustertype string default=\"(unknownclustertype)\"", "tenants{}.applications{}.hosts{}.services{}.clustername string default=\"(unknownclustername)\"", "tenants{}.applications{}.hosts{}.services{}.configId string", "tenants{}.applications{}.hosts{}.services{}.index int default=0", "tenants{}.applications{}.hosts{}.services{}.ports[].number int default=-1", "tenants{}.applications{}.hosts{}.services{}.ports[].tags string default=\"(notags)\"", "tenants{}.applications{}.hosts{}.services{}.servicealiases[] string", "tenants{}.applications{}.hosts{}.services{}.endpointaliases[] string"};
    private final Map<String, Tenants> tenants;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public LbServicesConfig(Builder builder) {
        this(builder, true);
    }

    private LbServicesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for lb-services must be initialized: " + builder.__uninitialized);
        }
        this.tenants = Tenants.createMap(builder.tenants);
    }

    public Map<String, Tenants> tenants() {
        return Collections.unmodifiableMap(this.tenants);
    }

    public Tenants tenants(String key) {
        return this.tenants.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LbServicesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Tenants
    extends InnerNode {
        private final Map<String, Applications> applications;

        public Tenants(Builder builder) {
            this(builder, true);
        }

        private Tenants(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{} must be initialized: " + builder.__uninitialized);
            }
            this.applications = Applications.createMap(builder.applications);
        }

        public Map<String, Applications> applications() {
            return Collections.unmodifiableMap(this.applications);
        }

        public Applications applications(String key) {
            return this.applications.get(key);
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Tenants newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("tenants");
            return changes;
        }

        private static Map<String, Tenants> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Tenants> ret = new LinkedHashMap<String, Tenants>();
            for (String key : builders.keySet()) {
                ret.put(key, new Tenants(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static final class Applications
        extends InnerNode {
            private final BooleanNode activeRotation;
            private final Map<String, Hosts> hosts;

            public Applications(Builder builder) {
                this(builder, true);
            }

            private Applications(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{} must be initialized: " + builder.__uninitialized);
                }
                this.activeRotation = builder.activeRotation == null ? new BooleanNode(true) : new BooleanNode(builder.activeRotation.booleanValue());
                this.hosts = Hosts.createMap(builder.hosts);
            }

            public boolean activeRotation() {
                return this.activeRotation.value();
            }

            public Map<String, Hosts> hosts() {
                return Collections.unmodifiableMap(this.hosts);
            }

            public Hosts hosts(String key) {
                return this.hosts.get(key);
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Applications newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("applications");
                return changes;
            }

            private static Map<String, Applications> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, Applications> ret = new LinkedHashMap<String, Applications>();
                for (String key : builders.keySet()) {
                    ret.put(key, new Applications(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static final class Hosts
            extends InnerNode {
                private final StringNode hostname;
                private final Map<String, Services> services;

                public Hosts(Builder builder) {
                    this(builder, true);
                }

                private Hosts(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{}.hosts{} must be initialized: " + builder.__uninitialized);
                    }
                    this.hostname = builder.hostname == null ? new StringNode("(unknownhostname)") : new StringNode(builder.hostname);
                    this.services = Services.createMap(builder.services);
                }

                public String hostname() {
                    return this.hostname.value();
                }

                public Map<String, Services> services() {
                    return Collections.unmodifiableMap(this.services);
                }

                public Services services(String key) {
                    return this.services.get(key);
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Hosts newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("hosts");
                    return changes;
                }

                private static Map<String, Hosts> createMap(Map<String, Builder> builders) {
                    LinkedHashMap<String, Hosts> ret = new LinkedHashMap<String, Hosts>();
                    for (String key : builders.keySet()) {
                        ret.put(key, new Hosts(builders.get(key)));
                    }
                    return Collections.unmodifiableMap(ret);
                }

                public static final class Services
                extends InnerNode {
                    private final StringNode type;
                    private final StringNode clustertype;
                    private final StringNode clustername;
                    private final StringNode configId;
                    private final IntegerNode index;
                    private final InnerNodeVector<Ports> ports;
                    private final LeafNodeVector<String, StringNode> servicealiases;
                    private final LeafNodeVector<String, StringNode> endpointaliases;

                    public Services(Builder builder) {
                        this(builder, true);
                    }

                    private Services(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{}.hosts{}.services{} must be initialized: " + builder.__uninitialized);
                        }
                        this.type = builder.type == null ? new StringNode("(noservicetype)") : new StringNode(builder.type);
                        this.clustertype = builder.clustertype == null ? new StringNode("(unknownclustertype)") : new StringNode(builder.clustertype);
                        this.clustername = builder.clustername == null ? new StringNode("(unknownclustername)") : new StringNode(builder.clustername);
                        this.configId = builder.configId == null ? new StringNode() : new StringNode(builder.configId);
                        this.index = builder.index == null ? new IntegerNode(0) : new IntegerNode(builder.index.intValue());
                        this.ports = Ports.createVector(builder.ports);
                        this.servicealiases = new LeafNodeVector(builder.servicealiases, (LeafNode)new StringNode());
                        this.endpointaliases = new LeafNodeVector(builder.endpointaliases, (LeafNode)new StringNode());
                    }

                    public String type() {
                        return this.type.value();
                    }

                    public String clustertype() {
                        return this.clustertype.value();
                    }

                    public String clustername() {
                        return this.clustername.value();
                    }

                    public String configId() {
                        return this.configId.value();
                    }

                    public int index() {
                        return this.index.value();
                    }

                    public List<Ports> ports() {
                        return this.ports;
                    }

                    public Ports ports(int i) {
                        return (Ports)((Object)this.ports.get(i));
                    }

                    public List<String> servicealiases() {
                        return this.servicealiases.asList();
                    }

                    public String servicealiases(int i) {
                        return ((StringNode)this.servicealiases.get(i)).value();
                    }

                    public List<String> endpointaliases() {
                        return this.endpointaliases.asList();
                    }

                    public String endpointaliases(int i) {
                        return ((StringNode)this.endpointaliases.get(i)).value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
                        return changes;
                    }

                    private static Map<String, Services> createMap(Map<String, Builder> builders) {
                        LinkedHashMap<String, Services> ret = new LinkedHashMap<String, Services>();
                        for (String key : builders.keySet()) {
                            ret.put(key, new Services(builders.get(key)));
                        }
                        return Collections.unmodifiableMap(ret);
                    }

                    public static final class Ports
                    extends InnerNode {
                        private final IntegerNode number;
                        private final StringNode tags;

                        public Ports(Builder builder) {
                            this(builder, true);
                        }

                        private Ports(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for lb-services.tenants{}.applications{}.hosts{}.services{}.ports[] must be initialized: " + builder.__uninitialized);
                            }
                            this.number = builder.number == null ? new IntegerNode(-1) : new IntegerNode(builder.number.intValue());
                            this.tags = builder.tags == null ? new StringNode("(notags)") : new StringNode(builder.tags);
                        }

                        public int number() {
                            return this.number.value();
                        }

                        public String tags() {
                            return this.tags.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(Ports newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("ports");
                            return changes;
                        }

                        private static InnerNodeVector<Ports> createVector(List<Builder> builders) {
                            ArrayList<Ports> elems = new ArrayList<Ports>();
                            for (Builder b : builders) {
                                elems.add(new Ports(b));
                            }
                            return new InnerNodeVector(elems);
                        }

                        public static class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private Integer number = null;
                            private String tags = null;

                            public Builder() {
                            }

                            public Builder(Ports config) {
                                this.number(config.number());
                                this.tags(config.tags());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.number != null) {
                                    this.number(__superior.number);
                                }
                                if (__superior.tags != null) {
                                    this.tags(__superior.tags);
                                }
                                return this;
                            }

                            public Builder number(int __value) {
                                this.number = __value;
                                return this;
                            }

                            private Builder number(String __value) {
                                return this.number(Integer.valueOf(__value));
                            }

                            public Builder tags(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.tags = __value;
                                return this;
                            }

                            public Ports build() {
                                return new Ports(this);
                            }
                        }
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("configId"));
                        private String type = null;
                        private String clustertype = null;
                        private String clustername = null;
                        private String configId = null;
                        private Integer index = null;
                        public List<Ports.Builder> ports = new ArrayList<Ports.Builder>();
                        public List<String> servicealiases = new ArrayList<String>();
                        public List<String> endpointaliases = new ArrayList<String>();

                        public Builder() {
                        }

                        public Builder(Services config) {
                            this.type(config.type());
                            this.clustertype(config.clustertype());
                            this.clustername(config.clustername());
                            this.configId(config.configId());
                            this.index(config.index());
                            for (Ports p : config.ports()) {
                                this.ports(new Ports.Builder(p));
                            }
                            this.servicealiases(config.servicealiases());
                            this.endpointaliases(config.endpointaliases());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.type != null) {
                                this.type(__superior.type);
                            }
                            if (__superior.clustertype != null) {
                                this.clustertype(__superior.clustertype);
                            }
                            if (__superior.clustername != null) {
                                this.clustername(__superior.clustername);
                            }
                            if (__superior.configId != null) {
                                this.configId(__superior.configId);
                            }
                            if (__superior.index != null) {
                                this.index(__superior.index);
                            }
                            if (!__superior.ports.isEmpty()) {
                                this.ports.addAll(__superior.ports);
                            }
                            if (!__superior.servicealiases.isEmpty()) {
                                this.servicealiases.addAll(__superior.servicealiases);
                            }
                            if (!__superior.endpointaliases.isEmpty()) {
                                this.endpointaliases.addAll(__superior.endpointaliases);
                            }
                            return this;
                        }

                        public Builder type(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.type = __value;
                            return this;
                        }

                        public Builder clustertype(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.clustertype = __value;
                            return this;
                        }

                        public Builder clustername(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.clustername = __value;
                            return this;
                        }

                        public Builder configId(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.configId = __value;
                            this.__uninitialized.remove("configId");
                            return this;
                        }

                        public Builder index(int __value) {
                            this.index = __value;
                            return this;
                        }

                        private Builder index(String __value) {
                            return this.index(Integer.valueOf(__value));
                        }

                        public Builder ports(Ports.Builder __builder) {
                            this.ports.add(__builder);
                            return this;
                        }

                        public Builder ports(List<Ports.Builder> __builders) {
                            this.ports = __builders;
                            return this;
                        }

                        public Builder servicealiases(String __value) {
                            this.servicealiases.add(__value);
                            return this;
                        }

                        public Builder servicealiases(Collection<String> __values) {
                            this.servicealiases.addAll(__values);
                            return this;
                        }

                        public Builder endpointaliases(String __value) {
                            this.endpointaliases.add(__value);
                            return this;
                        }

                        public Builder endpointaliases(Collection<String> __values) {
                            this.endpointaliases.addAll(__values);
                            return this;
                        }

                        public Services build() {
                            return new Services(this);
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private String hostname = null;
                    public Map<String, Services.Builder> services = new LinkedHashMap<String, Services.Builder>();

                    public Builder() {
                    }

                    public Builder(Hosts config) {
                        this.hostname(config.hostname());
                        for (Map.Entry<String, Services> __entry : config.services().entrySet()) {
                            this.services(__entry.getKey(), new Services.Builder(__entry.getValue()));
                        }
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.hostname != null) {
                            this.hostname(__superior.hostname);
                        }
                        this.services(__superior.services);
                        return this;
                    }

                    public Builder hostname(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.hostname = __value;
                        return this;
                    }

                    public Builder services(String __key, Services.Builder __value) {
                        this.services.put(__key, __value);
                        return this;
                    }

                    public Builder services(Map<String, Services.Builder> __values) {
                        this.services.putAll(__values);
                        return this;
                    }

                    public Hosts build() {
                        return new Hosts(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean activeRotation = null;
                public Map<String, Hosts.Builder> hosts = new LinkedHashMap<String, Hosts.Builder>();

                public Builder() {
                }

                public Builder(Applications config) {
                    this.activeRotation(config.activeRotation());
                    for (Map.Entry<String, Hosts> __entry : config.hosts().entrySet()) {
                        this.hosts(__entry.getKey(), new Hosts.Builder(__entry.getValue()));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.activeRotation != null) {
                        this.activeRotation(__superior.activeRotation);
                    }
                    this.hosts(__superior.hosts);
                    return this;
                }

                public Builder activeRotation(boolean __value) {
                    this.activeRotation = __value;
                    return this;
                }

                private Builder activeRotation(String __value) {
                    return this.activeRotation(Boolean.valueOf(__value));
                }

                public Builder hosts(String __key, Hosts.Builder __value) {
                    this.hosts.put(__key, __value);
                    return this;
                }

                public Builder hosts(Map<String, Hosts.Builder> __values) {
                    this.hosts.putAll(__values);
                    return this;
                }

                public Applications build() {
                    return new Applications(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Map<String, Applications.Builder> applications = new LinkedHashMap<String, Applications.Builder>();

            public Builder() {
            }

            public Builder(Tenants config) {
                for (Map.Entry<String, Applications> __entry : config.applications().entrySet()) {
                    this.applications(__entry.getKey(), new Applications.Builder(__entry.getValue()));
                }
            }

            private Builder override(Builder __superior) {
                this.applications(__superior.applications);
                return this;
            }

            public Builder applications(String __key, Applications.Builder __value) {
                this.applications.put(__key, __value);
                return this;
            }

            public Builder applications(Map<String, Applications.Builder> __values) {
                this.applications.putAll(__values);
                return this;
            }

            public Tenants build() {
                return new Tenants(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Tenants.Builder> tenants = new LinkedHashMap<String, Tenants.Builder>();

        public Builder() {
        }

        public Builder(LbServicesConfig config) {
            for (Map.Entry<String, Tenants> __entry : config.tenants().entrySet()) {
                this.tenants(__entry.getKey(), new Tenants.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.tenants(__superior.tenants);
            return this;
        }

        public Builder tenants(String __key, Tenants.Builder __value) {
            this.tenants.put(__key, __value);
            return this;
        }

        public Builder tenants(Map<String, Tenants.Builder> __values) {
            this.tenants.putAll(__values);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LbServicesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LbServicesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LbServicesConfig.CONFIG_DEF_NAMESPACE;
        }

        public LbServicesConfig build() {
            return new LbServicesConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

