/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IndexschemaConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "16f63b1b91380718a5cd8ae01e3bb0b2";
    public static final String CONFIG_DEF_NAME = "indexschema";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "indexfield[].name string", "indexfield[].indextype enum {VESPA, RISE} default=VESPA", "indexfield[].datatype enum { STRING, INT64, BOOLEANTREE } default=STRING", "indexfield[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE", "indexfield[].prefix bool default=false", "indexfield[].phrases bool default=false", "indexfield[].positions bool default=true", "indexfield[].averageelementlen int default=512", "fieldset[].name string", "fieldset[].field[].name string"};
    private final InnerNodeVector<Indexfield> indexfield;
    private final InnerNodeVector<Fieldset> fieldset;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public IndexschemaConfig(Builder builder) {
        this(builder, true);
    }

    private IndexschemaConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for indexschema must be initialized: " + builder.__uninitialized);
        }
        this.indexfield = Indexfield.createVector(builder.indexfield);
        this.fieldset = Fieldset.createVector(builder.fieldset);
    }

    public List<Indexfield> indexfield() {
        return this.indexfield;
    }

    public Indexfield indexfield(int i) {
        return (Indexfield)((Object)this.indexfield.get(i));
    }

    public List<Fieldset> fieldset() {
        return this.fieldset;
    }

    public Fieldset fieldset(int i) {
        return (Fieldset)((Object)this.fieldset.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(IndexschemaConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Fieldset
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Field> field;

        @Deprecated
        private Fieldset() {
            this(new Builder(), false);
        }

        public Fieldset(Builder builder) {
            this(builder, true);
        }

        private Fieldset(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for indexschema.fieldset[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.field = Field.createVector(builder.field);
        }

        public String name() {
            return this.name.value();
        }

        public List<Field> field() {
            return this.field;
        }

        public Field field(int i) {
            return (Field)((Object)this.field.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fieldset newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldset");
            return changes;
        }

        private static InnerNodeVector<Fieldset> createVector(List<Builder> builders) {
            ArrayList<Fieldset> elems = new ArrayList<Fieldset>();
            for (Builder b : builders) {
                elems.add(new Fieldset(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Fieldset());
        }

        public static final class Field
        extends InnerNode {
            private final StringNode name;

            @Deprecated
            private Field() {
                this(new Builder(), false);
            }

            public Field(Builder builder) {
                this(builder, true);
            }

            private Field(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for indexschema.fieldset[].field[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                return changes;
            }

            private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                ArrayList<Field> elems = new ArrayList<Field>();
                for (Builder b : builders) {
                    elems.add(new Field(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Field());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                private String name = null;

                public Builder() {
                }

                public Builder(Field config) {
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<Field.Builder> field = new ArrayList<Field.Builder>();

            public Builder() {
            }

            public Builder(Fieldset config) {
                this.name(config.name());
                for (Field f : config.field()) {
                    this.field(new Field.Builder(f));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.field.isEmpty()) {
                    this.field.addAll(__superior.field);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder field(Field.Builder __builder) {
                this.field.add(__builder);
                return this;
            }

            public Builder field(List<Field.Builder> __builders) {
                this.field = __builders;
                return this;
            }
        }
    }

    public static final class Indexfield
    extends InnerNode {
        private final StringNode name;
        private final Indextype indextype;
        private final Datatype datatype;
        private final Collectiontype collectiontype;
        private final BooleanNode prefix;
        private final BooleanNode phrases;
        private final BooleanNode positions;
        private final IntegerNode averageelementlen;

        @Deprecated
        private Indexfield() {
            this(new Builder(), false);
        }

        public Indexfield(Builder builder) {
            this(builder, true);
        }

        private Indexfield(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for indexschema.indexfield[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.indextype = builder.indextype == null ? new Indextype(Indextype.VESPA) : new Indextype(builder.indextype);
            this.datatype = builder.datatype == null ? new Datatype(Datatype.STRING) : new Datatype(builder.datatype);
            this.collectiontype = builder.collectiontype == null ? new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
            this.prefix = builder.prefix == null ? new BooleanNode(false) : new BooleanNode(builder.prefix.booleanValue());
            this.phrases = builder.phrases == null ? new BooleanNode(false) : new BooleanNode(builder.phrases.booleanValue());
            this.positions = builder.positions == null ? new BooleanNode(true) : new BooleanNode(builder.positions.booleanValue());
            this.averageelementlen = builder.averageelementlen == null ? new IntegerNode(512) : new IntegerNode(builder.averageelementlen.intValue());
        }

        public String name() {
            return this.name.value();
        }

        public Indextype.Enum indextype() {
            return (Indextype.Enum)((Object)this.indextype.value());
        }

        public Datatype.Enum datatype() {
            return (Datatype.Enum)((Object)this.datatype.value());
        }

        public Collectiontype.Enum collectiontype() {
            return (Collectiontype.Enum)((Object)this.collectiontype.value());
        }

        public boolean prefix() {
            return this.prefix.value();
        }

        public boolean phrases() {
            return this.phrases.value();
        }

        public boolean positions() {
            return this.positions.value();
        }

        public int averageelementlen() {
            return this.averageelementlen.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Indexfield newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("indexfield");
            return changes;
        }

        private static InnerNodeVector<Indexfield> createVector(List<Builder> builders) {
            ArrayList<Indexfield> elems = new ArrayList<Indexfield>();
            for (Builder b : builders) {
                elems.add(new Indexfield(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Indexfield());
        }

        public static final class Collectiontype
        extends EnumNode<Enum> {
            public static final Enum SINGLE = Enum.SINGLE;
            public static final Enum ARRAY = Enum.ARRAY;
            public static final Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

            public Collectiontype() {
                this.value = null;
            }

            public Collectiontype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SINGLE,
                ARRAY,
                WEIGHTEDSET;

            }
        }

        public static final class Datatype
        extends EnumNode<Enum> {
            public static final Enum STRING = Enum.STRING;
            public static final Enum INT64 = Enum.INT64;
            public static final Enum BOOLEANTREE = Enum.BOOLEANTREE;

            public Datatype() {
                this.value = null;
            }

            public Datatype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STRING,
                INT64,
                BOOLEANTREE;

            }
        }

        public static final class Indextype
        extends EnumNode<Enum> {
            public static final Enum VESPA = Enum.VESPA;
            public static final Enum RISE = Enum.RISE;

            public Indextype() {
                this.value = null;
            }

            public Indextype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                VESPA,
                RISE;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            private Indextype.Enum indextype = null;
            private Datatype.Enum datatype = null;
            private Collectiontype.Enum collectiontype = null;
            private Boolean prefix = null;
            private Boolean phrases = null;
            private Boolean positions = null;
            private Integer averageelementlen = null;

            public Builder() {
            }

            public Builder(Indexfield config) {
                this.name(config.name());
                this.indextype(config.indextype());
                this.datatype(config.datatype());
                this.collectiontype(config.collectiontype());
                this.prefix(config.prefix());
                this.phrases(config.phrases());
                this.positions(config.positions());
                this.averageelementlen(config.averageelementlen());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.indextype != null) {
                    this.indextype(__superior.indextype);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (__superior.collectiontype != null) {
                    this.collectiontype(__superior.collectiontype);
                }
                if (__superior.prefix != null) {
                    this.prefix(__superior.prefix);
                }
                if (__superior.phrases != null) {
                    this.phrases(__superior.phrases);
                }
                if (__superior.positions != null) {
                    this.positions(__superior.positions);
                }
                if (__superior.averageelementlen != null) {
                    this.averageelementlen(__superior.averageelementlen);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder indextype(Indextype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.indextype = __value;
                return this;
            }

            private Builder indextype(String __value) {
                return this.indextype(Indextype.Enum.valueOf(__value));
            }

            public Builder datatype(Datatype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Datatype.Enum.valueOf(__value));
            }

            public Builder collectiontype(Collectiontype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.collectiontype = __value;
                return this;
            }

            private Builder collectiontype(String __value) {
                return this.collectiontype(Collectiontype.Enum.valueOf(__value));
            }

            public Builder prefix(boolean __value) {
                this.prefix = __value;
                return this;
            }

            private Builder prefix(String __value) {
                return this.prefix(Boolean.valueOf(__value));
            }

            public Builder phrases(boolean __value) {
                this.phrases = __value;
                return this;
            }

            private Builder phrases(String __value) {
                return this.phrases(Boolean.valueOf(__value));
            }

            public Builder positions(boolean __value) {
                this.positions = __value;
                return this;
            }

            private Builder positions(String __value) {
                return this.positions(Boolean.valueOf(__value));
            }

            public Builder averageelementlen(int __value) {
                this.averageelementlen = __value;
                return this;
            }

            private Builder averageelementlen(String __value) {
                return this.averageelementlen(Integer.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Indexfield.Builder> indexfield = new ArrayList<Indexfield.Builder>();
        public List<Fieldset.Builder> fieldset = new ArrayList<Fieldset.Builder>();

        public Builder() {
        }

        public Builder(IndexschemaConfig config) {
            for (Indexfield i : config.indexfield()) {
                this.indexfield(new Indexfield.Builder(i));
            }
            for (Fieldset f : config.fieldset()) {
                this.fieldset(new Fieldset.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.indexfield.isEmpty()) {
                this.indexfield.addAll(__superior.indexfield);
            }
            if (!__superior.fieldset.isEmpty()) {
                this.fieldset.addAll(__superior.fieldset);
            }
            return this;
        }

        public Builder indexfield(Indexfield.Builder __builder) {
            this.indexfield.add(__builder);
            return this;
        }

        public Builder indexfield(List<Indexfield.Builder> __builders) {
            this.indexfield = __builders;
            return this;
        }

        public Builder fieldset(Fieldset.Builder __builder) {
            this.fieldset.add(__builder);
            return this;
        }

        public Builder fieldset(List<Fieldset.Builder> __builders) {
            this.fieldset = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return IndexschemaConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return IndexschemaConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return IndexschemaConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

